unit SoniqueVisTemplateUnit;

Interface
//====================================================================================
//
//	Sonique Visual Plugin API
//
//        (c) 1999 Sonique Team, edited by Rajesh Singh (shock@ihug.com.au)
//
//        Delphi Translation By George Boudouris 2009, (georgebou@hotmail.com)
//====================================================================================*/

uses
{  SysUtils,
  Classes,}
  Sonique_Vis_Delphi_Header,
  Windows,
  Classes,
  Graphics,
  SysUtils;

//====================================================================================
//	Definitions of the functions for Plug-In (don't change)
//====================================================================================*/

Procedure Initialize; cdecl;
Function Render(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean; cdecl;
Function SaveSettings(FileName:PChar):Boolean; cdecl;
Function OpenSettings(FileName:PChar):Boolean; cdecl;
Function DeInit:Boolean; cdecl;
Function Clicked (x,y,buttons:Integer):Boolean; cdecl;
Function ReceiveQueryInterface(PluginInterface:QueryInterface):Boolean; cdecl;

//====================================================================================
//	The actual details for your plugin
//
//	1. Reserved (leave as NULL)
//	2. Plug-In Name (char*, the name you want displayed when your plug-in is playing)
//	3. Options (VI_WAVEFORM - if you need the waveform PCM data
//	            VI_SPECTRUM - if you need the spectrum FFT data
//	   	    SONIQUEVISPROC - if you want user defined blurs to effect your plugin)
//	4. Name of the Initialize function (leave as is)
//	5. Name of the Render function (leave as is)
//	6. Name of the SaveSettings function (leave as is)
//	7. Name of the OpenSettings function (leave as is)
//====================================================================================*/

Const
     plugin:TVisInfo=(Version               : 1;
                      PluginName            : 'Sonique Vis Example with Text v1.0 by George Boudouris';
	                    lRequired             : VI_SPECTRUM Or SONIQUEVISPROC;
	                    Initialize            : Initialize;
	                    Render                : Render;
	                    SaveSettings          : SaveSettings;
	                    OpenSettings          : OpenSettings;
                      DeInit                : DeInit;
                      Clicked               : Clicked;
                      ReceiveQueryInterface : ReceiveQueryInterface);

Var
	 RenderBitmap: TBitmap;

// DLL exports this function - it should return a pointer to a static structure as above.
// files should be renamed from .DLL to .SVP
Function QueryModule : PVisInfo; cdecl; export;

Implementation

//*====================================================================================
//	Definition of the DLL export (don't change)
//====================================================================================*/
Function QueryModule : PVisInfo;
Begin
     Result := @plugin; //  Return the Module
End;

//*====================================================================================
// Definition of the Initialize function
//
// fill in with whatever you need to initialize, this gets called before the
// plug-in starts.
//
// you can leave it empty (as is).
//====================================================================================*/

Procedure Initialize;
Begin
     // Put Here the Initialize Code
     Set8087CW($133f); { Disable all fpu exceptions }

	   // initalize RenderBitmap
	   RenderBitmap := TBitmap.Create;
	   RenderBitmap.PixelFormat := pf32bit; // 32 bit for ABGR-values (Alpha, Blue, Green, Red)
End;

//*====================================================================================
//	Definition of the Render function
//
//	this is where you place your visual code,
//
//			Render should draw a whole frame into the 32 bit ABGR buffer (for blur, smoke
//			and zoom to work it should, rather than replacing the video data, add to it
//			using bitwise or, saturated add, or	alpha blend). Make sure not to exceed the
//			boundaries given. 'Pitch' specifies	the distance, in pixels, between the start
//			of each line. If you have a pointer	at the start of a line, Pointer+Pitch is
//			the start of the next line and Pointer-Pitch is the start of the previous.
//
//		this is the only function that you have to have something in.
//
//			Called for each frame. Pitch is in pixels and can be negative.
//			Render like this:
//			for (y = 0; y < height; y++)
//			{
//			   for (x = 0; x < width; x++)
//			      Video[x] = <pixel value>;
//			  Video += pitch;
//			}
//						OR
//			void PutPixel(int x, int y, unsigned long Pixel)
//			{
//			   _ASSERT( x >= 0 && x < width && y >= 0 && y < height );
//			  Video[y*pitch+x] = Pixel;
//			}
//
//		return TRUE when you've finished draw to the buffer.
//
//====================================================================================*/


Function Render(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean ;
Var
   x, y: Integer;
   VideoBuffer:PVideoBuffer;
   OldBkMode : integer;
   SaveTextStartY:Integer;
   SaveTextLineHeight:Integer;
   SaveTextLineYPos:Integer;

   Y1Axes,Y2Axes:Integer;
   MaxY:Integer;
   Counter:Integer;
   BufferCounter:Real;
   WaveFormStep:Real;

   SaveBKColor, SaveBarColor, SaveTextColor:Integer;
Begin
     VideoBuffer:=PVideoBuffer(Video);
     Try
	      // set the size of RenderBitmap
	      RenderBitmap.Width := Width;
	      RenderBitmap.Height := Height;

	      // render a black background
	      RenderBitmap.Canvas.Brush.Color := clBlack;
	      RenderBitmap.Canvas.Brush.Style := bsSolid;
	      RenderBitmap.Canvas.Pen.Color := clBlack;
	      RenderBitmap.Canvas.Pen.Style := psSolid;
	      RenderBitmap.Canvas.Rectangle(0, 0, Width, Height);

        SaveBKColor := $00FFA54A;
        SaveBarColor:= $00FEECCD;
        SaveTextColor:= clWhite;

        // Transpoarent Drawing Demo
//        RenderBitmap.Canvas.Font.Color := $00ffefcf;
        RenderBitmap.Canvas.Font.Color :=SaveTextColor;

	      // render a red unfilled rectangle from (10, 10) to (100, 100)
	      RenderBitmap.Canvas.Brush.Style := bsClear;
	      RenderBitmap.Canvas.Pen.Color := SaveBarColor;
	      RenderBitmap.Canvas.Rectangle(0, 0, Width, Height);


        RenderBitmap.Canvas.Brush.Color := SaveBKColor;
        RenderBitmap.Canvas.FillRect(Rect(0, 0, Width, Height));

  Try
     Y1Axes:=height Shr 1-1;
     Y2Axes:=height-1;
     MaxY:=height Shr 1;
     // travel the width of the buffer
     WaveFormStep:=SONIQUE_FFTStereoBufferSize/Width; // 50=Number of Waveform Samples that the Visual Effect Needs
     BufferCounter:=0;
     For x:= 0 To Width-1 Do Begin
         // draw the left channel spectrum data, making sure that if the data is greater then half the height
	 // of the buffer, then cut it down, so no buffer overuns...  and then do the same with the right
	 // channel data. (really simple no-expense paid example)

         // Fill Screen with color
         For y:=0 to Height-1 Do PVideoBuffer(Cardinal(Video)  + Cardinal(y * pitch + x)*4)^ := SaveBKColor;

         // I should be careful when accessing the pVD^.Spectrum[0,x] because
         // if  x gets higher than SONIQUE_FFTStereoBufferSize then the plugin hangs on Sonique because
         // we have a range check error
         y := Y1Axes - ((pVD^.Spectrum[0,Round(BufferCounter)]*MaxY) shr 7) ; // I can use shr 7 = Div 128 because values are not signed !!!!!!!
         if y < 0 then y := 0;

         RenderBitmap.Canvas.MoveTo(x,Y1Axes);
         RenderBitmap.Canvas.LineTo(x,y);


         // VideoBuffer^[y * pitch + x] := $ffcfefff;
         // Draw vert Line
//         For Counter:=Y To Y1Axes Do VideoBuffer^[Counter * pitch + x] := $ffcfefff;

         y := Y2Axes - ((pVD^.Spectrum[1,Round(BufferCounter)]*MaxY) shr 7) ;  // I can use shr 7 = Div 128 because values are not signed !!!!!!!
         if (y < Y2Axes - MaxY) then y := Y2Axes - MaxY;
         // VideoBuffer^[y * pitch + x] := $ffcfefff;
         // Draw vert Line
         RenderBitmap.Canvas.MoveTo(x,Y2Axes);
         RenderBitmap.Canvas.LineTo(x,y);

//         For Counter:=Y To Y2Axes Do VideoBuffer^[Counter * pitch + x] := $ffcfefff;


         BufferCounter:=BufferCounter+WaveFormStep;
     End;
     // draw the seperate channels line
     y:=height shr 1 ; //shr 1= Div 2;
     For x:= 0 To Width-1 Do PVideoBuffer(Cardinal(Video)  + Cardinal(y * pitch + x)*4)^ := $ff6fc0ff;
  Except

  End;

        RenderBitmap.Canvas.Brush.Color := clBlue;
        RenderBitmap.Canvas.TextOut(10, 20, 'Not Transparent!');


        OldBkMode := SetBkMode(RenderBitmap.Canvas.Handle, TRANSPARENT);
        RenderBitmap.Canvas.TextOut(10, 50, 'Transparent!');

        RenderBitmap.Canvas.Font.Name := 'Arial';
        RenderBitmap.Canvas.Font.Height :=-12;

        SaveTextStartY :=60;
        SaveTextLineHeight:=Abs(RenderBitmap.Canvas.Font.Height)+2;
        SaveTextLineYPos:=0;

        RenderBitmap.Canvas.TextOut(10, SaveTextStartY+SaveTextLineYPos, plugin.PluginName);
        Inc(SaveTextLineYPos, SaveTextLineHeight);
        RenderBitmap.Canvas.TextOut(10, SaveTextStartY+SaveTextLineYPos, 'Text 1');
        Inc(SaveTextLineYPos, SaveTextLineHeight);
        RenderBitmap.Canvas.TextOut(10, SaveTextStartY+SaveTextLineYPos, 'Text 2');
        Inc(SaveTextLineYPos, SaveTextLineHeight);
        RenderBitmap.Canvas.TextOut(10, SaveTextStartY+SaveTextLineYPos, 'Text 3');
        Inc(SaveTextLineYPos, SaveTextLineHeight);
        RenderBitmap.Canvas.TextOut(10, SaveTextStartY+SaveTextLineYPos, 'Text 4');
        Inc(SaveTextLineYPos, SaveTextLineHeight);
        RenderBitmap.Canvas.TextOut(10, SaveTextStartY+SaveTextLineYPos, 'Text 5');

        SetBkMode(RenderBitmap.Canvas.Handle, OldBkMode);  //Restore old Canvas Mode
	      // any other rendering operation...

	      (* VideoP points (like described above) to an array of 32 bit ABGR-values (Alpha, Blue, Green, Red). TBitmap also provides such
	      an array by the function ScanLine[Y]. It is therefore possible to copy memory directly without reading and writing each pixel.
	      But since Pitch can be both positive and negative you can not copy the whole array at once by CopyMemory because in one case the
	      bitmap would be mirrored at the x-axis. By copying line by line (with Pitch * 4 bytes distance) you can take care of this problem.
	      Each line has Width * 4 bytes. *)
	      for Y := 0 to Height - 1 do CopyMemory(Pointer(Cardinal(Video) + Cardinal(Y * Pitch * 4)), RenderBitmap.ScanLine[Y], Width * 4);
        // 	   for Y := 0 to Height - 1 do CopyMemory(Pointer(Cardinal(VideoP) + Cardinal(Y * Pitch * 4)), RenderBitmap.ScanLine[Y], Width * 4);

     Except

     End;

     Result:= TRUE;
End;



//*====================================================================================
//	Definition of the SaveSettings function
//
//		to save the settings of anything you want regarding your plugin.
//
//		use WritePrivateProfileString to save the settings.
//			ie. WritePrivateProfileString("my plugin", "brightness", "3", FileName);
//
//		return TRUE if the saving worked or FALSE if it failed.
//
//		you can leave it empty (as is).
//====================================================================================*/

Function SaveSettings(FileName:PChar):Boolean;
Begin
     Result:= TRUE;
End;

//*====================================================================================
//	Definition of the OpenSettings function
//
//		to open the settings of anything you want regarding your plugin.
//
//		use GetPrivateProfileString to save the settings.
//			ie. char BrightnessBuffer[256];
//				GetPrivateProfileString("my plugin", "brightness", "3", BrightnessBuffer, sizeof(BrightnessBuffer), FileName);
//
//		return TRUE if the opening worked or FALSE if it failed.
//
//		you can leave it empty (as is).
//====================================================================================*/

Function OpenSettings(FileName:PChar):Boolean;
Begin
     Result:= TRUE;
End;

Function DeInit:Boolean;
Begin
	   // free RenderBitmap
     RenderBitmap.Free;

     Result:= TRUE;
End;

Function Clicked(x,y,buttons:Integer):Boolean;
Begin
     // Put Here the Code
     Result:= TRUE;
End;

Function ReceiveQueryInterface(PluginInterface:QueryInterface): Boolean;
Begin
     // Put Here the Code
     Result:= TRUE;
End;

Begin
     // It is recommended that you disable all floating-point exceptions when
     // using OpenGL to render 3D graphics. To do this, call Set8087CW(0x133f)
     // in your main forms OnCreate event before calling any OpenGL functions.
     // Set8087CW($133f);
end.
