unit PsychoJMDGUnit;

Interface

uses
  PsychoJMDGHeader, Math;

Procedure Initialize(); cdecl;
Function Render(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean; cdecl;
Function SaveSettings(FileName:PChar):Boolean; cdecl;
Function OpenSettings(FileName:PChar):Boolean; cdecl;
Function DeInit:Boolean; cdecl;
Function Clicked (x,y,buttons:Integer):Boolean; cdecl;
Function ReceiveQueryInterface(PluginInterface:QueryInterface):Boolean; cdecl;

Function MakeColor(Red, Green, Blue:Double):Cardinal; cdecl;
Function WaveVis1(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean; cdecl;
Function WaveVis2(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean; cdecl;
Function WaveVis3(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean; cdecl;
Function WaveVisX(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData;r1, g1, b1, r2, g2, b2:Integer):Boolean; cdecl;

Procedure InitWaveVis1(); cdecl;
Procedure InitWaveVis2(); cdecl;
Procedure InitWaveVis3(); cdecl;
Procedure InitWaveVisX(); cdecl;

Const
     plugin:TVisInfo=(Version               : 1;
                      PluginName            : 'Psycho visual plugin by JM-DG';
	                    lRequired             : VI_WAVEFORM or VI_SPECTRUM Or SONIQUEVISPROC;
	                    Initialize            : Initialize;
	                    Render                : Render;
	                    SaveSettings          : SaveSettings;
	                    OpenSettings          : OpenSettings;
                      DeInit                : DeInit;
                      Clicked               : Clicked;
                      ReceiveQueryInterface : ReceiveQueryInterface);

Var
  r, g, b, c:Double;
  rdec, gdec, bdec, rinc, ginc, binc, initwidth, rs, gs, bs, t:Integer;
  SaveCurrentEffect:Integer;
  r1,r2,r3,r4,r5,r6:Integer;

Function QueryModule : PVisInfo; cdecl; export;

Implementation

Function QueryModule : PVisInfo;
Begin
     Result := @plugin;
End;

Procedure Initialize;
Begin
    Set8087CW($133f);
    SaveCurrentEffect:=0;
    r:=255;
    g:=0;
    b:=0;
    c:=1;

    rdec:=0;
    gdec:=0;
    bdec:=0;
    rinc:=0;
    ginc:=1;
    binc:=0;

    initwidth:=0;
    rs:=1;
    gs:=2;
    bs:=3;
    t:=0;

    r1:=400;
    r2:=400;
    r3:=200;
    r4:=0;
    r5:=80;
    r6:=250;
    Randomize();
End;

Function WaveVis1(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean ;
var x, y, d, seccol, firstcol:Integer;
label check1;
label check2;
begin
if ((initwidth<>width)or(initwidth=0)) then
  begin
    initwidth:=width;
    c:=1;
  end;

x:=0;
while x<width Do
  begin
    inc(x);
		d:=(width div width * 2);

		r:=(x * (d * 6))/c;
    g:=(x * (d * 3))/c;
    b:=(x * (d * 1))/c;

		if ((r>255) and (g>255) and (b>255)) then c:=c+0.01;

		y:= ((height div 2) - (pVD^.Waveform[0][x and 255]));
		if(y < 2) then y:= (height div 2);

firstcol:= MakeColor(r,g,b);
seccol:=   MakeColor(r-80,g-80,b-80);

check1: if (y>height) then
  begin
    dec(y);
    goto check1;
  end;
if (y<0) then
  begin
  inc (y);
  goto check1;
  end;

		PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x)*4)^:= firstcol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;

    y:= ((height div 2) + (pVD^.Waveform[1][x and 255]));
		if(y > (height-3)) then y:= height div 2;

	firstcol:=  MakeColor(b, g, r);
	seccol:=    MakeColor(b-80, g-80, r-80);
	
check2: if (y>height) then
begin
  dec(y);
  goto check2;
end; 
if (y<0) then
  begin
    inc(y);
    goto check2;
  end;
    PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x)*4)^:= firstcol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;

	end;
	Result:= TRUE;
end;

Function WaveVis2(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean ;
var x, y, seccol:Integer;
label check1;
label check2;

begin
x:=0;
while x<width Do
  begin
  inc(x);
	if(rinc=1)then begin
    r:=r+0.05;
    if(r>255)then begin
      bdec:=1;
      rinc:=0;
    end;
  end;

	if(ginc=1)then begin
    g:=g+0.05;
    if(g>255)then begin
      rdec:=1;
      ginc:=0;
    end;
  end;

	if(binc=1)then begin
    b:=b+0.05;
    if(b>255)then begin
      gdec:=1;
      binc:=0;
    end;
  end;

	if(rdec=1)then begin
    r:=r-0.05;
    if(r<0) then begin
      rdec:=0;
      binc:=1;
    end;
  end;

	if(gdec=1)then
  begin
    g:=g-0.05;
    if(g<0)then
    begin
      rinc:=1;
      gdec:=0;
    end;
  end;

	if(bdec=1)then
  begin
    b:=b-0.05;
    if(b<0)then
    begin
      ginc:=1;
      bdec:=0;
    end;
  end;

  y:= ((height div 2) - (pVD^.Waveform[0][x and 255]));
  if(y < 2) then y:= height div 2;

check1: if (y>height) then
  begin
    dec(y);
    goto check1;
  end;
if (y<0) then
  begin
    inc(y);
    goto check1;
  end;
  PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x )*4)^:= MakeColor(r, g, b);
  seccol:=MakeColor(r-80,g-80,b-80);
  PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
  PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;
  PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
  PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;

  y:= ((height div 2) + (pVD^.Waveform[1][x and 255]));
  if(y > (height-3)) then y:= height div 2;

check2: if (y>height)then
  begin
    dec(y);
    goto check2;
  end;
if (y<0) then
  begin
    inc(y);
    goto check2;
  end;

  PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x )*4)^:= MakeColor(b, r, g);
  seccol:=MakeColor(b-80,r-80,g-80);
  PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
  PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;
  PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
  PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;

	end;
  Result:= TRUE;
end;

Function WaveVis3(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean ;
var x, y, seccol:Integer;
label check1;
label check2;
begin

	r:=r+rs;
  if (r>255) then rs:=-rs;
  if (r<80) then rs:=-rs;
	g:=g+gs;
  if (g>255) then gs:=-gs;
  if (g<80) then gs:=-gs;
	b:=b+bs;
  if (b>255) then bs:=-bs;
  if (b<80) then bs:=-bs;
  x:=0;
  while x<width Do
  begin
    inc(x);

    y:= ((height div 2) - (pVD^.Waveform[0][x and 255]));
		if(y < 2) then y:= height div 2;

check1: if (y>height)then
begin
  dec(y);
  goto check1;
end;
if (y<0) then
  begin
    inc(y);
    goto check1;
  end;

    PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x )*4)^:= MakeColor(r, g, b);
    seccol:=MakeColor(r-80,g-80,b-80);
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;

    y:= ((height div 2) + (pVD^.Waveform[1][x and 255]));
		if(y > (height-1)) then y:= height div 2;

check2: if (y>height)then
  begin
    dec(y);
    goto check2;
  end;
if (y<0) then
  begin
    inc(y);
    goto check2;
  end;

    PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x )*4)^:= MakeColor(g, b, r);
		seccol:=MakeColor(g-80, b-80, r-80);
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;
	end;
    Result:= TRUE;
end;

Function WaveVisX(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData;r1, g1, b1, r2, g2, b2:Integer):Boolean ;
var x, y, seccol:Integer;
label check1;
label check2;
begin
  x:=0;
  while x<width Do
  begin
  inc(x);
    y:= ((height div 2) - (pVD^.Waveform[0][x and 255]));
		if(y < 2) then y:= height div 2;

check1: if (y>height) then
  begin
    dec(y);
    goto check1;
  end;
if (y<0)then
  begin
    inc(y);
    goto check1;
  end;

    PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x )*4)^:= MakeColor(r1,g1,b1);
		seccol:=MakeColor(r1-80,g1-80,b1-80);
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;

    y:= ((height div 2) + (pVD^.Waveform[1][x and 255]));
		if(y > (height-1))then y:= height div 2;

check2: if (y>height)then
  begin
   dec(y);
   goto check2;
  end;

if (y<0)then
  begin
    inc(y);
    goto check2;
  end;

    PVideoBuffer(Cardinal(Video) + Cardinal(y*pitch + x )*4)^:= MakeColor(r2,g2,b2);
		seccol:=MakeColor(r2-80,g2-80,b2-80);
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)+1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y*pitch + x)-1)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y+1)*pitch + x)*4)^:= seccol;
    PVideoBuffer(Cardinal(Video) + Cardinal((y-1)*pitch + x)*4)^:= seccol;
	end;
    Result:= TRUE;
end;

Procedure InitWaveVis1();
begin
  r:=0;
  g:=0;
  b:=0;
  c:=1;
  rdec:=0;
  gdec:=0;
  bdec:=0;
  rinc:=0;
  ginc:=1;
  binc:=0;
  initwidth:=0;
end;

Procedure InitWaveVis2();
begin
  r:=255;
  g:=0;
  b:=0;
  rdec:=0;
  gdec:=0;
  bdec:=0;
  rinc:=0;
  ginc:=1;
  binc:=0;
end;

Procedure InitWaveVis3();
begin
  r:=255;
  g:=255;
  b:=255;
  rs:=1;
  gs:=2;
  bs:=3;
end;

Procedure InitWaveVisX();
begin
InitWaveVis2();
end;

Function MakeColor(Red, Green, Blue:Double):Cardinal;
begin
  if(Red > 255) then Red:=255;
  if(Red<0) then Red:=0;
  if(Green > 255) then Green:=255;
  if(Green<0) then Green:=0;
  if(Blue > 255) then Blue:=255;
  if(Blue<0) then Blue:=0;
  Red:=Red*65536;
  Green:=Green*256;
  Result:=round(Red+Green+Blue);
end;

Function Render(Video:PCardinal;width,height,pitch:Integer;pVD:PVisData):Boolean ;
Begin
  inc(t);
  Case SaveCurrentEffect of
      0: Begin
        if (t=1) then InitWaveVis1();
        if (t>0) and (t<200)	then WaveVis1(Video, width, height, pitch, pVD);
	      if (t=201) then InitWaveVisX();
	      if (t>200) and (t<300) then WaveVisX(Video, width, height, pitch, pVD, 400,400,80,80,400,80);
	      if (t=301) then InitWaveVis2();
	      if (t>300) and (t<500) then WaveVis2(Video, width, height, pitch, pVD);
	      if (t=501) then InitWaveVisX();
	      if (t>500) and (t<700) then WaveVisX(Video, width, height, pitch, pVD, 260,260,260, 0,200,400);
	      if (t=701) then InitWaveVis3();
	      if (t>700) and (t<900) then WaveVis3(Video, width, height, pitch, pVD);
	      if (t>=900) then t:=0;
      End;
      1: Begin
        if (t=1) then InitWaveVisX();
        if (t>0) and (t<100) then WaveVisX(Video, width, height, pitch, pVD, r1,r2,r3,r4,r5,r6);
	      if (t=101) then InitWaveVisX();
	      if (t>100) and (t<200) then WaveVisX(Video, width, height, pitch, pVD, r3,r6,r4,r1,r2,r5);
	      if (t>=200) then begin
          r1 := RandomRange(0, 400);
          r2 := RandomRange(0, 400);
          r3 := RandomRange(0, 400);
          r4 := RandomRange(0, 400);
          r5 := RandomRange(0, 400);
          r6 := RandomRange(0, 400);
          t:=0;
        end;
      End;
  End;
	Result:= TRUE;
end;

Function SaveSettings(FileName:PChar):Boolean;
Begin
     Result:= TRUE;
End;

Function OpenSettings(FileName:PChar):Boolean;
Begin
     Result:= TRUE;
End;

Function DeInit:Boolean;
Begin
     Result:= TRUE;
End;

Function Clicked(x,y,buttons:Integer):Boolean;
Begin
Inc(SaveCurrentEffect);
     If SaveCurrentEffect>1 Then SaveCurrentEffect:=0;
     Result:= TRUE;
End;

Function ReceiveQueryInterface(PluginInterface:QueryInterface): Boolean;
Begin
     Result:= TRUE;
End;

Begin

end.
