unit PsychoJMDGHeader;

interface

Type
    PVideoBuffer=PCardinal;

Const
     ALPHA_MASK  =$FF000000;
     RED_MASK    =$00FF0000;
     GREEN_MASK  =$0000FF00;
     BLUE_MASK   =$000000FF;

     ALPHA_SHIFT =24;
     RED_SHIFT   =16;
     GREEN_SHIFT =8;
     BLUE_SHIFT  =0;

Function AlphaByte(x:Integer):Integer;
Function RedByte(x:Integer):Integer;
Function GreenByte(x:Integer):Integer;
Function BlueByte(x:Integer):Integer;
Function MakeColour(a, r, g, b:Integer):Integer;
Const
     VI_WAVEFORM    =$0001;
     VI_SPECTRUM    =$0002;
     SONIQUEVISPROC =$0004;

Const
     SONIQUE_WaveformStereoBufferSize=512;
     SONIQUE_FFTStereoBufferSize=256;
type
    PVisData = ^TVisData;
    TVisData=Record
       MillSec:Cardinal;
       Waveform: array [0..1, 0..SONIQUE_WaveformStereoBufferSize-1] of Byte;
       Spectrum: array [0..1, 0..SONIQUE_FFTStereoBufferSize-1] of Byte;
    End;

Type
    QueryInterface = class
     private

     protected

     public
	   Function QueryInt(expression:PChar;Value:PInteger):Boolean; virtual;
	   Function QueryString(expression:PChar):PChar; virtual;
           Procedure FreeString(SaveString:PChar); virtual;
     end;

type
    PVisInfo=^TVisInfo;
    TVisInfo=Record
Version               : Cardinal;
PluginName            : PChar;
lRequired             : LongInt;
Initialize            : procedure; cdecl;
Render                : Function (Video:PCardinal;width,height,pitch:Integer;pVD:PVisData) : Boolean ; cdecl;
SaveSettings          : Function(FileName:PChar): Boolean; cdecl;
OpenSettings          : Function(FileName:PChar): Boolean; cdecl;

Deinit                : Function: Boolean; cdecl;
Clicked               : Function(x,y,buttons:Integer) : Boolean; cdecl;
ReceiveQueryInterface : Function(PluginInterface:QueryInterface): Boolean; cdecl;
End;

implementation

Function AlphaByte(x:Integer):Integer;
Begin
     Result:=x Shr ALPHA_SHIFT;
End;

Function RedByte(x:Integer):Integer;
Begin
     Result:=(x And RED_MASK) Shr RED_SHIFT;
End;

Function GreenByte(x:Integer):Integer;
Begin
      Result:=(x And GREEN_MASK) Shr GREEN_SHIFT;
End;

Function BlueByte(x:Integer):Integer;
Begin
     Result:=(x And BLUE_MASK) Shr BLUE_SHIFT;
End;

Function MakeColour(a, r, g, b:Integer):Integer;
Begin
     Result:=(a Shr ALPHA_SHIFT) +
              ((r And RED_MASK) Shr RED_SHIFT) +
              ((g And GREEN_MASK) Shr GREEN_SHIFT) +
              ((b And BLUE_MASK) Shr BLUE_SHIFT);
End;

Function QueryInterface.QueryInt(expression:PChar;Value:PInteger):Boolean;
Begin

End;

Function QueryInterface.QueryString(expression:PChar):PChar; 
Begin

End;

Procedure QueryInterface.FreeString(SaveString:PChar);
Begin

End;

end.
