//-------------------------------------------------\\
//     Passion Audio Player DSP Plugins SDK        \\
//     Copyright (c) 2005-2007, George Boudouris.  \\
//     Feel free to use this code for creating     \\
//     DSP plugins for Passion Audio Player        \\
//-------------------------------------------------\\

unit winamp_wrapper_formunit;

interface

// Known issues:
// 1. dsp_tool.dll : It causes several exceptions even when using loadlibrary
//                   to load it and get the Description in the onshow procedure.
//                   It caused amess until i found out that it was the only plugin
//                   that caused error messages.
//                   The error is wholy caused inside the loadlibrary function and
//                   NOT in my code
// 2. dsp_ady.dll  :  When it's window is attached to winamp_wrapper_Form
//                    when i try to change plugin by clicking listbox i get
//                    a runtime error possible due to plugin cleanup code error
// 3. dsp_TLV1.dll :  I get several runtime errors when trying to move it's window
//                    when not playing a song and the DSP has not been installed yet
//                    possibly due to plugin internal error

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, WinAmp_DSP_Delphi_Header, ComCtrls, IniFiles;

type
  Twinamp_wrapper_Form = class(TForm)
    ListBox1: TListBox;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    Button2: TButton;
    StatusBar1: TStatusBar;
    procedure FormShow(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    Available_Plugins_Root_Dir:String;
    Parent_Window_Handle : THandle;
    Current_WinAmpDSPCurrentPluginName:String;
    Current_WinAmpDSPCurrentPluginModule : Integer;
    Current_WinAmpDSPCurrentPluginInitialized : Boolean;

    Procedure GetFilesFromDirectoryAndBelowAndFromSubdirectories (Directory,FilesMask:String;ListToAddThem:TStrings);
    Procedure LoadDataFromIniFile;
    Procedure SaveDataToIniFile;

    constructor Create(Owner: TComponent); override;
    destructor Destroy; override;
  end;

var
  winamp_wrapper_Form: Twinamp_wrapper_Form;

Const
     None_WinampDSP_DSPPlugin='None';
     DSPPLUGINTYPE_WinampDSPPlugin_IDString='DSP_';

Var
   SaveWinAmpDSPPluginsPaths:TStrings;

Var
   InputWinampDSPModule_Handle : THandle;
   CurrentWinampDSPModule : PwinampDSPModule;

Procedure UnLoad_Winamp_DSP_DLL;

implementation

{$R *.dfm}

Uses
    ppdsp_sdk_code;

constructor Twinamp_wrapper_Form.Create(Owner: TComponent);
begin
     inherited Create(Owner);  // Initialize inherited parts

     SaveWinAmpDSPPluginsPaths := TStringList.Create;	{ construct the list object }

     LoadDataFromIniFile;
end;

destructor Twinamp_wrapper_Form.Destroy;
begin
     SaveDataToIniFile;

     SaveWinAmpDSPPluginsPaths.Free;
     inherited Destroy;
end;

Procedure GetFilesOfDirectory(Directory,FilesMask:String;ListToAddThem:TStrings);
var
   sr: TSearchRec;
   FileAttrs: Integer;
   SaveDirectory:String;
   SavePath, SaveArtist, SaveTitle:String;
begin
     SaveDirectory:=IncludeTrailingPathDelimiter(Directory);
     if FindFirst(SaveDirectory+FilesMask,faAnyFile,sr)=0 Then Begin
        repeat
              ListToAddThem.Add(SaveDirectory+sr.Name);     // Add the line to the memo
        until FindNext(sr) <> 0;
        FindClose(sr);
    end;
end;

// The function below lists All the files Below this directory and subdirecories
Procedure Twinamp_wrapper_Form.GetFilesFromDirectoryAndBelowAndFromSubdirectories (Directory,FilesMask:String;ListToAddThem:TStrings);
var
   sr: TSearchRec;
   FileAttrs: Integer;
   SaveDirectory:String;
   SavePath, SaveArtist, SaveTitle:String;
Begin
     SaveDirectory:=IncludeTrailingPathDelimiter(Directory);
     // Get Files of the Root of this Directory
     GetFilesOfDirectory(Directory,FilesMask,ListToAddThem);
     // Get Files of this Directory Subdirectories
     If FindFirst(SaveDirectory+'*.*',faDirectory,sr)=0 Then Begin
        repeat
              If (sr.Name <> '.') And (sr.Name <> '..') Then Begin
                 // Call Again my self
                 GetFilesFromDirectoryAndBelowAndFromSubdirectories (SaveDirectory+sr.Name,FilesMask,ListToAddThem);
              End;
        until FindNext(sr) <> 0;
        FindClose(sr);
     End;
End;

Function GetDllPath(InputDLLInstance : THandle) : String;
var
  TheFileName : array[0..MAX_PATH] of char;
begin
     FillChar(TheFileName, sizeof(TheFileName), #0);
     GetModuleFileName(hInstance, TheFileName, sizeof(TheFileName));
//     MessageBox(0, TheFileName, 'The DLL file name is:', mb_ok);
     Result := TheFileName;
end;

Procedure Twinamp_wrapper_Form.LoadDataFromIniFile;
var
  Ini: TIniFile;
Begin
     Ini := TIniFile.Create(ChangeFileExt(GetDllPath( ppdsp_Plugin_Interface.dsp_hDllInstance ),'.ini'));
     try
        Current_WinAmpDSPCurrentPluginName   := Ini.ReadString ( 'winamp_wrapper', 'Plugin_Selected', None_WinampDSP_DSPPlugin);
        Current_WinAmpDSPCurrentPluginModule := Ini.ReadInteger( 'winamp_wrapper', 'Module_Selected', 0);
        CheckBox1.Checked                    := Ini.ReadBool   ( 'winamp_wrapper', 'Plugin_Enabled', false );

     finally
            Ini.Free;
     end;
End;

Procedure Twinamp_wrapper_Form.SaveDataToIniFile;
var
  Ini: TIniFile;
Begin
     Ini := TIniFile.Create(ChangeFileExt(GetDllPath( ppdsp_Plugin_Interface.dsp_hDllInstance ),'.ini'));
     try
        Ini.WriteString  ( 'winamp_wrapper', 'Plugin_Selected', Current_WinAmpDSPCurrentPluginName);
        Ini.WriteInteger ( 'winamp_wrapper', 'Module_Selected', Current_WinAmpDSPCurrentPluginModule);
        Ini.WriteBool    ( 'winamp_wrapper', 'Plugin_Enabled', CheckBox1.Checked);
     finally
            Ini.Free;
     end;
End;

Procedure winampDSP_SelectModule(InputModuleNum:Integer);
Begin
     winamp_wrapper_Form.Current_WinAmpDSPCurrentPluginModule := InputModuleNum;
     // Set Current Module
     CurrentWinampDSPModule := winampDSPGetHeader2^.getModule(winamp_wrapper_Form.Current_WinAmpDSPCurrentPluginModule);
     CurrentWinampDSPModule.hwndParent   := winamp_wrapper_Form.Parent_Window_Handle;
     CurrentWinampDSPModule.hDllInstance := InputWinampDSPModule_Handle;
     CurrentWinampDSPModule.Init(CurrentWinampDSPModule);
     winamp_wrapper_Form.Current_WinAmpDSPCurrentPluginInitialized := True;
End;

Procedure winampDSP_FreeSelectedModule;
Begin
     If winamp_wrapper_Form.Current_WinAmpDSPCurrentPluginInitialized = True Then Begin
        winamp_wrapper_Form.Current_WinAmpDSPCurrentPluginInitialized := False;
        CurrentWinampDSPModule.Quit(CurrentWinampDSPModule);
        CurrentWinampDSPModule := Nil;
     End;
End;

Procedure Load_Winamp_DSP_DLL(InputFilename:String);
Var
   TempModule:PWinampDSPModule;
   ModulesAvailable:Integer;
Begin
     If InputWinampDSPModule_Handle<>0 Then UnLoad_Winamp_DSP_DLL;

     // ******** Put Here the plugin Initialize code ********
     InputWinampDSPModule_Handle:=LoadLibrary(PChar(InputFilename));
     If InputWinampDSPModule_Handle<>0 Then Begin
        @winampDSPGetHeader2:=GetProcAddress(InputWinampDSPModule_Handle,pchar('winampDSPGetHeader2'));
        ModulesAvailable:=0;
        If Assigned(winampDSPGetHeader2) Then Begin
           winamp_wrapper_Form.StatusBar1.SimpleText:= ExtractFileName(InputFilename);
           winamp_wrapper_Form.ComboBox1.Clear;
           Repeat
                 TempModule:=winampDSPGetHeader2^.getModule(ModulesAvailable);
                 If Assigned(TempModule) Then Begin
                    winamp_wrapper_Form.ComboBox1.Items.Add(TempModule.description);
                    Inc(ModulesAvailable);
                 End;
           Until Not Assigned(TempModule);
           Try
              winamp_wrapper_Form.Label2.Caption := 'Available Modules: '+IntToStr(ModulesAvailable);
              winampDSP_SelectModule(0);
              winamp_wrapper_Form.ComboBox1.ItemIndex := winamp_wrapper_Form.Current_WinAmpDSPCurrentPluginModule;
           Except

           End;
        End
        Else Begin

        End;
     End
     Else Begin
          ShowMessage('Error while LOADING the current File: '+Chr(13)+InputFilename); 
     End;
End;

Procedure UnLoad_Winamp_DSP_DLL;
Begin
     If InputWinampDSPModule_Handle<>0 Then Begin
        Application.ProcessMessages;

        winampDSP_FreeSelectedModule;

        FreeLibrary(InputWinampDSPModule_Handle);
        InputWinampDSPModule_Handle :=0 ;
     End;
End;

procedure Twinamp_wrapper_Form.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
     Application.Handle:=0;
end;

procedure Twinamp_wrapper_Form.FormShow(Sender: TObject);
Var
   Counter:Integer;
   SaveItemIndex:Integer;
   SavePath:String;
   SaveCurrentItemModule:Integer;

   TempHeader: Function :PwinampDSPHeader; stdcall;
   TempHandle : THandle;
begin
     ListBox1.Clear;
     SaveWinAmpDSPPluginsPaths.Clear;
     SaveWinAmpDSPPluginsPaths.Add(IncludeTrailingPathDelimiter(Available_Plugins_Root_Dir)+None_WinampDSP_DSPPlugin);
     GetFilesFromDirectoryAndBelowAndFromSubdirectories(IncludeTrailingPathDelimiter(Available_Plugins_Root_Dir),DSPPLUGINTYPE_WinampDSPPlugin_IDString+'*.dll',SaveWinAmpDSPPluginsPaths);

     For Counter:=0 To SaveWinAmpDSPPluginsPaths.Count-1 Do Begin
         ListBox1.Items[Counter]:=ExtractFileName(SaveWinAmpDSPPluginsPaths[Counter]);

//*** Debugging code for a specific dll -------->  If ExtractFileName(SaveWinAmpDSPPluginsPaths[Counter])<>'dsp_tool.dll' Then Begin
         Try
            TempHandle:=LoadLibrary(PChar(SaveWinAmpDSPPluginsPaths[Counter]));
            If TempHandle<>0 Then Begin
               @TempHeader:=GetProcAddress(TempHandle,pchar('winampDSPGetHeader2'));
               If Assigned(TempHeader) Then Begin
                  ListBox1.Items[Counter] := ListBox1.Items[Counter] +'  ('+TempHeader.Description+')  ';
               End;
            End;
         Except

         End;

         FreeLibrary(TempHandle);
         @TempHeader := Nil;
         TempHandle:=0;
//*** Debugging code for a specific dll -------->  End;

         If UpperCase(SaveWinAmpDSPPluginsPaths[Counter])=UpperCase(Current_WinAmpDSPCurrentPluginName) Then Begin
            SaveItemIndex:=Counter;

            SaveCurrentItemModule := Current_WinAmpDSPCurrentPluginModule; // Save It Because ListBox1Click Changes it
            ListBox1.ItemIndex:=SaveItemIndex;
            ListBox1Click(Sender);

            // Below If SaveCurrentItemModule = 0 Then the current module loaded
            // at Load_Winamp_DSP_DLL is the correct so don't reload it
            If SaveCurrentItemModule>0 Then Begin
               Current_WinAmpDSPCurrentPluginModule := SaveCurrentItemModule; // Restore It Because ListBox1Click Changes it
               ComboBox1.ItemIndex := Current_WinAmpDSPCurrentPluginModule;
               ComboBox1Change(Sender);
            End;
         End;
     End;

     Label1.Caption:= 'Available DSP Plugins: '+IntToStr(ListBox1.Items.Count);
end;

procedure Twinamp_wrapper_Form.CheckBox1Click(Sender: TObject);
begin
     winamp_DSP_Proc_Enabled:=CheckBox1.Checked;
end;

procedure Twinamp_wrapper_Form.ListBox1Click(Sender: TObject);
begin
     If ListBox1.ItemIndex>0 Then Begin
        UnLoad_Winamp_DSP_DLL;
        Load_Winamp_DSP_DLL(SaveWinAmpDSPPluginsPaths[ListBox1.ItemIndex]);
        Current_WinAmpDSPCurrentPluginName:=SaveWinAmpDSPPluginsPaths[ListBox1.ItemIndex];
     End
     Else Begin
          UnLoad_Winamp_DSP_DLL;
          Current_WinAmpDSPCurrentPluginName:=IncludeTrailingPathDelimiter(Available_Plugins_Root_Dir)+None_WinampDSP_DSPPlugin;
          winamp_wrapper_Form.Label2.Caption := 'Available Modules: '+'0';
          winamp_wrapper_Form.StatusBar1.SimpleText:= None_WinampDSP_DSPPlugin;
          winamp_wrapper_Form.ComboBox1.Clear;
          winamp_wrapper_Form.ComboBox1.Items.Add(None_WinampDSP_DSPPlugin);
          Current_WinAmpDSPCurrentPluginModule := 0;
          winamp_wrapper_Form.ComboBox1.ItemIndex := Current_WinAmpDSPCurrentPluginModule;
     End;
end;

procedure Twinamp_wrapper_Form.ComboBox1Change(Sender: TObject);
begin
     If Assigned(CurrentWinampDSPModule) Then Begin
        Try
           winampDSP_FreeSelectedModule;
           winampDSP_SelectModule(winamp_wrapper_Form.ComboBox1.ItemIndex);
        Except

        End;
     End;
end;

procedure Twinamp_wrapper_Form.Button2Click(Sender: TObject);
begin
     If Assigned(CurrentWinampDSPModule) Then Begin
        // This Config function is for configuring the current winamp plugin
        CurrentWinampDSPModule.Config(CurrentWinampDSPModule);
     End;
end;

end.
