//-------------------------------------------------\\
//     Passion Audio Player DSP Plugins SDK        \\
//     Copyright (c) 2005-2007, George Boudouris.  \\
//     Feel free to use this code for creating     \\
//     DSP plugins for Passion Audio Player        \\
//-------------------------------------------------\\

unit ppdsp_sdk_code;

interface

Uses
    Forms, ppdsp_sdk_header, WinAmp_DSP_Delphi_Header, winamp_wrapper_formunit;

// **********************************************
// Definitions of procedure for plugin
// **********************************************
Function dsp_plugin_Initialize (dsp_plugin_Root_Dir : PChar):Integer; stdcall;
procedure dsp_plugin_Config; stdcall;
procedure dsp_plugin_DSP_Proc (buffer: Pointer; length: DWORD; BytesPerSample : Integer; NumberOfChannels : Integer; SampleRate : Integer); stdcall;
procedure dsp_plugin_Close; stdcall;
procedure dsp_plugin_SaveSettings; stdcall;
procedure dsp_plugin_LoadSettings; stdcall;

Const
     dsp_plugin : Tppdsp_plugin_structure = ( dsp_plugin_Version           : 1;
                                              dsp_plugin_Name              : 'Winamp DSP Wrapper Plugin for Passion Audio Player v1.1';
                                              dsp_hwndParent               : 0;
                                              dsp_hDllInstance             : 0;
                                              dsp_plugin_Initialize        : dsp_plugin_Initialize;
                                              dsp_plugin_Config            : dsp_plugin_Config;
                                              dsp_plugin_DSP_Proc          : dsp_plugin_DSP_Proc;
                                              dsp_plugin_BASS_CreateEffect : Nil;
                                              dsp_plugin_BASS_StopEffect   : Nil;
                                              dsp_plugin_Close             : dsp_plugin_Close;
                                              dsp_plugin_SaveSettings      : dsp_plugin_SaveSettings;
                                              dsp_plugin_LoadSettings      : dsp_plugin_LoadSettings);

// DLL exports this function - it should return a pointer to a static structure as above.
Function ppdsp_Plugin_Interface : Pppdsp_plugin_structure; stdcall; export;

Var
   winamp_DSP_Proc_Enabled:Boolean;

implementation


Uses
    Windows, Dialogs;
Var
   SaveCurrentWinampDSPModule_Handle : THandle;
   WinAmpSamplesForDSP:PSmallint;

// Definition of the DLL Export
Function ppdsp_Plugin_Interface : Pppdsp_plugin_structure;
Begin
     Result:=@dsp_plugin; //  Return the Module
End;

// Definition of the dsp_plugin_Initialize
Function dsp_plugin_Initialize (dsp_plugin_Root_Dir : PChar):Integer;
Var
   WinAmpSamplesForDSPBytesToAllocate:Integer;
Begin
     // ******** Put Here the plugin Initialize code ********

     // Allocate Memory for WinAmpDSP Plugins Support
     WinAmpSamplesForDSPBytesToAllocate:=Round( 96000*    // Max SamplingRate
                                                4*  // 4 Bytes For 32 Bit sound
                                                2*  // Channels
                                                (200+5)/1000)*// BASS will give at most 200ms worth of data in a single update, +5ms from me a value for safety reasons, no matter what the buffer length is.
                                                2;                                                      // 2* is the max num samples that a Winamp DSP Plugin Can Return
     GetMem(WinAmpSamplesForDSP,WinAmpSamplesForDSPBytesToAllocate);

     try
        Application.Handle:=dsp_plugin.dsp_hwndParent;
        winamp_wrapper_Form:=Twinamp_wrapper_Form.Create(Application);
        winamp_wrapper_Form.Parent_Window_Handle := dsp_plugin.dsp_hwndParent;
        winamp_wrapper_Form.Available_Plugins_Root_Dir:=dsp_plugin_Root_Dir;
        winamp_wrapper_Form.Show;
        Result:=0;
     except
           Result:=$FFFF;
     end;
End;

procedure dsp_plugin_Config;
Var
   SaveString:String;
Begin
     // ******** Put Here the plugin Config Code ********
     // This Config function is for configuring the passap_dsp_winamp_wrapper
     SaveString:='Winamp DSP Wrapper Plugin v1.1, for Passion Audio Player'+Chr(13)+'Copyright (c) 2005-2007, George Boudouris.';
     ShowMessage(SaveString);
End;

Function ConvertSamples_32BitTo16(InputSample:Single):Smallint;
Var
   SaveValue:Integer;
Begin
     SaveValue:= Trunc(InputSample * 32768);
     If SaveValue>32767 Then SaveValue:=32767;
     If SaveValue<-32768 Then SaveValue:=-32768;
     Result:=SaveValue;
End;

Function ConvertSamples_16BitTo32(InputSample:Smallint):Single;
Var
   SaveValue:Single;
Begin
     SaveValue:= InputSample/32768;
     Result:=SaveValue;
End;

// Definition of dsp_plugin_DSP_Proc
procedure dsp_plugin_DSP_Proc (buffer: Pointer; length: DWORD; BytesPerSample : Integer; NumberOfChannels : Integer; SampleRate : Integer);
Var
   SampleBuffer: PSingle;
   WinampBuf:PSmallint;
   SamplePos: DWORD;
   LeftSample, RightSample: Smallint;

   SamplesReturned:Integer;
   BytesToWriteToDSP:Integer;
   NumberOfBufferSamples:Integer;

begin
     If winamp_DSP_Proc_Enabled=True Then Begin

        // ******** Put Here the plugin DSP procedure code **************
        SampleBuffer := buffer;
        WinampBuf:=WinampSamplesForDSP;

        SamplePos := 0;
        while (SamplePos < (length div 4)) do begin
              // Copy new buffer contents to the memory buffer
              LeftSample:= ConvertSamples_32BitTo16(SampleBuffer^);
              WinampBuf^:=LeftSample;
              Inc(WinampBuf);
              Inc(SampleBuffer);

              If NumberOfChannels=2 Then Begin
                 RightSample:= ConvertSamples_32BitTo16(SampleBuffer^);
                 WinampBuf^:=RightSample;
                 Inc(WinampBuf);
                 Inc(SampleBuffer);
              End;

              SamplePos := SamplePos + NumberOfChannels;  //I use here NumberOfChannels to find how much samples were proccessed
        end;


        //     Move(Buf^,WinampSamplesForDSP^,Length);
        NumberOfBufferSamples:=Length div (NumberOfChannels*2); // For Stereo Samples the numofsamples=(Length div 2 BPS) Div 2 Channels=Length div 4
        NumberOfBufferSamples:=NumberOfBufferSamples Div 2;
        If Assigned(CurrentWinampDSPModule) Then Begin
           try
              SamplesReturned:=CurrentWinampDSPModule.ModifySamples(CurrentWinampDSPModule,WinampSamplesForDSP,NumberOfBufferSamples,16,NumberOfChannels,SampleRate);
           Except

           End;
        End
        Else Begin
             // NumSamples for 16 bit = Length Div 2
                SamplesReturned:=NumberOfBufferSamples;
        End;

        SampleBuffer := buffer;
        WinampBuf:=WinampSamplesForDSP;

        SamplePos := 0;
        while (SamplePos < (length div 4)) do begin
              // Copy new buffer contents to the memory buffer
              LeftSample:=WinampBuf^;
              SampleBuffer^:=ConvertSamples_16BitTo32(LeftSample);
              Inc(WinampBuf);
              Inc(SampleBuffer);

              If NumberOfChannels=2 Then Begin
                 RightSample:= WinampBuf^;
                 SampleBuffer^:=ConvertSamples_16BitTo32(RightSample);
                 Inc(WinampBuf);
                 Inc(SampleBuffer);
              End;
              
              SamplePos := SamplePos + NumberOfChannels;  //I use here NumberOfChannels to find how much samples were proccessed
        end;

        //     Move(WinampSamplesForDSP^,Buf^,BytesToWriteToDSP);
     End;
End;

// Definition of dsp_plugin_Close
procedure dsp_plugin_Close;
Begin
     // ******** Put Here the plugin Close Code ********

     // Free  Memory of the Last Selected Winamp DSP plugin
     UnLoad_Winamp_DSP_DLL;

     Try
        Application.Handle:=0;
        winamp_wrapper_Form.Free;
     except

     end;

     Freemem(WinAmpSamplesForDSP);
End;

// Definition of dsp_plugin_SaveSettings
procedure dsp_plugin_SaveSettings;
Begin
     // ******** Put Here the plugin Save Settings Code ********
End;

// Definition of dsp_plugin_LoadSettings
procedure dsp_plugin_LoadSettings;
Begin
     // ******** Put Here the plugin Load Settings Code ********
End;

end.

