//-------------------------------------------------\\
//     Passion Audio Player DSP Plugins SDK        \\
//     Copyright (c) 2005-2007, George Boudouris.  \\
//     Feel free to use this code for creating     \\
//     DSP plugins for Passion Audio Player        \\
//-------------------------------------------------\\

unit WinAmp_DSP_Delphi_Header;
// DSP plugin interface

// notes:
// any window that remains in foreground should optimally pass unused
// keystrokes to the parent (winamp's) window, so that the user
// can still control it. As for storing configuration,
// Configuration data should be stored in <dll directory>\plugin.ini
// (look at the vis plugin for configuration code)

// This is a translation of the DSP.H of the mini-SDK of WinAmp for writing
// DSP Plugins.The mini-SDK is written from Justin Frankel/Nullsoft Inc.
// This translation is written by George Boudouris for Delphi 6.
// http://www.passionplayer.com 

interface

uses Windows, Messages;

// WinAmp type declarations from DSP.H
type
  PWinampDSPModule = ^TwinampDSPModule;
  TwinampDSPModule = record
    description  : PChar;        // description of module
    hwndParent   : HWND;         // parent window (filled in by calling app)
    hDllInstance : HINST;        // instance handle to this DLL (filled in by calling app)
    Config       : procedure(PDSPModule : PwinampDSPModule); cdecl;   // configuration dialog
    Init         : function (PDSPModule : PwinampDSPModule) : Integer; cdecl;   // 0 on success, creates window, etc
    // modify waveform samples: returns number of samples to actually write
    // (typically numsamples, but no more than twice numsamples, and no less than half numsamples)
    // numsamples should always be at least 128. should, but I'm not sure
    // int (*ModifySamples)(struct winampDSPModule *this_mod, short int *samples, int numsamples, int bps, int nch, int srate);
    // bps = Bits Per Sample
    // The numsamples is meant to be the numsamples for each Channel
    // Example:
    // Suppose that got Length bytes from the DSP Buffer.
    // At 16 bits=2 Bytes the numsamples for a mono channel is Length Div 2 and
    // for stereo channels is (Length Div 2) Div 2
    ModifySamples: Function (PDSPModule : PwinampDSPModule;Samples:Pointer;NumSamples:Integer;BPS:Integer;NCh:Integer;SRate:Integer):Integer; cdecl;
    Quit         : procedure(PDSPModule : PwinampDSPModule); cdecl;   // called when unloading
    userData     : procedure; cdecl;  // user data, optional
  end;

  PwinampDSPHeader = ^TwinampDSPHeader;
  TwinampDSPHeader = record
    Version      : Integer; // DSP_HDRVER
    Description  : PChar;  // description of library
    getModule    : function (Which : Integer) : PwinampDSPModule; cdecl; // module retrieval function
  end;


Var
   winampDSPGetHeader2: Function :PwinampDSPHeader; stdcall;

Const
     // header version: 0x20 == 0.20 == winamp 2.0
     DSP_HDRVER =$20;

implementation

end.
