//-------------------------------------------------\\
//   Passion Audio Player DSP Plugins SDK Header   \\
//     Copyright (c) 2005-2007, George Boudouris.  \\
//     Feel free to use this code for creating     \\
//     DSP plugins for Passion Audio Player        \\
//-------------------------------------------------\\

unit ppdsp_sdk_header;

interface
Uses
    Windows;

type
  DWORD = Cardinal;

Type
    dsp_params_array_structure = Array[0..4] Of PChar;

type
    Pppdsp_plugin_structure=^Tppdsp_plugin_structure;
    Tppdsp_plugin_structure = Record
             dsp_plugin_Version           : Cardinal;
	           dsp_plugin_Name              : PChar;
             dsp_hwndParent               : HWND;         // parent window (filled in by calling app)
             dsp_hDllInstance             : HINST;        // instance handle to this DLL (filled in by calling app)
             dsp_plugin_Initialize        : Function (dsp_plugin_Root_Dir : PChar): Integer; stdcall; //0 = success, $FFFF = generic error
             dsp_plugin_Config            : procedure; stdcall;
             // buffer = Pointer to the buffer of the input data. This is the same as the output buffer
             // length = The number of BYTES to process
             // BytesPerSample = How many bytes are used for each sample (e.g 1 byte = 8 bits, 2 bytes = 16 bits 4 bytes=32 bits
             // NumberOfChannels = How many channels are used for output e.g. 2 = stereo
             // SampleRate = The sample rate that the samples has been captured
             // Note: the dsp_plugin_DSP_Proc is used for DSP processing the data directly
             dsp_plugin_DSP_Proc          : procedure ( buffer: Pointer; length: DWORD; BytesPerSample : Integer; NumberOfChannels : Integer; SampleRate : Integer); stdcall;
             // Create an effect to a Bass Channel. It can be used with some BASS plugins,
             // such as BASS_VST, and other that apply the effects directly using the Channel Handle
             dsp_plugin_BASS_CreateEffect : procedure (InputBASSChanHandle: Cardinal); stdcall;   // Creates the effect for input channel
             dsp_plugin_BASS_StopEffect   : procedure (InputBASSChanHandle: Cardinal); stdcall;   // Stops the effect for input channel
             dsp_plugin_Close             : procedure; stdcall;
	           dsp_plugin_SaveSettings      : procedure; stdcall;
	           dsp_plugin_LoadSettings      : procedure; stdcall;
    End;

implementation

end.
