//-------------------------------------------------\\
//     Passion Audio Player DSP Plugins SDK        \\
//     Copyright (c) 2005-2007, George Boudouris.  \\
//     Feel free to use this code for creating     \\
//     DSP plugins for Passion Audio Player        \\
//-------------------------------------------------\\

unit ppdsp_sdk_code;

interface

Uses
    Windows, Forms, ppdsp_sdk_header, panning_form;

Var
   DSP_Panning : Single;

// **********************************************
// Definitions of procedure for plugin
// **********************************************
Function dsp_plugin_Initialize (dsp_plugin_Root_Dir : PChar): Integer; stdcall;
procedure dsp_plugin_Config; stdcall;
procedure dsp_plugin_DSP_Proc (buffer: Pointer; length: DWORD; BytesPerSample : Integer; NumberOfChannels : Integer; SampleRate : Integer); stdcall;
procedure dsp_plugin_Close; stdcall;
procedure dsp_plugin_SaveSettings; stdcall;
procedure dsp_plugin_LoadSettings; stdcall;

Const
     dsp_plugin : Tppdsp_plugin_structure = ( dsp_plugin_Version           : 1;
	                                            dsp_plugin_Name              : 'Passion Audio Player DSP SDK Plugin v1.0';
                                              dsp_hwndParent               : 0;
                                              dsp_hDllInstance             : 0;
                                              dsp_plugin_Initialize        : dsp_plugin_Initialize;
                                              dsp_plugin_Config            : dsp_plugin_Config;
                                              dsp_plugin_DSP_Proc          : dsp_plugin_DSP_Proc;
                                              dsp_plugin_BASS_CreateEffect : Nil;
                                              dsp_plugin_BASS_StopEffect   : Nil;
                                              dsp_plugin_Close             : dsp_plugin_Close;
	                                            dsp_plugin_SaveSettings      : dsp_plugin_SaveSettings;
	                                            dsp_plugin_LoadSettings      : dsp_plugin_LoadSettings);

// DLL exports this function - it should return a pointer to a static structure as above.
Function ppdsp_Plugin_Interface : Pppdsp_plugin_structure; stdcall; export;

implementation

// Definition of the DLL Export
Function ppdsp_Plugin_Interface : Pppdsp_plugin_structure;
Begin
     Result:=@dsp_plugin; //  Return the Module
End;

// Definition of the dsp_plugin_Initialize
Function dsp_plugin_Initialize (dsp_plugin_Root_Dir : PChar):Integer;
var
   TheFileName : array[0..255] of char;
begin
//     FillChar(TheFileName, sizeof(TheFileName), #0);
//     GetModuleFileName(hInstance, TheFileName, sizeof(TheFileName));
//     MessageBox(0, TheFileName, 'The DLL file name is:', mb_ok);

     Try
        Application.Handle:=dsp_plugin.dsp_hwndParent;
        PanningForm := TPanningForm.Create(Application);
        PanningForm.Show;
        Result:=0;
     Except
           Result:=$FFFF;
     End;
End;

procedure dsp_plugin_Config;
Begin

End;

// Definition of dsp_plugin_DSP_Proc
procedure dsp_plugin_DSP_Proc (buffer: Pointer; length: DWORD; BytesPerSample : Integer; NumberOfChannels : Integer; SampleRate : Integer);
var
  SamplePos: DWORD;
  SampleBuffer: PSingle;
  LeftRatio,RightRatio : Single;
Begin
     // ******** put here the DSP procedure code **************
     SampleBuffer := buffer;

     If PanningForm.TrackBar1.Position>=0 Then Begin
        LeftRatio  := (100-PanningForm.TrackBar1.Position)/100;
        RightRatio := 1;
     End
     Else Begin
          LeftRatio  := 1;
          RightRatio := (100+PanningForm.TrackBar1.Position)/100;
     End;

     SamplePos := 0;
     while (SamplePos < (length div 4)) do begin
           // Proccess Left Sample
           SampleBuffer^ := SampleBuffer^ * LeftRatio;
           Inc(SampleBuffer);

           // Proccess Right Sample on Stereo files
           If NumberOfChannels=2 Then Begin
              SampleBuffer^ := SampleBuffer^ * RightRatio;
              Inc(SampleBuffer);
           End;

           SamplePos := SamplePos + NumberOfChannels;  //I use here NumberOfChannels to find how much samples were proccessed
     end;
End;

// Definition of dsp_plugin_Close
procedure dsp_plugin_Close;
Begin
     Try
        Application.Handle:=0;
        PanningForm.Free;
     Except

     End;
End;

// Definition of dsp_plugin_SaveSettings
procedure dsp_plugin_SaveSettings;
Begin

End;

// Definition of dsp_plugin_LoadSettings
procedure dsp_plugin_LoadSettings;
Begin

End;

end.

