unit Unit1;

interface
// This is meant to be an example on how to implement a Graphic Equalizer
// to an audio player via a DSP Callback Function. In order this source code
// to work, the BASS 1.6 playback library is required. You can find the
// latest BASS version at http://www.un4seen.com.
// This source was developed with Delphi 6 but i think it should work and
// with other versions of Delphi since it doesn't use any special syntax. 
// The reason that i'm releasing the source code is that i couldn't find
// equalizer source code for my audio player at the internet and so i thought
// it would be very useful to everyone.
// Everything that concerns the equalizer is at the EQFilters.pas unit.
// This code is free for any use. Do with it anything you want.
// But i will be very happy if you improve it and send me an e-mail
// with the corrections you made so that i will be able to use it in my programs.
// Note this please:
// This software is provided "as-is," without any express or implied warranty.
// In no event shall the author be held liable for any damages arising from the
// use of this software.
// Copyright (c) 2002
// George Boudouris
// E-mail: georgebou@hotmail.com
// HomePage: http://www.hobbysoft.gr
// This is also the homepage of my audio player, Passion Audio Player

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, BASS, EQFilters, ExtCtrls;

type
  TForm1 = class(TForm)
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    ScrollBar3: TScrollBar;
    ScrollBar4: TScrollBar;
    ScrollBar5: TScrollBar;
    ScrollBar6: TScrollBar;
    ScrollBar7: TScrollBar;
    ScrollBar8: TScrollBar;
    ScrollBar9: TScrollBar;
    ScrollBar10: TScrollBar;
    ScrollBar11: TScrollBar;
    Button3: TButton;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    CheckBox1: TCheckBox;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Timer1: TTimer;
    procedure ScrollBarChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    chan: DWORD;
    procedure Error(msg: string);
  public
    { Public declarations }
    Procedure CreateEQLabels;
    Procedure UpdateEQLabelsValues;
  end;

var
  Form1: TForm1;

  EQDSPHandle: HDSP;            // DSP handle

implementation

{$R *.dfm}

procedure TForm1.Error(msg: string);
var
  s: string;
begin
  s := msg + #13#10 + '(error code: ' + IntToStr(BASS_ErrorGetCode) + ')';
  MessageBox(handle, PChar(s), 'Error', MB_ICONERROR or MB_OK);
end;

Procedure TForm1.CreateEQLabels;
Begin
     Label12.Caption:=CurrToStr(CurrentEQBandsFrequencies[0]);
     Label13.Caption:=CurrToStr(CurrentEQBandsFrequencies[1]);
     Label14.Caption:=CurrToStr(CurrentEQBandsFrequencies[2]);
     Label15.Caption:=CurrToStr(CurrentEQBandsFrequencies[3]);
     Label16.Caption:=CurrToStr(CurrentEQBandsFrequencies[4]);
     Label17.Caption:=CurrToStr(CurrentEQBandsFrequencies[5]);
     Label18.Caption:=CurrToStr(CurrentEQBandsFrequencies[6]);
     Label19.Caption:=CurrToStr(CurrentEQBandsFrequencies[7]);
     Label20.Caption:=CurrToStr(CurrentEQBandsFrequencies[8]);
     Label21.Caption:=CurrToStr(CurrentEQBandsFrequencies[9]);
     Label22.Caption:='Amplify Signal';
End;

Procedure TForm1.UpdateEQLabelsValues;
Begin
     Label1.Caption :=IntToStr(-ScrollBar1.Position);
     Label2.Caption :=IntToStr(-ScrollBar2.Position);
     Label3.Caption :=IntToStr(-ScrollBar3.Position);
     Label4.Caption :=IntToStr(-ScrollBar4.Position);
     Label5.Caption :=IntToStr(-ScrollBar5.Position);
     Label6.Caption :=IntToStr(-ScrollBar6.Position);
     Label7.Caption :=IntToStr(-ScrollBar7.Position);
     Label8.Caption :=IntToStr(-ScrollBar8.Position);
     Label9.Caption :=IntToStr(-ScrollBar9.Position);
     Label10.Caption:=IntToStr(-ScrollBar10.Position);

     Label11.Caption:=IntToStr(-ScrollBar11.Position);
End;

Procedure UpdateEqualizerFunction;
var
  Counter:ShortInt;
   Multiplier:Integer;
begin
     SetCoefficientsForEQBand(0,CurrentEQFilter,1.4,-Form1.ScrollBar1.Position);
     SetCoefficientsForEQBand(1,CurrentEQFilter,1.4,-Form1.ScrollBar2.Position);
     SetCoefficientsForEQBand(2,CurrentEQFilter,1.4,-Form1.ScrollBar3.Position);
     SetCoefficientsForEQBand(3,CurrentEQFilter,1.4,-Form1.ScrollBar4.Position);
     SetCoefficientsForEQBand(4,CurrentEQFilter,1.4,-Form1.ScrollBar5.Position);
     SetCoefficientsForEQBand(5,CurrentEQFilter,1.4,-Form1.ScrollBar6.Position);
     SetCoefficientsForEQBand(6,CurrentEQFilter,1.4,-Form1.ScrollBar7.Position);
     SetCoefficientsForEQBand(7,CurrentEQFilter,1.4,-Form1.ScrollBar8.Position);
     SetCoefficientsForEQBand(8,CurrentEQFilter,1.4,-Form1.ScrollBar9.Position);
     SetCoefficientsForEQBand(9,CurrentEQFilter,1.4,-Form1.ScrollBar10.Position);

     Multiplier:=5;
     If Form1.ScrollBar11.Position<0 Then
        CalcTotalCoefficientsForAllBands(1+(-Form1.ScrollBar11.Position/Form1.ScrollBar11.Max*(Multiplier-1)))
     Else
         CalcTotalCoefficientsForAllBands(1-((Form1.ScrollBar11.Position/Form1.ScrollBar11.Max)*((Multiplier-1)/Multiplier)));
end;

// Notes:
// This DSP proc can take alot of optimizations but it was designed this way because
// if you want to change the Default EQ filters with your filters the only thing
// you have to do is to change the following line at the DSP Proc
// GetFilteredSample:=BandPassFilterOptimized(InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1],
//                                            InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-2],
//                                            InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-3],
//                                            OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1],
//                                            OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-2]);
// with this new one:
// GetFilteredSample:=NewFilteringProc(InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1],
//                                     InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-2],
//                                     InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-3],
//                                     OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1],
//                                     OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-2]);
// where NewFilteringProc is the new filtering function !!!!!!!!!!!!!!!!!

procedure EQ10BandsDSPProc(handle: HSYNC; channel: DWORD; buffer: Pointer; length, user: DWORD); stdcall;
var
   Lc, Rc: SmallInt;
   LcIn, RcIn: SmallInt;
   GetFilteredSample:TwoChannelsBuffer;
   Counter:Integer;
   DSPBufferPointer: StereoBufferPointer;
begin
     DSPBufferPointer := buffer;
     while (length > 0) do begin
           // Shift Samples in Input Buffer on position to left and
           // set the new value to the last one
           For Counter:=0 To NumberOfSamplesNeededToBufferForFilter-1-1 Do Begin
               InputBufferForEffect[Counter].Left:=InputBufferForEffect[Counter+1].Left;
               InputBufferForEffect[Counter].Right:=InputBufferForEffect[Counter+1].Right;
           End;
           // Set New Sample To the last position of the Input Buffer
           LcIn:=LOWORD(DSPBufferPointer^);
           RcIn:=HIWORD(DSPBufferPointer^);
           InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1].Left:=LcIn;  //Left Channel Sample
           InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1].Right:=RcIn; //Right Channel Sample

           // Get Filtered Sample
           GetFilteredSample:=BandPassFilterOptimized(InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1],
                                                      InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-2],
                                                      InputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-3],
                                                      OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1],
                                                      OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-2]);

           // Shift Samples in Input Buffer on position to left and
           // set the new value to the last one
           For Counter:=0 To NumberOfSamplesNeededToBufferForFilter-1-1 Do Begin
               OutputBufferForEffect[Counter].Left:=OutputBufferForEffect[Counter+1].Left;
               OutputBufferForEffect[Counter].Right:=OutputBufferForEffect[Counter+1].Right;
           End;
           // Set New Sample To the last position of the Input Buffer
           OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1].Left:=GetFilteredSample.Left;
           OutputBufferForEffect[NumberOfSamplesNeededToBufferForFilter-1].Right:=GetFilteredSample.Right;

           // Update Output Buffer
           lc := SmallInt(Trunc(GetFilteredSample.Left)); //Left Channel Sample
           rc := SmallInt(Trunc(GetFilteredSample.Right)); //Right Channel Sample
           DSPBufferPointer^ := MakeLong(lc, rc);
           // Move Pointer to Show To Next Sample
           Inc(DSPBufferPointer);
           length := length - 4;
     end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then begin
    EQDSPHandle:=BASS_ChannelSetDSP(chan, EQ10BandsDSPProc, 0);
  end
  else
      BASS_ChannelRemoveDSP(chan, EQDSPHandle);
end;

procedure TForm1.ScrollBarChange(Sender: TObject);
begin
     UpdateEqualizerFunction;
     UpdateEQLabelsValues;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     CreateEQLabels;// Display the equalizer frequencies
     UpdateEQLabelsValues;

     // Set Equalizer Variables
     UpdateEqualizerFunction;

     // Initialize Bass
     if (BASS_GetVersion <> MAKELONG(1,6)) then begin
        Error('BASS version 1.6 was not loaded');
        Halt;
     end;
     // setup output - default device, 44100hz, stereo, 16 bits, no syncs (not used)
      if not BASS_Init(-1, SampleRate, 0, handle) then begin
         Error('Can''t initialize device');
         Halt;
      end
      else
          BASS_Start;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
     ScrollBar1.Position:=-14;
     ScrollBar2.Position:=-14;
     ScrollBar3.Position:=-14;
     ScrollBar4.Position:=-14;
     ScrollBar5.Position:=-14;
     ScrollBar6.Position:=-14;
     ScrollBar7.Position:=-14;
     ScrollBar8.Position:=-14;
     ScrollBar9.Position:=-14;
     ScrollBar10.Position:=-14;
end;

procedure TForm1.RadioButton2Click(Sender: TObject);
begin
     ScrollBar1.Position:=0;
     ScrollBar2.Position:=0;
     ScrollBar3.Position:=0;
     ScrollBar4.Position:=0;
     ScrollBar5.Position:=0;
     ScrollBar6.Position:=0;
     ScrollBar7.Position:=0;
     ScrollBar8.Position:=0;
     ScrollBar9.Position:=0;
     ScrollBar10.Position:=0;
end;

procedure TForm1.RadioButton3Click(Sender: TObject);
begin
     ScrollBar1.Position:=14;
     ScrollBar2.Position:=14;
     ScrollBar3.Position:=14;
     ScrollBar4.Position:=14;
     ScrollBar5.Position:=14;
     ScrollBar6.Position:=14;
     ScrollBar7.Position:=14;
     ScrollBar8.Position:=14;
     ScrollBar9.Position:=14;
     ScrollBar10.Position:=14;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
     BASS_Free();
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  chattr: Integer;
begin
  if OpenDialog1.Execute then begin
     // free both MOD and stream, it must be one of them! :)
     BASS_MusicFree(chan);
     BASS_StreamFree(chan);
     chan := BASS_StreamCreateFile(FALSE, PChar(OpenDialog1.FileName), 0, 0, 0);
     if (chan = 0) then
        chan := BASS_MusicLoad(FALSE, PChar(OpenDialog1.FileName), 0, 0, BASS_MUSIC_LOOP or BASS_MUSIC_RAMP);
        if (chan = 0) then begin
           // not a WAV/MP3 or MOD
           Error('Can''t play the file');
           Exit;
        end;
     chattr := BASS_ChannelGetFlags(chan) and (BASS_SAMPLE_MONO or BASS_SAMPLE_8BITS);
    if chattr > 0 then begin
       // not 16-bit stereo
       BASS_MusicFree(chan);
       BASS_StreamFree(chan);
       Error('16-bit stereo sources only');
       Exit;
    end;
    // setup DSPs on new channel
    CheckBox1Click(Sender);

    // play both MOD and stream, it must be one of them! :)
    BASS_MusicPlay(chan);
    BASS_StreamPlay(chan, FALSE, BASS_SAMPLE_LOOP);
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
     Label24.Caption := FloatToStrF(BASS_GetCPU, ffFixed, 4, 1);
end;

end.
