#!/usr/bin/perl
## findProxyVlad.pl v1.11 (was called findProxy.pl)
## A more useful proxy hunter (bugs, suggestions to wayne@nym.alias.net)
#change history:
#v1.11: added code to let you know that you're unregistered, since Vlad 
# has gone commercial for new database data. Everything still works 
# for data older than Oct, 2000. Fixed a bug which was causing some 
# proxies to be missed on some searches.
#v1.1: changed to search MVlad's database by date, because he's only allowing full searches 
# on the latest 500 records, but will allow searches of the whole database for more specific 
# searches (if the date is being specified, for example).
#v1.0: searches MVlad's proxy database for proxies which are usable in specified country.

## This program will run anywhere and find web proxies for you to use. The proxies found are:
## accessable from where the program is run
## listening
## not access-controlled for you
## uncensored (I use http://www.sex.com/ as a test, and assume that if this is not censored by the proxy then
##  there is no censorship in place
## at least as fast as you specify

## requirements:
## a system with perl (http://www.activestate.com/ for win32 systems, http://www.perl.org/ for linux)
## perl module LWP installed

## remove the '#' from statements below to activate them, or add one to deactivate them
## the defaults below are set for running from the UAE.

# the country where this program is to run, should be one of: 'UAE', 'KSA', 'China' or 'free'
# use 'free' if you want to run this from an unblocked account (e.g. Panix).
# if you don't know which ports are blocked for you, run this with 'free' and the program will still # find useable proxies for you, but it will take a long time to do it. 

$country='UAE';

# add a proxy only if necessary - this must be accessible from wherever this program is run
# not necessary if the program is run from an account in a free country, for example Panix.
# (it's only needed to get the list of proxies to check)
#$useProxy='204.167.162.101:82';
$useProxy = 'proxy1.emirates.net.ae:8080';	# a set of UAE proxies

# speed requirements - your minimum acceptable proxy speed (as determined by virtualave)
$minSpeed=100;	#Once you have this program running, with a good proxy above etc., 
		#you may want to bump this up to 30000 or so, to get the fastest proxies only.

# modify this if you are sure (and please let me know of any confirmed changes to this list)
$blockedPorts{'free'}='';
$blockedPorts{'UAE'}='#80#81#119#880#1080#3128#8001#8002#8003#8080#8081#8088#8888#';
$blockedPorts{'KSA'}='#80#81#119#8000#8080#';
$blockedPorts{'China'}='';	# i don't know exactly what ports are blocked here - info please!

# number of lines to check in the virtualave proxy test log
$startDay = 50;		#number of days back from today to start search (0 if starting from todays entries)
			#start from today, unless you've already checked these. I did this last on 00/11/30.
$proxyLogDays = 100;	#number of days to search back from the start day in the database
$proxyLogStart = time - $startDay*24*3600;	

############### don't modify anything below here unless you know what you are doing ################

$knownBlockedPorts=$blockedPorts{$country};

$working='';

# Create a user agent object
use LWP::UserAgent;
$ua = new LWP::UserAgent;
$ua->agent("AgentName/0.1 " . $ua->agent);
$ua->agent("Lynx/2.8.3pre.6 libwww-FM/2.14FM");

if ($useProxy)	{$ua->proxy(['http'], "http://".$useProxy."/")};

$proxyLogPtr=$proxyLogStart;
$upsetMVlad=0; 
while ((!$upsetMVlad) and ($proxyLogPtr > ($proxyLogStart - $proxyLogDays*24*3600)))	
	{
	$datePtr = (localtime($proxyLogPtr))[5]."-".sprintf("%02d", (localtime($proxyLogPtr))[4]+1)."-".sprintf("%02d", (localtime($proxyLogPtr))[3]);
	$nskip=0;
	$noRecs=0;
	$registered=1;	#assume you've paid your $USD30 per month(!), unless otherwise determined
	while ((!$noRecs) and (!$upsetMVlad))
		{
		# Create a request for 50 (max allowed)
		# looks like http://tools.rosinstrument.com/cgi-bin/sps.pl?pattern=%3B100-09-03&max=50&nskip=0&file=proxlog.csv
		my $req = new HTTP::Request GET => "http://tools.rosinstrument.com/cgi-bin/sps.pl?pattern=%3B$datePtr&max=50&nskip=$nskip&file=proxlog.csv";
		# Pass request to the user agent and get a response back
		my $res = $ua->request($req);
		#open A, "<list.txt";

		# Check the outcome of the response
		if ($res->is_success) {
			$list=$res->content;
			print "$list\n";	#uncomment this if you want to see what's being tested
			if ($list =~ /flooder or non-correct robot/)	{$upsetMVlad=1};	#oops you've done it now! 
			if ($list =~ /this month statistics is only for registered users/) {$registered=0};
			if ($list =~ /No records found/)	{$noRecs=1};	#no records left for this day
			if ($list =~ /for unregistered use/)	{$noRecs=1};	#no more 
				#records available for this day (MVlad limits the number of records you can skip)
			while ( (!$upsetMVlad) and ($registered) and 
				($list =~ m|</a></TD><TD>(.*\..*)</TD><TD>[+-]?(\d+)</TD><TD>(\d+)</TD><TD>(\d+)-(\d+)-(\d+)|mg) )	{
				($host, $port, $speed, $year, $month, $day) = ($1, $2, $3, $4, $5, $6);
				next if ($host =~ /^bess-/);	#:-)
				$absPort=abs($port);
				if (($host) and ($knownBlockedPorts !~ /#$absPort#/) and ($speed>$minSpeed))	{
					print "testing: $host, $port, $speed, $year, $month, $day";
					$proxyUa = new LWP::UserAgent;
					$proxyUa->proxy(['http'], "http://$host:$port/");
					my $proxyReq = new HTTP::Request GET => 'http://www.sex.com/';
					my $startTime=time;
					my $proxyRes=$proxyUa->request($proxyReq);
					my $myTime=time-$startTime;
					if (($proxyRes->is_success) and ($proxyRes->content=~/Hottest Cheerleaders/))	{
						print " ****** working ******\n";
						$working .= "$host\t$port\t$speed\t$myTime#";}
					else {print "\n"};
					undef $proxyUa;
					}
				};
			};
		last if ($noRecs);	#the no more recs ('for unregistered use') flag was detected on the last set of 50
							#this means that page was good, but the next would be the same - ad infinitum
		$nskip += 50;
		};
	
	$proxyLogPtr -= 24*3600; #go back a day
	print "tested ", ($proxyLogStart-$proxyLogPtr)/24/3600, " days\n";
	};
	
print "\n*********************\n";
#print "working proxies found: \nHost:port\t\tspeed\tRef time", join("\n", split(/#/, $working)), "\n";
print "working proxies found: \n";
foreach $line (split(/#/, $working))	{
	printf "%-30s%7u%7u%4u\n", split(/\t/, $line)};

if ($upsetMVlad)	{
	print "but you upset MVlad and will need to continue from this point after changing your (proxy) IP address\n"
	};
if (!$registered) {
	print "At least one month you requested requires registration, so no records were returned\n";
	};

1;
