/*
 * Decompiled with CFR 0.152.
 */
class Vector3D {
    float x;
    float y;
    float z;

    void set(float f) {
        this.y = this.z = f;
        this.x = this.z;
    }

    void set(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    Vector3D vec(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D(this);
        this.x = vector3D2.y * vector3D.z - vector3D2.z * vector3D.y;
        this.y = vector3D2.z * vector3D.x - vector3D2.x * vector3D.z;
        this.z = vector3D2.x * vector3D.y - vector3D2.y * vector3D.x;
        return this;
    }

    public String toString() {
        return "[" + Matrix3D.out(this.x) + " " + Matrix3D.out(this.y) + " " + Matrix3D.out(this.z) + "]";
    }

    Vector3D() {
        this.set(0.0f);
    }

    Vector3D(float f) {
        this.set(f);
    }

    Vector3D(Vector3D vector3D) {
        this.set(vector3D);
    }

    Vector3D(float f, float f2, float f3) {
        this.set(f, f2, f3);
    }

    Vector3D add(Vector3D vector3D) {
        this.x += vector3D.x;
        this.y += vector3D.y;
        this.z += vector3D.z;
        return this;
    }

    Vector3D norm() {
        float f = this.length();
        if (f == 0.0f) {
            return this;
        }
        f = 1.0f / f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    Vector3D period(float f) {
        if (f == 0.0f) {
            return this;
        }
        float f2 = 2.0f * f;
        float f3 = this.x - f2 * (float)((int)(this.x / f2));
        float f4 = this.y - f2 * (float)((int)(this.y / f2));
        float f5 = this.z - f2 * (float)((int)(this.z / f2));
        return new Vector3D(f3 > f ? f3 - f2 : (f3 < -f ? f3 + f2 : f3), f4 > f ? f4 - f2 : (f4 < -f ? f4 + f2 : f4), f5 > f ? f5 - f2 : (f5 < -f ? f5 + f2 : f5));
    }

    Vector3D sub(Vector3D vector3D) {
        this.x -= vector3D.x;
        this.y -= vector3D.y;
        this.z -= vector3D.z;
        return this;
    }

    Vector3D mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    Vector3D inv() {
        this.x = 1.0f / this.x;
        this.y = 1.0f / this.y;
        this.z = 1.0f / this.z;
        return this;
    }

    float mul(Vector3D vector3D) {
        return this.x * vector3D.x + this.y * vector3D.y + this.z * vector3D.z;
    }

    float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    Vector3D mul(Matrix3D matrix3D) {
        Vector3D vector3D = new Vector3D(this);
        this.x = matrix3D.m03 + vector3D.x * matrix3D.m00 + vector3D.y * matrix3D.m10 + vector3D.z * matrix3D.m20;
        this.y = matrix3D.m13 + vector3D.x * matrix3D.m01 + vector3D.y * matrix3D.m11 + vector3D.z * matrix3D.m21;
        this.z = matrix3D.m23 + vector3D.x * matrix3D.m02 + vector3D.y * matrix3D.m12 + vector3D.z * matrix3D.m22;
        return this;
    }
}

