/*
 * Decompiled with CFR 0.152.
 */
class Timer
implements Runnable {
    private long clock;
    private long period = 100L;
    private Thread thread;

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public Timer(long l) {
        this.period = l;
    }

    public long period() {
        return this.period;
    }

    public long clock() {
        return this.clock;
    }

    public void start(long l) {
        this.period = l;
        this.start();
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "timer");
            this.thread.setPriority(10);
            this.thread.start();
        }
        this.clock = 0L;
    }

    public void run() {
        this.clock = 0L;
        while (true) {
            ++this.clock;
            try {
                Thread.sleep(this.period);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Timer Exception " + interruptedException.getMessage());
                continue;
            }
            break;
        }
    }

    public long time() {
        return this.clock * this.period;
    }
}

