/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;

class Model3D {
    static ADGview app;
    String name;
    Range rangeF;
    Range rangeX;
    Range rangeY;
    int nface;
    int qface;
    int ncam;
    int qcam;
    int nnod;
    int qnod;
    int nlist;
    int qlist;
    int nmtl;
    int qmtl;
    int nlgt;
    int qlgt;
    Node curcam;
    Node curnode;
    Node pick;
    Node[] nod;
    int[] lgt;
    int[] list;
    int qframe;
    float nframe;
    int trackdir = 1;
    int nall;
    int qall;
    String gndName;
    String[] nodName;
    String[] camName;
    String[] lgtName;
    String[] mtlName;
    Material[] mtl;
    Material curmtl;
    Color ambient = new Color(0x101010);
    Color diffuse = new Color(0x808080);
    Color specular = new Color(0xFFFFFF);
    boolean wasRaster;
    Render g = null;
    String regbuf = null;
    StreamTokenizer st;
    BufferedInputStream inp;
    int Nlevel;
    String[] path = new String[10];
    String tag1 = "";
    String tag2 = "";
    String tag = "";
    int last = 0;
    int nPath = 0;

    void incProgress() {
        if (this.qall == 0) {
            app.Progress(0.0f);
        }
        int n = this.nall++;
        float f = (float)n / (float)this.qall;
        if (f > 1.0f) {
            f = 1.0f;
        }
        System.out.println("--- " + f);
        app.Progress(0.7f * f);
    }

    void ComputeTree(int n, Matrix3D matrix3D) {
        ++this.Nlevel;
        int n2 = n;
        while (n2 != 0) {
            Node node = this.nod[n2];
            if (node.type != 2 && (node.state & 1) <= 0) {
                node.gm.set(matrix3D);
                node.gm.mul(node.lm);
                node.gm.mul(node.dm);
                if (node.Nchil != 0) {
                    this.ComputeTree(node.Nchil, node.gm);
                }
                if (node.type == 3) {
                    node.gm.pos(node.gm.mul(node.pivot));
                    this.list[this.qlist++] = n2;
                }
            }
            n2 = this.nod[n2].Nneib;
        }
        this.Nlevel += -1;
    }

    void reset() {
        if (this.nod == null) {
            return;
        }
        int n = 0;
        while (n < this.qnod) {
            this.nod[n].rot.set(0.0f, 0.0f, 0.0f);
            this.nod[n].mov.set(0.0f, 0.0f, 0.0f);
            this.nod[n].dm.pos(this.nod[n].mov);
            ++n;
        }
    }

    int readByte() throws IOException {
        int n = this.inp.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    int getNum(String string, String[] stringArray) {
        if (stringArray == null) {
            return -1;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Model3D(Render render) {
        this.g = render;
    }

    boolean setNode(Node node) {
        if (node == null) {
            return this.setCur("");
        }
        this.curnode = node;
        this.setSens();
        return true;
    }

    Node getNode(String string) {
        int n = 0;
        while (n < this.nod.length) {
            if (this.nod[n].name.equals(string)) {
                return this.nod[n];
            }
            ++n;
        }
        return null;
    }

    int[] readHide(int[] nArray, int n) throws IOException {
        if (this.qframe == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (nArray == null) {
            nArray = new int[this.qframe];
        }
        short s = this.readShort();
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = -1;
            ++n2;
        }
        n2 = 0;
        while (n2 < s) {
            short s2 = this.readShort();
            int n3 = this.readByte();
            if (s2 < n) {
                nArray[s2] = n3;
            }
            ++n2;
        }
        return nArray;
    }

    void splitPath(String string, boolean bl) {
        if (Model3D.app.debug > 1) {
            app.trace("tag=" + string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.last = this.nPath;
        while (n4 < 10) {
            n2 = string.indexOf(".", n);
            if (n == n2) {
                if (this.nPath > 0) {
                    this.nPath += -1;
                    this.last = this.nPath;
                }
                if ((n = n2 + 1) == n3) {
                    return;
                }
            } else {
                if (n2 < 0) {
                    this.path[n4] = string.substring(n);
                    this.last = n4;
                    if (bl) break;
                    this.nPath = this.last + 1;
                    return;
                }
                this.path[n4] = string.substring(n, n2);
                n = n2 + 1;
            }
            ++n4;
        }
    }

    void sort() {
    }

    short readShort() throws IOException {
        int n;
        int n2 = this.inp.read();
        if ((n2 | (n = this.inp.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n << 8) + n2);
    }

    boolean setCur(String string) {
        if (string == null) {
            int n = 0;
            while (n < this.qnod) {
                if (this.nod[n].type == 1) {
                    this.curnode = this.nod[n];
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (string == "") {
            return this.setCur("World") || this.setCur("ALL") || this.setCur(null);
        }
        int n = 0;
        while (n < this.qnod) {
            if (this.nod[n].name.equals(string)) {
                this.curnode = this.nod[n];
                return true;
            }
            ++n;
        }
        return false;
    }

    void raster() {
        if (Model3D.app.mtlText != null) {
            this.reinit();
            Model3D.app.mtlText = null;
        }
        this.Compute();
        this.nlist = 0;
        while (this.nlist < this.qlist) {
            Node node = this.nod[this.list[this.nlist]];
            if (node.type == 3) {
                node.raster();
            }
            ++this.nlist;
        }
        this.g.Zscale = this.g.zmax > 0.0f ? 1.0737418E9f / this.g.zmax : 1.0737418E9f;
    }

    boolean loadADG(String string) throws Exception {
        InputStream inputStream = app.openFile(string);
        if (inputStream != null && (this.inp = new BufferedInputStream(inputStream, 4096)) == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Node node = null;
        this.regbuf = "";
        this.qlgt = 0;
        this.qmtl = 0;
        this.qcam = 0;
        this.qnod = 0;
        this.qall = 0;
        this.nall = 0;
        this.mtl = null;
        this.nod = null;
        this.curnode = null;
        this.curcam = null;
        Render.mode &= 0xFDFFFFFF;
        this.nPath = 0;
        if (inputStream != null) {
            try {
                while (true) {
                    int n5;
                    int n6;
                    String string2;
                    this.tag = this.readString();
                    n4 = this.readInt();
                    this.splitPath(this.tag, n4 > 0);
                    if (n4 == 0) continue;
                    boolean bl = true;
                    this.tag1 = this.last < 0 ? "" : this.path[0];
                    this.tag2 = this.last < 1 ? "" : this.path[1];
                    String string3 = this.tag = this.last < 0 ? "" : this.path[this.last];
                    if (this.tag1.equals("INFO")) {
                        if (this.tag.equals("REGISTRY")) {
                            Model3D.app.regId = this.readString();
                            Model3D.app.regOwner = this.readString();
                            this.regbuf = this.regbuf + Model3D.app.regOwner;
                            Model3D.app.regProduct = this.readString();
                            this.regbuf = this.regbuf + Model3D.app.regProduct;
                            string2 = this.readString();
                            this.regbuf = this.regbuf + string2;
                            String string4 = this.readString();
                            this.regbuf = this.regbuf + string4;
                            Model3D.app.regApp = string2.equals("REGAPP");
                            Model3D.app.regDat = string4.equals("REGDAT");
                            if (!Model3D.app.regDat && string4.length() != 0) {
                                long l = Long.valueOf(string4);
                                long l2 = System.currentTimeMillis() / 1000L;
                                if (Math.abs(l2 - l) < 30L) {
                                    Model3D.app.regDat = true;
                                    Model3D.app.regApp = true;
                                }
                            }
                        } else if (this.tag.equals("MATERIAL")) {
                            this.qmtl = this.readShort();
                            this.qall += this.qmtl;
                            this.mtl = new Material[this.qmtl + 1];
                            this.mtlName = new String[this.qmtl + 1];
                            n6 = 0;
                            while (n6 < this.qmtl) {
                                this.mtlName[n6] = this.readString();
                                this.mtl[n6] = new Material(this.mtlName[n6], this);
                                ++n6;
                            }
                            this.mtlName[this.qmtl] = "";
                        } else if (this.tag.equals("LIGHT")) {
                            this.qlgt = this.readShort();
                            this.lgt = new int[this.qlgt];
                            this.lgtName = new String[this.qlgt];
                            n6 = 0;
                            while (n6 < this.qlgt) {
                                this.lgtName[n6] = this.readString();
                                ++n6;
                            }
                        } else if (this.tag.equals("NODE")) {
                            this.qnod = this.readShort() + 1;
                            this.nod = new Node[this.qnod];
                            this.nodName = new String[this.qnod];
                            this.nodName[0] = "null";
                            this.nod[0] = new Node(this.nodName[0], this);
                            n6 = 1;
                            while (n6 < this.qnod) {
                                this.nodName[n6] = this.readString();
                                this.nod[n6] = new Node(this.nodName[n6], this);
                                ++n6;
                            }
                        } else if (this.tag.equals("CAMERA")) {
                            this.qcam = this.readShort();
                            this.camName = new String[this.qcam];
                            n6 = 0;
                            while (n6 < this.qcam) {
                                this.camName[n6] = this.readString();
                                ++n6;
                            }
                        } else if (this.tag.equals("TRACK")) {
                            this.qframe = this.readShort();
                        } else if (this.tag.equals("OBJECT")) {
                            this.inp.skip(n4);
                        } else {
                            bl = false;
                        }
                    } else if (this.tag1.equals("MODE")) {
                        if (this.tag.equals("FILT")) {
                            this.g.setMode(8192, this.readByte());
                        } else if (this.tag.equals("RECT")) {
                            this.g.setMode(64, this.readByte());
                        } else if (this.tag.equals("GRND")) {
                            this.g.setMode(256, this.readByte());
                        } else if (this.tag.equals("ZBUF")) {
                            this.g.setMode(16, this.readByte());
                        } else if (this.tag.equals("MAGN")) {
                            this.g.setMode(32768, this.readByte());
                        } else if (this.tag.equals("CORR")) {
                            this.g.setMode(131072, this.readByte());
                        } else {
                            bl = false;
                        }
                    } else if (this.tag1.equals("CURRENT")) {
                        if (this.tag.equals("CAMERA")) {
                            this.ncam = this.getNum(this.readString(), this.nodName);
                        } else if (this.tag.equals("NODE")) {
                            this.nnod = this.getNum(this.readString(), this.nodName);
                        } else if (this.tag.equals("FRAME")) {
                            this.nframe = this.readShort();
                        } else {
                            bl = false;
                        }
                    } else if (this.tag1.equals("ENVIRONMENT")) {
                        if (this.tag.equals("MAP")) {
                            this.gndName = this.readString();
                        } else if (this.tag.equals("AMBIENT")) {
                            this.ambient = new Color(this.readInt());
                        } else {
                            bl = false;
                        }
                    } else if (this.tag1.equals("MATERIAL")) {
                        n5 = this.getNum(this.tag2, this.mtlName);
                        n2 = n5;
                        if (n2 < 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        this.curmtl = this.mtl[n2];
                        if (this.tag.equals("AMBIENT")) {
                            this.curmtl.ambient = new Color(this.readInt());
                        } else if (this.tag.equals("DIFFUSE")) {
                            this.curmtl.diffuse = new Color(this.readInt());
                        } else if (this.tag.equals("SPECULAR")) {
                            this.curmtl.specular = new Color(this.readInt());
                        } else if (this.tag.equals("REFLECT")) {
                            this.curmtl.reflect = this.readByte();
                        } else if (this.tag.equals("SELF")) {
                            this.curmtl.self = this.readByte();
                        } else if (this.tag.equals("ALPHA")) {
                            this.curmtl.alpha = true;
                            this.readByte();
                        } else if (this.tag.equals("MAPNAME")) {
                            this.curmtl.path = this.readString();
                        } else if (this.tag.equals("TRANSP")) {
                            this.curmtl.transp = this.readByte();
                        } else {
                            bl = false;
                        }
                    } else if (this.tag1.equals("NODE")) {
                        int n7;
                        string2 = this.path[this.last - 1];
                        int n8 = string2.equals("LOCK") ? 1 : 0;
                        String string5 = this.tag2;
                        n6 = 2;
                        while (n6 < this.last - n8) {
                            string5 = string5 + "." + this.path[n6];
                            ++n6;
                        }
                        n5 = this.getNum(string5, this.nodName);
                        n = n5;
                        if (n < 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        node = this.nod[n];
                        if (n8 > 0) {
                            if (string2.equals("LOCK")) {
                                if (this.tag.equals("POS")) {
                                    n6 = this.readByte();
                                    if ((n6 & 1) != 0) {
                                        node.flags |= 0x10000;
                                    }
                                    if ((n6 & 2) != 0) {
                                        node.flags |= 0x20000;
                                    }
                                    if ((n6 & 4) != 0) {
                                        node.flags |= 0x40000;
                                    }
                                } else if (this.tag.equals("ROT")) {
                                    n6 = this.readByte();
                                    if ((n6 & 1) != 0) {
                                        node.flags |= 0x80000;
                                    }
                                    if ((n6 & 2) != 0) {
                                        node.flags |= 0x100000;
                                    }
                                    if ((n6 & 4) != 0) {
                                        node.flags |= 0x200000;
                                    }
                                } else if (this.tag.equals("SCL")) {
                                    n6 = this.readByte();
                                    if ((n6 & 1) != 0) {
                                        node.flags |= 0x400000;
                                    }
                                    if ((n6 & 2) != 0) {
                                        node.flags |= 0x800000;
                                    }
                                    if ((n6 & 4) != 0) {
                                        node.flags |= 0x1000000;
                                    }
                                } else {
                                    bl = false;
                                }
                            } else {
                                bl = false;
                            }
                        } else if (this.tag.equals("TYPE")) {
                            String string6 = this.readString();
                            if (string6.equals("DUMMY")) {
                                node.type = 1;
                            } else if (string6.equals("CAMERA")) {
                                node.type = 2;
                            } else if (string6.equals("OBJECT")) {
                                node.type = 3;
                            } else if (string6.equals("LIGHT")) {
                                node.type = 4;
                            } else if (string6.equals("TARGET")) {
                                node.type = 5;
                            }
                            if (node.type == 3 && string5.equals("panorama")) {
                                Render.mode |= 0x2000000;
                            }
                            if (node.type == 2) {
                                this.curcam = node;
                            }
                            if (node.type == 4 && this.lgt != null) {
                                if (n3 >= this.qlgt) {
                                    throw new IndexOutOfBoundsException();
                                }
                                this.lgt[n3] = n;
                                ++n3;
                            }
                        } else if (this.tag.equals("TARGET")) {
                            node.Ntar = this.getNum(this.readString(), this.nodName);
                            if (node.Ntar < 0) {
                                node.Ntar = 0;
                            }
                        } else if (this.tag.equals("PARENT")) {
                            node.Nprnt = this.getNum(this.readString(), this.nodName);
                            if (node.Nprnt < 0) {
                                node.Nprnt = 0;
                            }
                            node.Nneib = this.getNum(this.readString(), this.nodName);
                            if (node.Nneib < 0) {
                                node.Nneib = 0;
                            }
                            node.Nchil = this.getNum(this.readString(), this.nodName);
                            if (node.Nchil < 0) {
                                node.Nchil = 0;
                            }
                        } else if (this.tag.equals("LMAT")) {
                            node.lm.m00 = this.readFloat();
                            node.lm.m01 = this.readFloat();
                            node.lm.m02 = this.readFloat();
                            node.lm.m03 = this.readFloat();
                            node.lm.m10 = this.readFloat();
                            node.lm.m11 = this.readFloat();
                            node.lm.m12 = this.readFloat();
                            node.lm.m13 = this.readFloat();
                            node.lm.m20 = this.readFloat();
                            node.lm.m21 = this.readFloat();
                            node.lm.m22 = this.readFloat();
                            node.lm.m23 = this.readFloat();
                        } else if (this.tag.equals("POS")) {
                            node.mov.x = this.readFloat();
                            node.mov.y = this.readFloat();
                            node.mov.z = this.readFloat();
                            node.rot.x = this.readFloat();
                            node.rot.y = this.readFloat();
                            node.rot.z = this.readFloat();
                            node.scl.x = this.readFloat();
                            node.scl.y = this.readFloat();
                            node.scl.z = this.readFloat();
                        } else if (this.tag.equals("TROT")) {
                            node.trot = this.readTrack(node.trot, this.qframe);
                        } else if (this.tag.equals("TMOV")) {
                            node.tmov = this.readTrack(node.tmov, this.qframe);
                        } else if (this.tag.equals("TSCL")) {
                            node.tscl = this.readTrack(node.tscl, this.qframe);
                        } else if (this.tag.equals("THIDE")) {
                            node.hide = this.readHide(node.hide, this.qframe);
                        } else if (this.tag.equals("HIDE")) {
                            node.hidden = true;
                            this.readString();
                        } else if (this.tag.equals("PIVOT")) {
                            node.pivot.x = this.readFloat();
                            node.pivot.y = this.readFloat();
                            node.pivot.z = this.readFloat();
                        } else if (this.tag.equals("VERT")) {
                            node.qvert = this.readInt();
                            node.vert = new Vector3D[node.qvert];
                            node.uu = null;
                            node.vv = null;
                            n6 = 0;
                            while (n6 < node.qvert) {
                                node.vert[n6] = new Vector3D(this.readFloat(), this.readFloat(), this.readFloat());
                                ++n6;
                            }
                        } else if (this.tag.equals("SVERT")) {
                            node.qvert = this.readInt();
                            node.vert = new Vector3D[node.qvert];
                            node.uu = null;
                            node.vv = null;
                            float f = this.readFloat();
                            n6 = 0;
                            while (n6 < node.qvert) {
                                node.vert[n6] = new Vector3D(f * (float)this.readShort(), f * (float)this.readShort(), f * (float)this.readShort());
                                ++n6;
                            }
                        } else if (this.tag.equals("FACE")) {
                            node.qface = this.readInt();
                            node.face = new Face[node.qface];
                            n6 = 0;
                            while (n6 < node.qface) {
                                node.face[n6] = new Face();
                                node.face[n6].mtl = this.readByte();
                                node.face[n6].f = this.readByte();
                                node.face[n6].v1 = this.readShort();
                                node.face[n6].v2 = this.readShort();
                                node.face[n6].v3 = this.readShort();
                                ++n6;
                            }
                        } else if (this.tag.equals("FLINK")) {
                            node.qface = this.readInt();
                            node.face = new Face[node.qface];
                            int n9 = this.readByte();
                            n6 = 0;
                            while (n6 < node.qface) {
                                node.face[n6] = new Face();
                                node.face[n6].mtl = n9;
                                node.face[n6].f = 7;
                                if (node.qface < 256) {
                                    node.face[n6].v1 = this.readByte();
                                    node.face[n6].v2 = this.readByte();
                                    node.face[n6].v3 = this.readByte();
                                } else {
                                    node.face[n6].v1 = this.readShort();
                                    node.face[n6].v2 = this.readShort();
                                    node.face[n6].v3 = this.readShort();
                                }
                                ++n6;
                            }
                        } else if (this.tag.equals("UV")) {
                            n7 = this.readInt();
                            node.uu = new float[n7];
                            node.vv = new float[n7];
                            n6 = 0;
                            while (n6 < n7) {
                                node.uu[n6] = this.readFloat();
                                node.vv[n6] = this.readFloat();
                                ++n6;
                            }
                        } else if (this.tag.equals("SUV")) {
                            n7 = this.readInt();
                            node.uu = new float[n7];
                            node.vv = new float[n7];
                            float f = this.readFloat();
                            n6 = 0;
                            while (n6 < n7) {
                                node.uu[n6] = f * (float)this.readShort();
                                node.vv[n6] = f * (float)this.readShort();
                                ++n6;
                            }
                        } else if (this.tag.equals("NORMAL")) {
                            n7 = this.readInt();
                            node.smooth = new byte[n7];
                            n6 = 0;
                            while (n6 < n7) {
                                node.smooth[n6] = (byte)this.readByte();
                                ++n6;
                            }
                        } else if (this.tag.equals("SMOOTH")) {
                            node.smoothed = this.readByte();
                        } else if (this.tag.equals("RANGE")) {
                            node.range_in = this.readFloat();
                            node.range_out = this.readFloat();
                        } else if (this.tag.equals("MULT")) {
                            node.mult = this.readFloat();
                        } else if (this.tag.equals("FOV")) {
                            node.fov = this.readFloat();
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                    if (bl) continue;
                    System.out.println("unknown tag " + this.tag);
                    if (this.inp.skip(n4) < (long)n4) break;
                }
                throw new Exception("Wrong data file");
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return false;
            }
        }
        if (this.inp != null) {
            ((FilterInputStream)this.inp).close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        return this.init();
    }

    Track readTrack(Track track, int n) throws IOException {
        if (n == 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.readShort();
        if (n2 == 0) {
            return null;
        }
        if (track == null) {
            track = new Track(n);
        }
        int n3 = 0;
        while (n3 < n2) {
            track.put(this.readShort(), new Vector3D(this.readFloat(), this.readFloat(), this.readFloat()));
            ++n3;
        }
        return track;
    }

    void ComputeCamera(int n, Matrix3D matrix3D) {
        int n2 = this.nod[n].Ntar;
        Matrix3D matrix3D2 = new Matrix3D();
        matrix3D.set(1.0f);
        int n3 = n;
        while (n3 != 0) {
            matrix3D2.set(this.nod[n3].lm);
            matrix3D2.mul(this.nod[n3].dm);
            matrix3D2.mul(matrix3D);
            matrix3D.set(matrix3D2);
            n3 = this.nod[n3].Nprnt;
        }
        if (n2 == 0) {
            return;
        }
        if (this.nod[n].Nprnt != 0 && this.nod[n].Nprnt == this.nod[n2].Nprnt) {
            return;
        }
        Vector3D vector3D = new Vector3D(matrix3D.pos());
        matrix3D.set(1.0f);
        n3 = n2;
        while (n3 != 0) {
            matrix3D2.set(this.nod[n3].lm);
            matrix3D2.mul(this.nod[n3].dm);
            matrix3D2.mul(matrix3D);
            matrix3D.set(matrix3D2);
            n3 = this.nod[n3].Nprnt;
        }
        Vector3D vector3D2 = new Vector3D(matrix3D.pos());
        matrix3D.tar(vector3D2.sub(vector3D));
        matrix3D.pos(vector3D);
        matrix3D.mul(this.nod[n].dm);
    }

    void Compute() {
        this.qlist = 0;
        this.nlist = 0;
        this.wasRaster = true;
        if (this.nod == null) {
            return;
        }
        if (this.qnod == 0) {
            return;
        }
        if (this.qcam == 0) {
            return;
        }
        int n = 0;
        while (n < this.qnod) {
            Node node = this.nod[n];
            int n2 = node.flags & 0x1FF0000;
            if (n2 != 0) {
                if ((n2 & 0x10000) != 0) {
                    node.mov.x = 0.0f;
                }
                if ((n2 & 0x20000) != 0) {
                    node.mov.y = 0.0f;
                }
                if ((n2 & 0x40000) != 0) {
                    node.mov.z = 0.0f;
                }
                if ((n2 & 0x80000) != 0) {
                    node.rot.x = 0.0f;
                }
                if ((n2 & 0x100000) != 0) {
                    node.rot.y = 0.0f;
                }
                if ((n2 & 0x200000) != 0) {
                    node.rot.z = 0.0f;
                }
                if ((n2 & 0x400000) != 0) {
                    node.scl.x = 0.0f;
                }
                if ((n2 & 0x800000) != 0) {
                    node.scl.y = 0.0f;
                }
                if ((n2 & 0x1000000) != 0) {
                    node.scl.z = 0.0f;
                }
            }
            node.dm.rot(node.rot);
            node.dm.pos(node.mov);
            node.dm.scale(node.scl);
            node.setFrame(this.nframe);
            node.setHide(this.nframe);
            ++n;
        }
        Vector3D vector3D = new Vector3D(1.0f, 1.0f, (float)this.g.scrH / (float)this.g.scrW);
        vector3D.y = (float)(Math.tan(0.7853981852531433) / Math.tan(this.curcam.fov * ((float)Math.PI / 180) / 2.0f));
        this.ComputeCamera(this.curcam.Nnode, this.curcam.gm);
        this.curcam.gm.scale(vector3D);
        this.curcam.gm.inv();
        this.Nlevel = 0;
        this.ComputeTree(1, this.curcam.gm);
    }

    void render() {
        int n;
        if (!this.wasRaster) {
            this.raster();
        }
        this.wasRaster = false;
        Point point = app.getMousePos();
        Node node = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = point.x - this.g.wind.x;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > this.g.wind.width) {
            n4 = this.g.wind.width;
        }
        if ((n = point.y - this.g.wind.y) < 0) {
            n = 0;
        }
        if (n > this.g.wind.height) {
            n = this.g.wind.height;
        }
        int n5 = n * this.g.pitch + n4 + this.g.off;
        if ((Render.mode & 0x4000) > 0) {
            n5 *= 2;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 >= this.g.scr.length) {
            n5 = this.g.scr.length - 1;
        }
        if ((Render.mode & 0x100) == 0) {
            this.g.scr[n5] = n2;
        } else {
            n2 = this.g.scr[n5];
        }
        this.nlist = 0;
        while (this.nlist < this.qlist) {
            Node node2 = this.nod[this.list[this.nlist]];
            if (node2.type == 3) {
                node2.render();
                n3 = this.g.scr[n5];
                if (n3 != n2) {
                    n2 = n3;
                    node = node2;
                }
            }
            ++this.nlist;
        }
        this.g.pixClose(this.g.rect);
        this.pick = node;
        if ((Render.mode & 0x80000) == 0 || this.pick == null) {
            return;
        }
        if (this.pick.link != null || !Model3D.app.pressed && (Render.mode & 0x100000) > 0) {
            this.pick.contour();
        }
    }

    void setMark(Node node) {
    }

    void setSens() {
        Model3D.app.Sens = 1.0f;
        if (this.curcam == null) {
            return;
        }
        int n = this.curcam.Nnode;
        while (n != 0) {
            if (n == this.curnode.Nnode) {
                Model3D.app.Sens = Model3D.app.CSens;
                return;
            }
            n = this.nod[n].Nprnt;
        }
    }

    void reinit() {
        int n = 0;
        while (n <= this.qmtl) {
            if (this.mtl[n] != null) {
                this.mtl[n].init();
            }
            ++n;
        }
    }

    boolean init() {
        Object object;
        int n;
        app.showInfo("Initialization ...");
        if (this.qcam == 0) {
            return false;
        }
        if (this.qnod == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.qnod) {
            this.nod[n2].Nnode = n2;
            ++n2;
        }
        if (this.regbuf.length() == 0) {
            Model3D.app.regApp = false;
            Model3D.app.regDat = false;
        } else {
            n = 0;
            n = 0;
            while (n < this.qmtl) {
                this.regbuf = this.regbuf + this.mtlName[n];
                ++n;
            }
            n = 0;
            while (n < this.qlgt) {
                this.regbuf = this.regbuf + this.lgtName[n];
                ++n;
            }
            n = 1;
            while (n < this.qnod) {
                this.regbuf = this.regbuf + this.nodName[n];
                ++n;
            }
            this.regbuf = app.password(this.regbuf);
            if (this.regbuf.compareTo(Model3D.app.regId) != 0) {
                Model3D.app.regApp = false;
                Model3D.app.regDat = false;
            }
        }
        if (this.ncam != 0) {
            this.curcam = this.nod[this.ncam];
        }
        if (this.nnod != 0) {
            this.curnode = this.nod[this.nnod];
        }
        this.qface = 0;
        this.nface = 0;
        if (this.curcam == null) {
            n2 = 0;
            while (n2 < this.qnod) {
                if (this.nod[n2].type == 2) {
                    this.curcam = this.nod[n2];
                    break;
                }
                ++n2;
            }
        }
        if (this.curcam == null) {
            return false;
        }
        if (this.curnode == null && !this.setNode(null)) {
            this.setNode(this.nod[1]);
        }
        this.setSens();
        app.trace("Camera :  " + this.curcam.name);
        app.trace("Select :  " + this.curnode.name);
        this.list = new int[this.qnod];
        if (this.qmtl == 0 || this.mtl == null) {
            this.mtl = new Material[1];
            this.qmtl = 0;
        }
        this.mtl[this.qmtl] = new Material("Default", this);
        n = 0;
        n2 = 0;
        while (n2 <= this.qmtl) {
            if (this.mtl[n2] != null) {
                Material material = this.mtl[n2];
                if (material.path != null && material.path.length() > 0) {
                    ++n;
                } else {
                    material.path = null;
                }
            }
            ++n2;
        }
        float f = 1.0f;
        float f2 = 0.05f;
        float f3 = Model3D.app.links != null ? Model3D.app.pMax : 0.0f;
        float f4 = f * (1.0f - f3) / (f * (float)n + f2 * (float)this.qnod);
        n2 = 0;
        while (n2 <= this.qmtl) {
            if (this.mtl[n2] != null) {
                object = this.mtl[n2];
                if (((Material)object).path != null) {
                    app.setProgress(f3, f3 + f4);
                    f3 += f4;
                    ((Material)object).map = app.getPixels(Model3D.app.dataPath + ((Material)object).path, ((Material)object).d);
                }
                ((Material)object).init();
            }
            ++n2;
        }
        System.gc();
        app.setProgress(f3, 1.0f);
        n2 = 0;
        while (n2 < this.qnod) {
            app.Progress((float)(n2 + 1) / (float)this.qnod);
            object = this.nod[n2];
            ((Node)object).init();
            this.qface += ((Node)object).qface;
            ++n2;
        }
        app.setProgress(0.0f, 0.0f);
        return true;
    }

    int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.inp.read();
        if ((n4 | (n3 = this.inp.read()) | (n2 = this.inp.read()) | (n = this.inp.read())) < 0) {
            throw new EOFException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    String readString() throws IOException {
        int n = this.readByte();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.inp.read();
            if (n3 < 0) {
                throw new IOException();
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        return new String(byArray, 0);
    }

    Node getDummy(Node node) {
        int n = node.Nnode;
        while (n != 0) {
            if (this.nod[n].type == 1) {
                return this.nod[n];
            }
            n = this.nod[n].Nprnt;
        }
        return node;
    }
}

