/*
 * Decompiled with CFR 0.152.
 */
class Matrix3D {
    static final float pi = 3.1415925f;
    static final float pi2 = 1.5707963f;
    static final float radian = (float)Math.PI / 180;
    static final float gradus = 57.295784f;
    float m00;
    float m01;
    float m02;
    float m03;
    float m10;
    float m11;
    float m12;
    float m13;
    float m20;
    float m21;
    float m22;
    float m23;

    Vector3D scale() {
        return new Vector3D((float)Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02), (float)Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12), (float)Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22));
    }

    float sign() {
        return (this.m00 + this.m01 + this.m02 + this.m03 + this.m10 + this.m11 + this.m12 + this.m13 + this.m20 + this.m21 + this.m22 + this.m23) / 3.0f;
    }

    void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
    }

    void set(float f) {
        this.m00 = f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = f;
        this.m23 = 0.0f;
    }

    void set(Vector3D vector3D) {
        this.m00 = vector3D.x;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = vector3D.y;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = vector3D.z;
        this.m23 = 0.0f;
    }

    void set(Matrix3D matrix3D) {
        this.m00 = matrix3D.m00;
        this.m01 = matrix3D.m01;
        this.m02 = matrix3D.m02;
        this.m03 = matrix3D.m03;
        this.m10 = matrix3D.m10;
        this.m11 = matrix3D.m11;
        this.m12 = matrix3D.m12;
        this.m13 = matrix3D.m13;
        this.m20 = matrix3D.m20;
        this.m21 = matrix3D.m21;
        this.m22 = matrix3D.m22;
        this.m23 = matrix3D.m23;
    }

    public String toString() {
        return "\n[" + Matrix3D.out(this.m00) + " " + Matrix3D.out(this.m01) + " " + Matrix3D.out(this.m02) + " " + Matrix3D.out(this.m03) + "\n " + Matrix3D.out(this.m10) + " " + Matrix3D.out(this.m11) + " " + Matrix3D.out(this.m12) + " " + Matrix3D.out(this.m13) + "\n " + Matrix3D.out(this.m20) + " " + Matrix3D.out(this.m21) + " " + Matrix3D.out(this.m22) + " " + Matrix3D.out(this.m23) + "]";
    }

    Matrix3D() {
        this.set(1.0f);
    }

    Matrix3D(float f) {
        this.set(f);
    }

    Matrix3D(Vector3D vector3D) {
        this.set(vector3D);
    }

    Matrix3D(Matrix3D matrix3D) {
        this.set(matrix3D);
    }

    Matrix3D(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
    }

    float det() {
        return new Vector3D(this.m00, this.m01, this.m02).mul(new Vector3D(this.m10, this.m11, this.m12).vec(new Vector3D(this.m20, this.m21, this.m22)));
    }

    Vector3D pos() {
        return new Vector3D(this.m03, this.m13, this.m23);
    }

    void pos(Vector3D vector3D) {
        this.m03 = vector3D.x;
        this.m13 = vector3D.y;
        this.m23 = vector3D.z;
    }

    Matrix3D rot(Vector3D vector3D) {
        float f = (float)Math.PI / 180 * vector3D.x;
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.sin(1.5707963f - f);
        float f4 = (float)Math.PI / 180 * vector3D.y;
        float f5 = (float)Math.sin(f4);
        float f6 = (float)Math.sin(1.5707963f - f4);
        float f7 = (float)Math.PI / 180 * vector3D.z;
        float f8 = (float)Math.sin(f7);
        float f9 = (float)Math.sin(1.5707963f - f7);
        this.m00 = f6 * f9 - f5 * f2 * f8;
        this.m10 = f6 * f8 + f5 * f2 * f9;
        this.m20 = -f5 * f3;
        this.m01 = -f3 * f8;
        this.m11 = f3 * f9;
        this.m21 = f2;
        this.m02 = f5 * f9 + f6 * f2 * f8;
        this.m12 = f5 * f8 - f6 * f2 * f9;
        this.m22 = f6 * f3;
        return this;
    }

    Vector3D rot() {
        Vector3D vector3D = new Vector3D();
        double d = this.m21;
        double d2 = Math.sqrt(1.0 - d * d);
        if (d2 != 0.0) {
            if (this.m11 < 0.0f && this.m22 < 0.0f) {
                d2 = -d2;
            }
            vector3D.x = 57.295784f * (float)Math.atan2(d, d2);
            vector3D.y = 57.295784f * (float)Math.atan2((double)(-this.m20) / d2, (double)this.m22 / d2);
            vector3D.z = 57.295784f * (float)Math.atan2((double)(-this.m01) / d2, (double)this.m11 / d2);
        } else {
            vector3D.x = 57.295784f * (float)Math.asin(d);
            vector3D.y = 57.295784f * (float)Math.atan2(this.m10, this.m00);
            vector3D.z = 0.0f;
        }
        return vector3D;
    }

    Matrix3D tar(Vector3D vector3D) {
        double d = vector3D.x * vector3D.x + vector3D.y * vector3D.y;
        double d2 = d + (double)(vector3D.z * vector3D.z);
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = (float)Math.sqrt(d / d2);
        float f4 = vector3D.x != 0.0f ? vector3D.y / (float)Math.sqrt(d) : 1.0f;
        float f5 = (float)Math.sqrt(1.0 - (double)(f3 * f3));
        if (vector3D.z < 0.0f) {
            f5 = -f5;
        }
        float f6 = -((float)Math.sqrt(1.0 - (double)(f4 * f4)));
        if (vector3D.x < 0.0f) {
            f6 = -f6;
        }
        this.m00 = f * f4 - f2 * f5 * f6;
        this.m10 = f * f6 + f2 * f5 * f4;
        this.m20 = -f2 * f3;
        this.m01 = -f3 * f6;
        this.m11 = f3 * f4;
        this.m21 = f5;
        this.m02 = f2 * f4 + f * f5 * f6;
        this.m12 = f2 * f6 - f * f5 * f4;
        this.m22 = f * f3;
        return this;
    }

    static final String out(float f) {
        int n = (int)(100.0f * f);
        float f2 = (float)((int)(100.0f * f)) / 100.0f;
        float f3 = n < 0 ? -n : n;
        if (n < 0) {
            if (f3 % 10.0f == 0.0f) {
                return "" + f2 + " ";
            }
            return "" + f2;
        }
        if (f3 % 10.0f == 0.0f) {
            return " " + f2 + " ";
        }
        return " " + f2;
    }

    Vector3D mul(Vector3D vector3D) {
        return new Vector3D(this.m03 + vector3D.x * this.m00 + vector3D.y * this.m01 + vector3D.z * this.m02, this.m13 + vector3D.x * this.m10 + vector3D.y * this.m11 + vector3D.z * this.m12, this.m23 + vector3D.x * this.m20 + vector3D.y * this.m21 + vector3D.z * this.m22);
    }

    Matrix3D mul(Matrix3D matrix3D) {
        Matrix3D matrix3D2 = new Matrix3D(this);
        this.m00 = matrix3D2.m00 * matrix3D.m00 + matrix3D2.m01 * matrix3D.m10 + matrix3D2.m02 * matrix3D.m20;
        this.m01 = matrix3D2.m00 * matrix3D.m01 + matrix3D2.m01 * matrix3D.m11 + matrix3D2.m02 * matrix3D.m21;
        this.m02 = matrix3D2.m00 * matrix3D.m02 + matrix3D2.m01 * matrix3D.m12 + matrix3D2.m02 * matrix3D.m22;
        this.m03 = matrix3D2.m00 * matrix3D.m03 + matrix3D2.m01 * matrix3D.m13 + matrix3D2.m02 * matrix3D.m23 + matrix3D2.m03;
        this.m10 = matrix3D2.m10 * matrix3D.m00 + matrix3D2.m11 * matrix3D.m10 + matrix3D2.m12 * matrix3D.m20;
        this.m11 = matrix3D2.m10 * matrix3D.m01 + matrix3D2.m11 * matrix3D.m11 + matrix3D2.m12 * matrix3D.m21;
        this.m12 = matrix3D2.m10 * matrix3D.m02 + matrix3D2.m11 * matrix3D.m12 + matrix3D2.m12 * matrix3D.m22;
        this.m13 = matrix3D2.m10 * matrix3D.m03 + matrix3D2.m11 * matrix3D.m13 + matrix3D2.m12 * matrix3D.m23 + matrix3D2.m13;
        this.m20 = matrix3D2.m20 * matrix3D.m00 + matrix3D2.m21 * matrix3D.m10 + matrix3D2.m22 * matrix3D.m20;
        this.m21 = matrix3D2.m20 * matrix3D.m01 + matrix3D2.m21 * matrix3D.m11 + matrix3D2.m22 * matrix3D.m21;
        this.m22 = matrix3D2.m20 * matrix3D.m02 + matrix3D2.m21 * matrix3D.m12 + matrix3D2.m22 * matrix3D.m22;
        this.m23 = matrix3D2.m20 * matrix3D.m03 + matrix3D2.m21 * matrix3D.m13 + matrix3D2.m22 * matrix3D.m23 + matrix3D2.m23;
        return this;
    }

    Matrix3D inv() {
        Vector3D vector3D = new Vector3D(this.m10, this.m11, this.m12).vec(new Vector3D(this.m20, this.m21, this.m22));
        Vector3D vector3D2 = new Vector3D(this.m20, this.m21, this.m22).vec(new Vector3D(this.m00, this.m01, this.m02));
        Vector3D vector3D3 = new Vector3D(this.m00, this.m01, this.m02).vec(new Vector3D(this.m10, this.m11, this.m12));
        float f = new Vector3D(this.m00, this.m01, this.m02).mul(vector3D);
        if (f == 0.0f) {
            return this;
        }
        f = 1.0f / f;
        Matrix3D matrix3D = new Matrix3D(1.0f);
        matrix3D.m03 = -this.m03;
        matrix3D.m13 = -this.m13;
        matrix3D.m23 = -this.m23;
        this.set(vector3D.x * f, vector3D2.x * f, vector3D3.x * f, 0.0f, vector3D.y * f, vector3D2.y * f, vector3D3.y * f, 0.0f, vector3D.z * f, vector3D2.z * f, vector3D3.z * f, 0.0f);
        this.mul(matrix3D);
        return this;
    }

    void scale(Vector3D vector3D) {
        this.mul(new Matrix3D(vector3D));
    }

    void scale(float f, float f2, float f3) {
        this.scale(new Vector3D(f, f2, f3));
    }
}

