/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ADGview
extends Applet
implements Runnable,
ImageProducer {
    private String className = "ADGview";
    private static int defX = 400;
    private static int defY = 300;
    private static boolean infoBack = true;
    public String masterName;
    public String slaveName;
    public String mtlText;
    private ImageConsumer consumer;
    public Render g = null;
    private Thread thread = null;
    public Dimension d;
    private FilterFloat averTime = null;
    private long time = 0L;
    private final int mr = 0xFF0000;
    private final int mg = 65280;
    private final int mb = 255;
    private final int ma = 0;
    public DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    private int pitch = 0;
    private int[] scr = null;
    private int[] gnd = null;
    private String sRendMode = null;
    private int iRendMode = Render.mode;
    public String dataPath = "";
    public Rectangle unionRect = new Rectangle();
    private Rectangle appRect = new Rectangle();
    private Rectangle infoRect = new Rectangle();
    private static Graphics screen;
    private static Image imageScreen;
    private Point mouse = new Point(0, 0);
    public boolean mouseOut = false;
    public boolean pickEnable = false;
    public boolean pickChange = false;
    public ADGlink pickLink = null;
    public ADGport pickPort = null;
    public Node pickNode = null;
    private int mx = 0;
    private int my = 0;
    private float posx = 0.0f;
    private float posy = 0.0f;
    private float posf = 0.0f;
    private float px0 = 0.0f;
    private float py0 = 0.0f;
    private float vx = 0.0f;
    private float vy = 0.0f;
    private float vf = 0.0f;
    private float kx = 0.2f;
    private float ky = 0.5f;
    private int stop = 0;
    private int wait = 180;
    private float velz = 0.0f;
    private boolean drag;
    public boolean pressed;
    private boolean FovMode = false;
    public float Sens = 1.0f;
    public float CSens = 0.1f;
    private float XSens = 1.0f;
    private float YSens = 1.0f;
    private float FSens = 0.1f;
    private float XVelMin = 0.0f;
    private float XVelMax = 3.0f;
    private float YVelMin = 0.0f;
    private float YVelMax = 3.0f;
    private int border = 0;
    private int progWidth = 0;
    private Timer timer;
    private long period;
    private boolean redraw = true;
    private boolean standAlone = false;
    private boolean wasGround = false;
    private boolean dragmode = true;
    private boolean reload = false;
    public boolean loaded = false;
    public boolean wasOut = false;
    public boolean panel = false;
    public float rotz = 0.0f;
    public String regId = null;
    public String regOwner = null;
    public String regProduct = null;
    public boolean regApp = true;
    public boolean regDat = true;
    private boolean registered = true;
    public int cash = 3;
    public int debug = 0;
    public float rate = 0.0f;
    public float progress = 0.0f;
    public float pMin = 0.0f;
    public float pMax = 1.0f;
    public Range r360 = new Range(0.0f, 360.0f);
    public Range r180 = new Range(0.0f, 180.0f);
    public Range r001 = new Range(0.0f, 1.0f);
    public Range rFOV = new Range(1.0f, 179.0f);
    boolean isBackColor = true;
    Color BackColor = new Color(-1);
    Color InfoColor = new Color(0xD0D0D0);
    Color TitleColor = new Color(0xE6E6E6);
    Color TitleShadow = new Color(0xA0A0A0);
    Color LinkColor = new Color(0xFF2000);
    Color LinkShadow = new Color(0x646464);
    String status = "";
    Cursor cursor;
    Cursor cursorZoom = new Cursor(9);
    Cursor cursorMove = new Cursor(13);
    Cursor cursorHand = new Cursor(12);
    Cursor cursorWait = new Cursor(3);
    Cursor cursorMain = new Cursor(0);
    Cursor cursorWell = new Cursor(0);
    private AudioClip sndClick;
    private AudioClip sndSelect;
    String gndName;
    String gndString;
    String infoString;
    String ref;
    String deftarget = "ADGview_link";
    public ADGport port;
    public Hashtable links;
    public ADGlink link = new ADGlink();
    private Point linkPos = new Point(0, 0);
    Choice choice;
    private String licenze = "Non-Commercial License ";
    private String www = "www.albatrossdesign.com";
    private String linkHome = "http://www.albatrossdesign.com";
    private String linkLec = "http://www.albatrossdesign.com/licenses/non-commercial.html";
    int[] strBuf = null;
    String strStr = "";
    Rectangle strRect = null;
    float tarX;
    int tarCntX;
    int tarMaxX = 200;
    float tarY;
    int tarCntY;
    int tarMaxY = 100;
    float tarF;
    int tarCntF;
    int tarMaxF = 50;
    int pmx = -1;
    int pmy = -1;
    boolean pickDown = false;
    int prevtime = 0;

    public void trace(String string) {
        if (this.debug == 0) {
            return;
        }
        System.out.println(string);
        if (this.standAlone) {
            return;
        }
        this.showStatus(string);
        if (this.debug > 1) {
            screen.setColor(Color.gray);
            screen.fillRect(0, 0, this.d.width, this.d.height);
            screen.setColor(Color.white);
            screen.drawString(string, 10, 20);
        }
    }

    boolean checkIcon(int n, int n2, boolean bl) {
        String string = null;
        this.pickPort = ADGport.checkIcon(n, n2, bl);
        if (this.pickLink != null) {
            ADGport aDGport = ADGport.get(this.pickLink);
            string = aDGport != null ? aDGport.info : this.pickLink.url;
        } else if (this.pickPort != null && this.pickPort.visible) {
            if (this.pickPort.model == null) {
                this.pickLink = this.pickPort.getVisibleLink();
                ADGport aDGport = ADGport.get(this.pickLink);
                if (aDGport != null) {
                    string = aDGport.info;
                } else if (this.pickLink != null) {
                    string = this.pickLink.url;
                }
            } else {
                String string2 = string = this.pickNode != null ? this.pickNode.name : this.port.info;
            }
        }
        if (string == null) {
            this.pickLink = null;
        }
        this.setCursor(string != null ? this.cursorHand : this.cursorMain);
        this.showStatus(string != null ? string : "");
        return string != null;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.mouseOut = false;
        this.mx = n;
        this.mx = (int)((float)this.mx - this.vx / 2.0f);
        this.my = n2;
        this.my = (int)((float)this.my - this.vy / 2.0f);
        return true;
    }

    synchronized void renderFrame() {
        if ((Render.mode & 0x20) > 0) {
            this.g.shad = true;
            this.port.raster();
            if (!this.wasGround) {
                this.fillGround();
            }
            this.port.render();
            this.g.shad = false;
        }
        ADGport.rasterAll();
        if (!this.wasGround) {
            this.fillGround();
        }
        ADGport.renderAll();
        if (this.border > 0 || this.port.scaleRect != null) {
            this.g.setColor(Color.white);
            this.g.drawRect(this.port.window);
        }
        this.pickLink = null;
        if (this.port.model != null && this.port.model.pick != null) {
            this.pickLink = this.port.model.pick.link;
            if ((Render.mode & 0x100000) > 0) {
                this.pickNode = this.port.model.pick;
                if (this.links != null && this.pickLink == null) {
                    this.pickNode = null;
                }
            }
        } else {
            this.pickNode = null;
        }
        if (this.pickNode != null) {
            this.pickNode = this.port.model.getDummy(this.pickNode);
            this.port.model.setMark(this.pickNode);
        }
    }

    float getF(String string, float f) {
        String string2 = this.getPar(string);
        if (string2 == null) {
            return f;
        }
        return Float.valueOf(string2).floatValue();
    }

    float getF(StringTokenizer stringTokenizer) {
        try {
            return Float.valueOf(stringTokenizer.nextToken()).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    Range getRange(StringTokenizer stringTokenizer) {
        try {
            if (stringTokenizer.hasMoreTokens()) {
                return new Range(this.getF(stringTokenizer), this.getF(stringTokenizer));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean Message(String string, float f) {
        if (string.equals("VELX")) {
            this.tarCntX = 0;
            this.vx += f;
        } else if (string.equals("VELY")) {
            this.tarCntY = 0;
            this.vy += f;
        } else if (string.equals("VELF")) {
            this.tarCntF = 0;
            this.vf += f;
        } else if (string.equals("ADDX")) {
            this.Message("ROTX", f + (this.port.rangeX == null ? this.tarX / 360.0f : this.port.rangeX.getWeight(this.tarX)));
        } else if (string.equals("ADDY")) {
            this.Message("ROTY", f + (this.port.rangeY == null ? this.tarY / 360.0f : this.port.rangeY.getWeight(this.tarY)));
        } else if (string.equals("ADDF")) {
            this.Message("FOV", f + (this.port.rangeF == null ? this.tarF / 180.0f : this.port.rangeF.getWeight(this.tarF)));
        } else if (string.equals("STOP")) {
            this.tarCntF = 0;
            this.tarCntY = 0;
            this.tarCntX = 0;
            this.vy = 0.0f;
            this.vx = 0.0f;
        } else if (string.equals("ROTX")) {
            this.tarCntX = this.tarMaxX;
            this.tarX = this.port.rangeX == null ? Range.near360(360.0f * f, this.posx) : this.port.rangeX.getFloat(f);
        } else if (string.equals("ROTY")) {
            this.tarCntY = this.tarMaxY;
            this.tarY = this.port.rangeY == null ? Range.near360(360.0f * f, this.posy) : this.port.rangeY.getFloat(f);
        } else if (string.equals("FOV")) {
            this.tarCntF = this.tarMaxF;
            this.tarF = this.port.rangeF == null ? 180.0f * f : this.port.rangeF.get(f);
        } else {
            return false;
        }
        return true;
    }

    int getH(String string, int n) {
        String string2 = this.getPar(string);
        if (string2 == null) {
            return n;
        }
        return Integer.decode(string2);
    }

    synchronized void flipFrame() {
        this.redraw = false;
        if (!this.wasGround) {
            this.fillGround();
        }
        if (this.unionRect.isEmpty()) {
            return;
        }
        if ((Render.mode & 0x1000000) > 0) {
            this.filterFrame(this.unionRect, this.d);
            this.filterFrame(this.unionRect, this.d);
        }
        this.draw(this.unionRect);
        this.g.resetRect(this.unionRect);
    }

    public void setDubl(boolean bl) {
        if (!bl) {
            this.g.scr = this.scr;
            this.g.gnd = null;
            this.g.dubl = bl;
            return;
        }
        if (this.g.dubl) {
            return;
        }
        this.g.dubl = bl;
        Rectangle rectangle = this.port.window;
        int n = rectangle.width << 1;
        int n2 = rectangle.height << 1;
        this.g.gnd = new int[n * (n2 + 1)];
        int n3 = 0;
        while (n3 < rectangle.height) {
            int n4 = 0;
            while (n4 < rectangle.width) {
                int n5;
                int n6 = (n * n3 + n4) * 2;
                this.g.gnd[n6] = n5 = this.gnd[this.pitch * (rectangle.y + n3) + rectangle.x + n4];
                this.g.gnd[n6 + 1] = n5;
                this.g.gnd[n6 + n] = n5;
                this.g.gnd[n6 + n + 1] = n5;
                ++n4;
            }
            ++n3;
        }
    }

    String getS(String string, String string2) {
        String string3 = this.getPar(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    String getS(StringTokenizer stringTokenizer) {
        try {
            return stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        FrameWnd frameWnd = new FrameWnd("ADGview");
        frameWnd.show();
        ((Component)frameWnd).hide();
        frameWnd.resize(frameWnd.insets().left + frameWnd.insets().right + defX, frameWnd.insets().top + frameWnd.insets().bottom + defY);
        ADGview aDGview = new ADGview();
        frameWnd.add("Center", aDGview);
        aDGview.standAlone = true;
        aDGview.init();
        aDGview.start();
        frameWnd.show();
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    synchronized void fillGround() {
        boolean bl;
        this.wasGround = true;
        this.unionRect = this.unionRect.intersection(this.appRect);
        if (this.unionRect.isEmpty()) {
            return;
        }
        Rectangle rectangle = this.unionRect.intersection(this.port.window);
        boolean bl2 = bl = rectangle.width == this.unionRect.width && rectangle.height == this.unionRect.height;
        if (!this.g.dubl && (Render.mode & 0x100) > 0) {
            bl = false;
        }
        this.g.fillGround(rectangle, this.port.window);
        if (bl) {
            return;
        }
        int n = this.unionRect.width;
        int n2 = this.unionRect.height;
        int n3 = this.pitch * this.unionRect.y + this.unionRect.x;
        int n4 = 0;
        while (n4 < n2) {
            System.arraycopy(this.gnd, n3, this.scr, n3, n);
            n3 += this.pitch;
            ++n4;
        }
    }

    public int[] getPixels(String object, Dimension dimension) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object2;
        Image image = null;
        URL uRL = null;
        String string = "";
        if (this.isSpace((String)object) && (object2 = this.nospace((String)object)) != "" && this.existFile((String)object2)) {
            object = object2;
        }
        if (image == null) {
            try {
                uRL = new URL(this.getCodeBase(), (String)object);
                this.trace("getPixels " + uRL);
                image = this.getImage(uRL);
            }
            catch (Exception exception) {
                string = exception.toString();
                System.out.println("getPixels: " + string);
                image = null;
            }
        }
        if (image == null) {
            try {
                image = Toolkit.getDefaultToolkit().getImage((String)object);
            }
            catch (Exception exception) {
                string = exception.toString();
                image = null;
            }
        }
        if (image == null) {
            screen.setColor(Color.red);
            System.out.println("Can't open FILE: " + uRL);
            screen.drawString("Can't open FILE: " + uRL, 3, 20);
            System.out.println(string);
            screen.drawString(string, 3, 30);
            return null;
        }
        object2 = new ADGload(image);
        Dimension dimension2 = ((ADGload)object2).getSize();
        if (dimension2 == null) {
            System.err.println("Can't load file :  " + (String)object);
            return null;
        }
        ((ADGload)object2).load();
        boolean bl = false;
        boolean bl2 = false;
        int n7 = dimension2.width;
        int n8 = dimension2.height;
        if (dimension.width > 0 && dimension.height > 0) {
            bl2 = true;
            bl = n7 != dimension.width || n8 != dimension.height;
            n7 = dimension.width;
            n8 = dimension.height;
        }
        if (n7 == 0 || n8 == 0) {
            return null;
        }
        int n9 = 0;
        int n10 = 0;
        if (dimension.width == 0 || dimension.height == 0) {
            int n11 = n7 * n8;
            n6 = 1;
            while (n6 < n7) {
                n6 <<= 1;
            }
            n6 >>= 1;
            n5 = 1;
            while (n5 < n8) {
                n5 <<= 1;
            }
            n4 = Math.abs(n6 * (n5 >>= 1) * 1 - n11);
            n3 = Math.abs(n6 * n5 * 2 - n11);
            n2 = Math.abs(n6 * n5 * 4 - n11);
            n = n4;
            int n12 = 1;
            if (n > n3) {
                n = n3;
                n12 = 2;
            }
            if (n > n2) {
                n = n2;
                n12 = 4;
            }
            switch (n12) {
                case 4: {
                    n6 *= 2;
                    n5 *= 2;
                    break;
                }
                case 2: {
                    n4 = Math.abs(n6 - n7) + Math.abs(2 * n5 - n8);
                    n3 = Math.abs(2 * n6 - n7) + Math.abs(n5 - n8);
                    if (n4 < n3) {
                        n5 *= 2;
                        break;
                    }
                    n6 *= 2;
                }
            }
            bl = n7 != n6 || n8 != n5;
            n7 = n6;
            n8 = n5;
            if (n6 < 256) {
                n9 = 0;
                while (n6 < 256) {
                    n6 <<= 1;
                    ++n9;
                }
            }
            if (n5 < 256) {
                n10 = 0;
                while (n5 < 256) {
                    n5 <<= 1;
                    ++n10;
                }
            }
        }
        dimension.width = n7;
        dimension.height = n8;
        if ((Render.mode & 0x800000) > 0) {
            if (n9 == 0) {
                ++n9;
            }
            if (n10 == 0) {
                ++n10;
            }
        }
        int[] nArray = ((ADGload)object2).mem;
        if (bl) {
            nArray = new int[n7 * n8 + n7 + 1];
            if (nArray == null) {
                return null;
            }
            this.g.scale(nArray, dimension, ((ADGload)object2).mem, dimension2);
        }
        if (n9 > 0 || n10 > 0) {
            n6 = 1 << n9;
            n5 = 1 << n10;
            n4 = ~(n6 - 1 | n6 - 1 << 8 | n6 - 1 << 16 | 0xFF000000);
            n3 = ~(n5 - 1 | n5 - 1 << 8 | n5 - 1 << 16 | 0xFF000000);
            n2 = n7 * n6;
            n = n8 * n5;
            int[] nArray2 = nArray;
            nArray = new int[n2 * n + n2 + 1];
            int n13 = 0;
            while (n13 < n8) {
                int n14 = 0;
                while (n14 < n7) {
                    int n15 = n14 + n13 * n7;
                    int n16 = n14 < n7 - 1 ? 1 : 0;
                    int n17 = n13 < n8 - 1 ? n7 : 0;
                    int n18 = n3 & nArray2[n15];
                    int n19 = n3 & nArray2[n15 + n16];
                    int n20 = n3 & nArray2[n15 + n17];
                    int n21 = n3 & nArray2[n15 + n17 + n16];
                    int n22 = 0;
                    while (n22 < n5) {
                        int n23 = n5 - n22;
                        int n24 = n4 & n18 * n23 + n20 * n22 >> n10;
                        int n25 = n4 & n19 * n23 + n21 * n22 >> n10;
                        int n26 = (n14 << n9) + ((n13 << n10) + n22) * n2;
                        int n27 = 0;
                        while (n27 < n6) {
                            nArray[n27 + n26] = n24 * (n6 - n27) + n25 * n27 >> n9;
                            ++n27;
                        }
                        ++n22;
                    }
                    ++n14;
                }
                ++n13;
            }
            dimension.width = n7 = n2;
            dimension.height = n8 = n;
            nArray2 = null;
        }
        int n28 = n7 * n8;
        while (n28 < n7 * n8 + n7) {
            nArray[n28] = nArray[n28 - n7];
            ++n28;
        }
        n6 = (Render.mode & 0x8000) != 0 && !bl2 ? 0xFCFCFE : 0xFFFFFE;
        n5 = bl2 ? 1 : 0;
        n28 = 0;
        while (n28 < nArray.length) {
            nArray[n28] = nArray[n28] & n6 | n5;
            ++n28;
        }
        return nArray;
    }

    public String getAppletInfo() {
        return "Name: ADGview\r\nAuthor: Boris Mazurok, Albatross Design Group\r\nCreated with Microsoft Visual J++ Version 1.1.8";
    }

    public void showStatus(String string) {
        if (string == null) {
            return;
        }
        if (this.status.equals(string)) {
            return;
        }
        this.status = string;
        super.showStatus(this.status);
    }

    public void setSize(Dimension dimension) {
        this.appRect.x = 0;
        this.appRect.width = dimension.width;
        this.appRect.y = 0;
        this.appRect.height = dimension.height;
        Render.copyRect(this.unionRect, this.appRect);
        if (this.loaded && this.port != null) {
            Render.copyRect(this.port.rect, this.appRect);
            ADGport.setChanged();
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.consumer = imageConsumer;
        this.consumer.setDimensions(this.d.width, this.d.height);
        this.consumer.setHints(30);
        this.consumer.setColorModel(this.colorModel);
    }

    public void setCursor(Cursor cursor) {
        if (!this.standAlone && this.cursor != cursor) {
            this.cursor = cursor;
            super.setCursor(this.cursor);
        }
    }

    int random(int n) {
        return (int)(Math.random() * (double)n);
    }

    public String nospace(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            string2 = c == ' ' ? string2 + "%20" : string2 + c;
            ++n;
        }
        return string2;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.mouseOut = true;
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = Math.abs(this.pmx - n) + Math.abs(this.pmy - n2) > 10;
        if (!bl && (Render.mode & 0x100000) == 0 && (this.pickEnable && this.pickNode != null || !this.FovMode && this.checkIcon(n, n2, true))) {
            this.pickChange = true;
            if (this.pickLink != null) {
                if (ADGport.get(this.pickLink) != null) {
                    this.link = this.pickLink;
                    this.reload = true;
                } else {
                    this.showDocument(this.pickLink.url, this.pickLink.target);
                }
            }
            this.play(this.pickLink == null ? this.sndClick : this.sndSelect);
        }
        this.pressed = false;
        this.drag = false;
        if (this.dragmode) {
            this.mouseMove(event, n, n2);
        }
        this.showDocument(this.ref, this.deftarget);
        return false;
    }

    public void adg(String string) {
        this.ADGmess(string);
        this.reload = true;
    }

    public InputStream checkFile(String string) {
        InputStream inputStream = null;
        if (string == "") {
            return null;
        }
        String string2 = "";
        if (this.standAlone) {
            try {
                inputStream = new FileInputStream(string);
                this.trace("file " + string);
            }
            catch (Exception exception) {
                string2 = exception.toString();
                inputStream = null;
            }
        } else {
            try {
                URL uRL = new URL(this.getCodeBase(), string);
                this.trace("openFile: " + uRL);
                inputStream = uRL.openStream();
            }
            catch (Exception exception) {
                string2 = exception.toString();
                inputStream = null;
            }
        }
        if (inputStream == null) {
            System.out.println("openFile: " + string2);
        }
        return inputStream;
    }

    public void destroy() {
        ADGport.unactivateAll();
        ADGport.ports = null;
        System.gc();
    }

    private void filterFrame(Rectangle rectangle, Dimension dimension) {
        if (rectangle.isEmpty()) {
            return;
        }
        int n = rectangle.width;
        int n2 = n - 1;
        if (n < dimension.width) {
            ++n2;
        }
        int n3 = rectangle.height;
        int n4 = n3 - 1;
        if (n3 < dimension.height) {
            ++n4;
        }
        int n5 = this.pitch;
        int n6 = 0;
        while (n6 < n4) {
            int n7;
            int n8 = n7 = n5 * (rectangle.y + n6) + rectangle.x;
            while (n8 < n7 + n2) {
                int n9 = 0xFCFCFC & this.scr[n8];
                n9 += 0xFCFCFC & this.scr[n8 + 1];
                n9 += 0xFCFCFC & this.scr[n8 + n5];
                this.scr[n8] = (n9 += 0xFCFCFC & this.scr[n8 + 1 + n5]) >> 2;
                ++n8;
            }
            ++n6;
        }
    }

    synchronized void beginFrame() {
        boolean bl;
        boolean bl2 = bl = this.d == null || this.d.width != this.size().width || this.d.height != this.size().height;
        if (this.redraw || bl) {
            this.d = new Dimension(this.size());
            this.setSize(this.d);
            this.g.setSize(this.d);
            if (this.d.width == 0) {
                return;
            }
            if (this.d.height == 0) {
                return;
            }
            this.pitch = this.d.width;
            this.scr = new int[this.d.width * (this.d.height + 1)];
            if (this.gnd == null) {
                this.loadGround();
            }
            imageScreen = this.createImage(this);
            this.setDubl((Render.mode & 0x4000) > 0 && this.loaded);
            this.update();
            this.show();
        }
        this.port.setWindow();
        this.wasGround = false;
        this.g.setWind(this.port.window);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public boolean action(Event event, Object object) {
        if (!this.standAlone) {
            return false;
        }
        String string = this.choice.getSelectedItem();
        if (string != null) {
            this.port.url = string;
            this.reload = true;
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        boolean bl;
        this.mx = this.pmx = n;
        this.my = this.pmy = n2;
        this.prevtime = (int)System.currentTimeMillis();
        this.pressed = true;
        this.FovMode = event.modifiers > 2;
        boolean bl2 = this.pickEnable && this.pickNode != null;
        boolean bl3 = bl = bl2 || !this.FovMode && this.checkIcon(n, n2, true);
        if (this.dragmode) {
            if (!this.port.window.inside(n, n2)) {
                return false;
            }
            if ((Render.mode & 0x100000) > 0) {
                this.pickChange = true;
            }
            if (!bl) {
                this.setCursor(this.FovMode ? this.cursorZoom : this.cursorMove);
            }
            this.mouseEnter(event, n, n2);
            this.tarCntF = 0;
            this.tarCntY = 0;
            this.tarCntX = 0;
        }
        this.drag = true;
        return false;
    }

    void fillImg(int[] nArray, Rectangle rectangle, boolean bl, int n) {
        if (nArray == null) {
            return;
        }
        if (!bl) {
            int n2 = 0;
            while (n2 < rectangle.height) {
                System.arraycopy(nArray, n + n2 * rectangle.width, this.scr, this.pitch * (rectangle.y + n2) + rectangle.x, rectangle.width);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < rectangle.height) {
            int n4 = (rectangle.y + n3) * this.pitch + rectangle.x;
            int n5 = n + n3 * rectangle.width;
            int n6 = 0;
            while (n6 < rectangle.width) {
                int n7 = nArray[n5 + n6];
                if (n7 != 0) {
                    this.scr[n4 + n6] = n7;
                }
                ++n6;
            }
            ++n3;
        }
    }

    public void run() {
        if (ADGport.ports == null) {
            this.init();
        }
        this.checkLink();
        if ((Render.mode & 0x400) > 0 && this.period > 0L && this.timer == null) {
            this.timer = new Timer(this.period);
        }
        this.redraw = true;
        this.repaint();
        if (this.port == null) {
            this.error("Can't find ADG file");
            return;
        }
        this.beginFrame();
        this.flipFrame();
        ADGport.initAll();
        this.reload = true;
        while (true) {
            try {
                while (true) {
                    if (this.reload) {
                        if (this.port.url != null && !this.port.url.equals(this.link.url)) {
                            this.link.url = this.port.url;
                            this.port.reset();
                            this.port.setActive(true);
                            ADGport aDGport = ADGport.get("title");
                            if (aDGport != null) {
                                aDGport.reset();
                                aDGport.window.x = 14;
                                aDGport.window.y = 235;
                                aDGport.window.width = 380;
                                aDGport.window.height = 28;
                            }
                        }
                        if (this.port.gndName != null && !this.port.gndName.equals(this.gndName)) {
                            this.gndName = this.port.gndName;
                            this.loadGround();
                        }
                        this.reload = false;
                        this.loaded = false;
                        this.posf = 0.0f;
                        this.posx = 0.0f;
                        this.posy = 0.0f;
                        if (this.port.model == null) {
                            this.update(screen);
                        }
                        ADGport.unactivateAll();
                        this.port = ADGport.find(this.link);
                        this.port.setWindow(this.pickPort);
                        this.port.setActive(true);
                        this.port.setLinkActive();
                        ADGport.setActive();
                        ADGport.loadActive();
                        this.checkRegistr();
                        System.gc();
                        this.redraw = true;
                        if (this.port.rangeF != null) {
                            this.posf = this.port.rangeF.max;
                        }
                        if (this.port.url.equals("band/band.adg") && this.port.rangeX != null) {
                            this.posx = this.port.rangeX.max;
                        }
                        this.setCursor(this.cursorMain);
                        if (this.timer != null) {
                            this.timer.start();
                        }
                        this.trace("Applet " + this.className);
                        this.loaded = true;
                    }
                    this.checkLink();
                    if (this.isActive()) {
                        this.beginFrame();
                        this.getControl();
                        this.renderFrame();
                        this.showInfo(null);
                        this.flipFrame();
                    }
                    Thread.sleep(this.loaded ? 4 : 200);
                }
            }
            catch (InterruptedException interruptedException) {
                this.stop();
                continue;
            }
            break;
        }
    }

    public void init() {
        String string;
        if (this.standAlone) {
            this.resize(defX, defY);
        }
        this.d = new Dimension(this.size());
        this.g = new Render();
        this.port = ADGport.def;
        this.port.window = new Rectangle(this.d);
        this.link.url = this.getS("Data", null);
        this.deftarget = this.getS("Target", this.deftarget);
        this.gndString = this.getS("Info", null);
        this.ref = this.getS("Ref", null);
        this.period = (long)this.getF("Timer", 0.0f);
        this.rate = this.getF("Rate", 1.0f);
        this.cash = (int)this.getF("Cash", this.cash);
        this.debug = (int)this.getF("Debug", 0.0f);
        this.border = (int)this.getF("Border", 0.0f);
        this.gndName = this.getS("Background", null);
        this.XSens = this.getF("SenseX", this.XSens);
        this.YSens = this.getF("SenseY", this.YSens);
        this.FSens = this.getF("SenseF", this.FSens);
        this.masterName = this.getS("Master", null);
        this.slaveName = this.getS("Slave", null);
        this.dragmode = this.getB("Drag", this.dragmode);
        this.panel = this.getB("Panel", this.panel);
        if (this.panel && (this.d.width != 504 || this.d.height != 304)) {
            this.panel = false;
        }
        String string2 = "190,286,200,13";
        String string3 = " 14,286,380,13";
        if (this.panel) {
            this.ADGmess("port.Main.window=14,13,380,210;");
            this.ADGmess("port.slider1: window=408, 94, 91,14; url=slider.jpg; slider=VELY; slider.sens=-0.03;");
            this.ADGmess("port.slider2: window=408,149, 91,14; url=slider.jpg; slider=VELX; slider.sens= 0.03;");
            this.ADGmess("port.slider3: window=408,204, 91,14; url=slider.jpg; slider=ADDF; slider.sens=-0.03;");
            string = this.getS("title", null);
            if (string != null) {
                this.ADGmess("port.title:   window= 14,235,380,28; text=" + string);
            }
        } else {
            string2 = null;
            string3 = "0," + (this.d.height - 17) + "," + this.d.width + ",13";
        }
        if (string2 != null) {
            this.ADGmess("port.info: window=" + string2 + "; text=" + this.www + ";link=" + this.linkHome);
        }
        if (string3 != null) {
            this.ADGmess("port.infp: window=" + string3 + "; text=" + this.licenze + this.www + ";link=" + this.linkLec);
        }
        this.checkADG("data");
        this.checkADG("mode");
        this.checkADG("info");
        this.checkADG("rangeX");
        this.checkADG("rangeY");
        this.checkADG("rangeF");
        this.checkADG("window");
        this.g.selectColor = this.getH("SelectColor", 65535);
        this.TitleColor = new Color(this.getH("TitleColor", this.TitleColor.hashCode()));
        this.TitleShadow = new Color(this.getH("TitleShadow", this.TitleShadow.hashCode()));
        this.InfoColor = new Color(this.getH("InfoColor", this.InfoColor.hashCode()));
        int n = this.getH("BackColor", -1);
        this.isBackColor = n != -1;
        this.BackColor = new Color(this.isBackColor ? n : 0);
        this.isBackColor |= !this.panel;
        try {
            string = this.getPar("SoundClick");
            if (string != null) {
                this.sndClick = this.getAudioClip(this.getDocumentBase(), string);
            }
            if ((string = this.getPar("SoundSelect")) != null) {
                this.sndSelect = this.getAudioClip(this.getDocumentBase(), string);
            }
        }
        catch (Exception exception) {
            this.error("Failed to load audio");
        }
        if ((string = this.getPar("ADG")) != null) {
            this.ADGmess(string);
        }
        if (ADGport.isEmpty()) {
            this.port = ADGport.put("Main");
        }
        ADGport.initAll();
        this.port = ADGport.find(this.link);
        this.port.setActive(true);
        if (this.d.width == 0 || this.d.height == 0) {
            this.d.width = defX;
            this.d.height = defY;
        }
        this.progWidth = this.d.width;
        if (this.panel) {
            this.progWidth = (int)((double)this.progWidth * 0.8);
        }
        this.setSize(this.d);
        screen = this.getGraphics();
        screen.setColor(Color.black);
        screen.fillRect(0, 0, this.d.width, this.d.height);
    }

    synchronized void storeGround(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = this.port.window;
        }
        if (rectangle.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < rectangle.height) {
            int n2 = this.pitch * (rectangle.y + n) + rectangle.x;
            System.arraycopy(this.scr, n2, this.gnd, n2, rectangle.width);
            ++n;
        }
    }

    public void error(String string) {
        System.err.println(string);
        if (!this.standAlone) {
            this.showStatus(string);
        }
        screen.setColor(Color.red);
        screen.drawString(string, 3, 20);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        this.wasOut = true;
        this.mouseOut = false;
        this.mouse.x = n;
        this.mouse.y = n2;
        if (!this.loaded) {
            this.setCursor(this.cursorWait);
            return false;
        }
        if (this.dragmode && !this.drag) {
            this.checkIcon(n, n2, false);
            return false;
        }
        this.stop = this.wait;
        int n3 = (int)System.currentTimeMillis();
        float f = n3 > this.prevtime ? 100.0f / (float)(n3 - this.prevtime) : 1.0f;
        this.prevtime = n3;
        this.AddVel(f * (float)(n - this.mx), f * (float)(n2 - this.my), this.kx, this.ky);
        this.mx = n;
        this.my = n2;
        f = this.FovMode ? 1.0f : 0.4f;
        this.AddPos(this.vx * f, this.vy * f, true);
        if (this.standAlone) {
            return false;
        }
        if (this.ref == null) {
            this.setCursor(this.FovMode ? this.cursorZoom : this.cursorMove);
        } else {
            this.showStatus(this.ref);
            this.setCursor(this.cursorHand);
        }
        return false;
    }

    String getPar(String string) {
        if (!this.standAlone) {
            return this.getParameter(string);
        }
        FileInputStream fileInputStream = null;
        String string2 = null;
        try {
            fileInputStream = new FileInputStream(this.className + ".html");
        }
        catch (Exception exception) {
            fileInputStream = null;
            return string2;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedInputStream(fileInputStream, 4000));
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(33);
        streamTokenizer.quoteChar(34);
        while (!(streamTokenizer.ttype == -1 || streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("param"))) {
            try {
                streamTokenizer.nextToken();
            }
            catch (Exception exception) {}
        }
        while (!(streamTokenizer.ttype == -1 || streamTokenizer.ttype == -3 && streamTokenizer.sval.equals(string))) {
            try {
                streamTokenizer.nextToken();
            }
            catch (Exception exception) {}
        }
        while (!(streamTokenizer.ttype == -1 || streamTokenizer.ttype == -3 && streamTokenizer.sval.equals("value"))) {
            try {
                streamTokenizer.nextToken();
            }
            catch (Exception exception) {}
        }
        while (streamTokenizer.ttype != -1) {
            try {
                streamTokenizer.nextToken();
            }
            catch (Exception exception) {}
            if (streamTokenizer.sval != null) {
                string2 = streamTokenizer.sval;
                break;
            }
            if (streamTokenizer.ttype != -2) continue;
            string2 = "" + streamTokenizer.nval;
            break;
        }
        if (string2 != null) {
            this.trace("Param " + string + "=" + string2);
        }
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {}
        streamTokenizer = null;
        return string2;
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    protected boolean checkADG(String string, String string2) {
        String string3 = this.getPar(string);
        if (string3 == null) {
            return false;
        }
        new StringTokenizer(string3, ",");
        this.ADGmess("port.Main." + string2 + "=" + string3);
        return true;
    }

    protected boolean checkADG(String string) {
        return this.checkADG(string, string);
    }

    void getControl() {
        if (this.port.model == null) {
            return;
        }
        if ((Render.mode & 0x400) > 0) {
            Model3D model3D = this.port.model;
            if (this.timer != null) {
                model3D.nframe = this.rate * (float)this.timer.clock();
            } else {
                model3D.nframe += (float)model3D.trackdir;
                if ((Render.mode & 0x400000) == 0) {
                    if (model3D.nframe >= (float)(model3D.qframe - 2)) {
                        model3D.trackdir = -1;
                    }
                    if (model3D.nframe <= 0.0f) {
                        model3D.trackdir = 1;
                    }
                }
            }
        }
        this.vx = this.limit(this.vx, this.XVelMin, this.XVelMax);
        this.vy = this.limit(this.vy, this.YVelMin, this.YVelMax);
        this.AddPos(this.vx, this.vy, !this.pressed);
        float f = 0.0f;
        if (this.port.rangeF != null) {
            if (this.posf < this.port.rangeF.min) {
                this.posf = this.port.rangeF.min;
                this.vf = 0.0f;
            }
            if (this.posf > this.port.rangeF.max) {
                this.posf = this.port.rangeF.max;
                this.vf = 0.0f;
            }
            this.port.model.curcam.fov = 45.0f + this.posf;
            f = (this.port.rangeF.max - this.posf) / 2.0f;
        }
        if (this.port.rangeX != null) {
            if (this.posx < this.port.rangeX.min - f) {
                this.posx = this.port.rangeX.min - f;
                this.vx = 0.0f;
            }
            if (this.posx > this.port.rangeX.max + f) {
                this.posx = this.port.rangeX.max + f;
                this.vx = 0.0f;
            }
        }
        if (this.port.rangeY != null) {
            if (this.posy < this.port.rangeY.min - (f = f * (float)this.port.window.height / (float)this.port.window.width)) {
                this.posy = this.port.rangeY.min - f;
                this.vy = 0.0f;
            }
            if (this.posy > this.port.rangeY.max + f) {
                this.posy = this.port.rangeY.max + f;
                this.vy = 0.0f;
            }
        }
        Node node = this.port.model.curnode;
        node.rot.set(this.posy, this.rotz, this.posx);
        node.dm.pos(new Vector3D(0.0f, 0.0f, 0.0f));
        node.mov.add(node.dm.mul(new Vector3D(0.0f, this.velz, 0.0f)));
        ADGport.controlAll(this.posx, this.posy);
        if (this.pickChange) {
            this.pickChange = false;
            if (this.links == null && this.port.model.setNode(this.pickNode)) {
                this.posy = this.port.model.curnode.rot.x;
                this.rotz = this.port.model.curnode.rot.y;
                this.posx = this.port.model.curnode.rot.z;
            }
        }
        boolean bl = this.pickEnable = (Render.mode & 0x40000) > 0 && !this.mouseOut && this.dragmode && !this.drag && !this.FovMode;
        if (this.pickEnable && (Render.mode & 0x100000) > 0) {
            this.setCursor(this.pickNode != null ? this.cursorHand : this.cursorMain);
        }
    }

    boolean getB(String string, boolean bl) {
        String string2 = this.getPar(string);
        if (string2 == null) {
            return bl;
        }
        return Float.valueOf(string2).intValue() > 0;
    }

    public void filterMem(int[] nArray, Dimension dimension) {
        int n = dimension.width;
        int n2 = n - 1;
        int n3 = dimension.height;
        int n4 = n3 - 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = n;
            if (n6 >= n4) {
                n7 -= n * n3;
            }
            int n8 = 0;
            while (n8 < n) {
                int n9 = n5 + n8;
                int n10 = 1;
                if (n8 >= n2) {
                    n10 -= n;
                }
                int n11 = 0;
                n11 += 0xFCFCFC & nArray[n9];
                n11 += 0xFCFCFC & nArray[n9 + n10];
                n11 += 0xFCFCFC & nArray[n9 + n7];
                nArray[n9] = (n11 += 0xFCFCFC & nArray[n9 + n10 + n7]) >> 2;
                ++n8;
            }
            n5 += n;
            ++n6;
        }
    }

    private void AddVel(float f, float f2, float f3, float f4) {
        this.vx = this.vx * (1.0f - f3) + f3 * f * this.XSens * this.Sens;
        this.vy = this.vy * (1.0f - f4) + f4 * f2 * (this.FovMode ? this.FSens : this.YSens * this.Sens);
    }

    public void checkLink() {
    }

    void drawString(String string, int n, int n2, Color color) {
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        Rectangle rectangle = this.strRect;
        boolean bl2 = this.strStr != string || this.strBuf == null;
        boolean bl3 = bl = rectangle == null || rectangle.x != n || rectangle.y != n2;
        if (bl || bl2) {
            this.strRect = rectangle = this.getStringRect(string, n, n2);
            if (rectangle == null) {
                return;
            }
        }
        if (bl2) {
            this.strStr = string;
            n6 = rectangle.width;
            n5 = rectangle.height;
            n4 = 1;
            n3 = 11;
            Image image = this.createImage(n6, n5);
            Graphics graphics = image.getGraphics();
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n6, n5);
            graphics.setColor(Color.white);
            graphics.drawString(string, n4 - 1, n3 - 1);
            graphics.drawString(string, n4, n3 - 1);
            graphics.drawString(string, n4 + 1, n3 - 1);
            graphics.drawString(string, n4 - 1, n3);
            graphics.drawString(string, n4, n3);
            graphics.drawString(string, n4 + 1, n3);
            graphics.drawString(string, n4 - 1, n3 + 1);
            graphics.drawString(string, n4, n3 + 1);
            graphics.drawString(string, n4 + 1, n3 + 1);
            graphics.setColor(color);
            graphics.drawString(string, n4, n3);
            this.strBuf = new int[n6 * n5];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n5, this.strBuf, 0, n6);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("drawString:interrupted waiting for pixels!");
                return;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("drawString aborted or errored");
                return;
            }
            int n7 = 0;
            while (n7 < this.strBuf.length) {
                int n8 = n7++;
                this.strBuf[n8] = this.strBuf[n8] & 0xFFFFFF;
            }
        }
        n6 = 0;
        while (n6 < rectangle.height) {
            n5 = (rectangle.y + n6) * this.d.width + rectangle.x;
            n4 = n6 * rectangle.width;
            int n9 = 0;
            while (n9 < rectangle.width) {
                n3 = this.strBuf[n4 + n9];
                if (n3 != 0) {
                    this.scr[n5 + n9] = n3;
                }
                ++n9;
            }
            ++n6;
        }
    }

    public void ADGmess(String string) {
        String string2 = "";
        try {
            int n = 0;
            int n2 = 0;
            int n3 = string.length();
            ADGport aDGport = ADGport.def;
            while (n < n3) {
                try {
                    Object object;
                    n2 = string.indexOf(61, n);
                    if (n2 < 0) {
                        n2 = n3;
                    }
                    String string3 = string.substring(n, n2);
                    n = n2 + 1;
                    if ((n2 = string.indexOf(59, n)) < 0) {
                        n2 = n3;
                    }
                    String string4 = string.substring(n, n2);
                    n = n2 + 1;
                    n2 = string3.indexOf(58);
                    if (n2 < 0) {
                        string3 = string2 + string3;
                    } else {
                        string2 = string3.substring(0, n2 + 1);
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,.:");
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                    String string5 = this.getS(stringTokenizer);
                    String string6 = this.getS(stringTokenizer);
                    String string7 = this.getS(stringTokenizer);
                    if (!string5.equals("port")) continue;
                    aDGport = ADGport.put(string6);
                    if (string7 == null) {
                        aDGport.url = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("url")) {
                        aDGport.url = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("data")) {
                        aDGport.url = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("info")) {
                        aDGport.info = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("text")) {
                        aDGport.text = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("rangeX")) {
                        aDGport.rangeX = this.getRange(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("rangeY")) {
                        aDGport.rangeY = this.getRange(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("rangeF")) {
                        aDGport.rangeF = this.getRange(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("background")) {
                        aDGport.gndName = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("backcolor")) {
                        aDGport.gndColor = this.getI(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("window")) {
                        aDGport.window = new Rectangle(this.getI(stringTokenizer2), this.getI(stringTokenizer2), this.getI(stringTokenizer2), this.getI(stringTokenizer2));
                        continue;
                    }
                    if (string7.equals("mode")) {
                        this.iRendMode = aDGport.renderMode;
                        this.sRendMode = this.getS(stringTokenizer2);
                        if (this.sRendMode != null) {
                            this.setMode("POINT", 1);
                            this.setMode("GRND", 256);
                            this.setMode("WIRE", 2);
                            this.setMode("FLAT", 4);
                            this.setMode("TEXT", 8);
                            this.setMode("ZBUF", 16);
                            this.setMode("RECT", 64);
                            this.setMode("REFL", 128);
                            this.setMode("SHAD", 32);
                            this.setMode("SELF", 2048);
                            this.setMode("INFO", 512);
                            this.setMode("TRACK", 1024);
                            this.setMode("FILT", 8192);
                            this.setMode("MAGN", 32768);
                            this.setMode("DUBL", 16384);
                            this.setMode("CORR", 131072);
                            this.setMode("PICK", 262144);
                            this.setMode("PICKE", 524288);
                            this.setMode("PICKO", 0x100000);
                            this.setMode("PROG", 0x200000);
                            this.setMode("LOOP", 0x400000);
                            this.setMode("DMAP", 0x800000);
                            this.setMode("BLUR", 0x1000000);
                        }
                        aDGport.renderMode = this.iRendMode;
                        continue;
                    }
                    if (string7.equals("link")) {
                        string6 = this.getS(stringTokenizer);
                        string7 = this.getS(stringTokenizer);
                        if (string6 == null) {
                            string6 = " ";
                        }
                        if (aDGport.links == null) {
                            aDGport.links = new Hashtable();
                        }
                        if ((object = (ADGlink)aDGport.links.get(string6)) == null) {
                            object = new ADGlink();
                            aDGport.links.put(string6, object);
                        }
                        if (string7 == null) {
                            ((ADGlink)object).url = this.getS(stringTokenizer2);
                            continue;
                        }
                        if (string7.equals("url")) {
                            ((ADGlink)object).url = this.getS(stringTokenizer2);
                            continue;
                        }
                        if (string7.equals("target")) {
                            ((ADGlink)object).target = this.getS(stringTokenizer2);
                            continue;
                        }
                        if (string7.equals("object")) {
                            ((ADGlink)object).object = this.getS(stringTokenizer2);
                            continue;
                        }
                        if (string7.equals("rangeX")) {
                            ((ADGlink)object).angle = this.getRange(stringTokenizer2);
                            continue;
                        }
                        if (string7.equals("frame")) {
                            ((ADGlink)object).frame = this.getI(stringTokenizer2);
                            continue;
                        }
                        if (!string7.equals("sound")) continue;
                        ((ADGlink)object).sound = this.getAudioClip(this.getDocumentBase(), this.getS(stringTokenizer2));
                        continue;
                    }
                    if (!string7.equals("slider")) continue;
                    string7 = this.getS(stringTokenizer);
                    if (aDGport.slider == null) {
                        aDGport.slider = new Slider();
                    }
                    object = aDGport.slider;
                    if (string7 == null) {
                        ((Slider)object).send = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (string7.equals("send")) {
                        ((Slider)object).send = this.getS(stringTokenizer2);
                        continue;
                    }
                    if (!string7.equals("sens")) continue;
                    ((Slider)object).sens = this.getF(stringTokenizer2);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void Progress(float f) {
        this.progress = f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        f = this.pMin + f * (this.pMax - this.pMin);
        if (screen == null || (Render.mode & 0x200000) == 0) {
            return;
        }
        if (this.pMin >= this.pMax) {
            return;
        }
        FontMetrics fontMetrics = screen.getFontMetrics();
        int n = 10;
        int n2 = this.size().height - 40;
        int n3 = (int)((float)(this.progWidth - 2 * n) * f);
        int n4 = 4;
        if (n3 < 0) {
            return;
        }
        screen.setColor(this.InfoColor);
        screen.drawString("Loading data...", n, n2);
        screen.setColor(Color.red);
        screen.fillRect(n, n2 + fontMetrics.getAscent() + 2, n3, n4);
    }

    public Point getMousePos() {
        return new Point(this.mouse.x < 0 ? 0 : (this.mouse.x >= this.d.width ? this.d.width - 1 : this.mouse.x), this.mouse.y < 0 ? 0 : (this.mouse.y >= this.d.height ? this.d.height - 1 : this.mouse.y));
    }

    protected void checkRegistr() {
        boolean bl = this.regApp && this.regDat;
        ADGport aDGport = ADGport.get("info");
        if (aDGport != null) {
            aDGport.active = bl;
        }
        if ((aDGport = ADGport.get("infp")) != null) {
            aDGport.active = !bl;
        }
    }

    public void play(AudioClip audioClip) {
        if (audioClip != null) {
            audioClip.play();
        }
    }

    public void update() {
        this.update(this.unionRect);
    }

    public void update(Rectangle rectangle) {
        if (screen == null || imageScreen == null) {
            return;
        }
        Graphics graphics = screen.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(imageScreen, 0, 0, null);
    }

    private float limit(float f, float f2, float f3) {
        if (f < -f3) {
            return -f3;
        }
        if (f > f3) {
            return f3;
        }
        if (Math.abs(f) > f2) {
            return f;
        }
        if (f < 0.0f) {
            return -f2;
        }
        return f2;
    }

    public synchronized void update(Graphics graphics) {
        if (this.d == null) {
            return;
        }
        this.setSize(this.d);
        this.beginFrame();
        this.flipFrame();
    }

    public void Drag(int n, int n2) {
        this.posx = n;
        this.posy = n2;
        this.posf = n2;
        this.dragmode = true;
    }

    public boolean existFile(String string) {
        boolean bl = false;
        try {
            InputStream inputStream = this.checkFile(this.nospace(string));
            bl = inputStream != null;
            inputStream.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Thread" + Math.random());
            this.thread.start();
        }
    }

    public void scaleFrame(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        int n2;
        int n3;
        if (rectangle.isEmpty()) {
            return;
        }
        int n4 = n3 = rectangle.width;
        int n5 = n2 = rectangle.height;
        int n6 = this.g.pitch;
        int n7 = n = n6 * (rectangle.y - rectangle2.y) * 2 + (rectangle.x - rectangle2.x) * 2;
        n4 <<= 1;
        n7 += n6;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = this.pitch * (rectangle.y + n8) + rectangle.x;
            if (n8 == n5 - 1) {
                n6 = 0;
            }
            int n10 = n7 + n4 - 1;
            int n11 = n7 + 1;
            while (n11 < n7 + n4) {
                int n12 = n11 < n10 ? n11 + 1 : n10;
                int n13 = 0xFCFCFF & this.g.scr[n11 - 1 - n6];
                n13 += 0xFCFCFF & this.g.scr[n12 - n6];
                n13 += 0xFCFCFF & this.g.scr[n11 - 1 + n6];
                n13 += 0xFCFCFF & this.g.scr[n12 + n6];
                n13 >>= 2;
                n13 &= 0xFEFEFF;
                n13 += 0xFEFEFF & this.g.scr[n11];
                n13 >>= 1;
                n13 &= 0xFEFEFF;
                int n14 = 0xFCFCFF & this.g.scr[n11 - 1];
                n14 += 0xFCFCFF & this.g.scr[n12];
                n14 += 0xFCFCFF & this.g.scr[n11 - n6];
                n14 += 0xFCFCFF & this.g.scr[n11 + n6];
                n14 >>= 2;
                this.scr[n9++] = n13 + (n14 &= 0xFEFEFF) >> 1;
                n11 += 2;
            }
            n7 += n6 << 1;
            ++n8;
        }
    }

    public InputStream openFile(String string) {
        InputStream inputStream = this.checkFile(this.nospace(string));
        if (inputStream == null) {
            inputStream = this.checkFile(string);
        }
        return inputStream;
    }

    public boolean keyDown(int n) {
        if (!this.loaded || this.port.model == null) {
            return false;
        }
        switch (n) {
            case 70: 
            case 102: {
                Render.mode ^= 0x2000;
                break;
            }
            case 67: 
            case 99: {
                Render.mode ^= 0x20000;
                break;
            }
            case 77: 
            case 109: {
                Render.mode ^= 0x8000;
                break;
            }
            case 84: 
            case 116: {
                Render.mode ^= 8;
                break;
            }
            case 90: 
            case 122: {
                Render.mode ^= 0x10;
                break;
            }
            case 82: 
            case 114: {
                this.port.model.reset();
                this.velz = 0.0f;
                this.posx = 0.0f;
                this.posy = 0.0f;
                break;
            }
            case 43: 
            case 61: 
            case 187: {
                this.velz += 1.0f;
                break;
            }
            case 45: 
            case 95: 
            case 189: {
                this.velz -= 1.0f;
                break;
            }
            case 32: {
                this.vf = 0.0f;
                this.vy = 0.0f;
                this.vx = 0.0f;
                this.velz = 0.0f;
                break;
            }
            case 33: 
            case 1002: {
                this.vf -= this.FSens;
                break;
            }
            case 34: 
            case 1003: {
                this.vf += this.FSens;
                break;
            }
            case 38: 
            case 1004: {
                this.vy += this.YSens * this.Sens;
                break;
            }
            case 40: 
            case 1005: {
                this.vy -= this.YSens * this.Sens;
                break;
            }
            case 37: 
            case 1006: {
                this.vx += this.XSens * this.Sens;
                break;
            }
            case 39: 
            case 1007: {
                this.vx -= this.XSens * this.Sens;
            }
        }
        return true;
    }

    public boolean keyDown(Event event, int n) {
        return this.keyDown(n);
    }

    Rectangle getStringRect(String string, int n, int n2) {
        if (n >= this.d.width) {
            return null;
        }
        if (n2 >= this.d.height) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        FontMetrics fontMetrics = screen.getFontMetrics();
        rectangle.x = n;
        rectangle.y = n2;
        rectangle.width = fontMetrics.stringWidth(string) + 2;
        rectangle.height = fontMetrics.getHeight() + 2;
        if (rectangle.x + rectangle.width >= this.d.width) {
            rectangle.width = this.d.width - rectangle.x;
        }
        if (rectangle.y + rectangle.height >= this.d.height) {
            rectangle.height = this.d.height - rectangle.y;
        }
        return rectangle;
    }

    public void loadGround() {
        int n;
        Rectangle rectangle = this.port.window;
        Dimension dimension = new Dimension(rectangle.getSize());
        boolean bl = dimension.width == this.d.width && dimension.height == this.d.height;
        this.g.gnd = null;
        this.gnd = null;
        if (!bl) {
            if (this.panel) {
                this.gnd = this.getPixels("panel.jpg", this.d);
            }
            if (this.gnd == null) {
                this.gnd = new int[this.d.width * (this.d.height + 1)];
            }
        }
        if ((Render.mode & 0x100) == 0) {
            return;
        }
        if (this.g.gnd == null && this.gndName != null) {
            this.g.gnd = this.getPixels(this.gndName, dimension);
        }
        if (this.g.gnd == null && this.isBackColor) {
            this.g.gnd = new int[dimension.width * (dimension.height + 1)];
            n = this.BackColor.getRGB() & 0xFFFFFF | 1;
            int n2 = 0;
            while (n2 < this.g.gnd.length) {
                this.g.gnd[n2] = n;
                ++n2;
            }
        }
        if (bl) {
            this.gnd = this.g.gnd;
        } else if (this.g.gnd != null) {
            n = 0;
            while (n < rectangle.height) {
                System.arraycopy(this.g.gnd, rectangle.width * n, this.gnd, this.pitch * (rectangle.y + n) + rectangle.x, rectangle.width);
                ++n;
            }
        }
        this.g.gnd = null;
    }

    void draw(Rectangle rectangle) {
        if (this.consumer == null) {
            return;
        }
        this.consumer.setPixels(0, 0, rectangle.width, rectangle.height, (ColorModel)this.colorModel, this.scr, this.d.width * rectangle.y + rectangle.x, this.d.width);
        this.consumer.imageComplete(2);
        this.update(rectangle);
    }

    public ADGview() {
        ADGload.app = this;
        ADGport.app = this;
        Slider.app = this;
        Model3D.app = this;
        Material.app = this;
    }

    public void paint(Graphics graphics) {
        if (this.d == null) {
            return;
        }
        if (this.d.width == 0) {
            return;
        }
        if (this.d.height == 0) {
            return;
        }
        this.setSize(this.d);
        this.update(screen);
    }

    public boolean showDocument(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (this.standAlone) {
            return false;
        }
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            this.getAppletContext().showDocument(uRL, string2 == null ? this.deftarget : string2);
        }
        catch (Exception exception) {
            this.showInfo("Can't upen URL..." + string);
            return false;
        }
        return true;
    }

    protected void setMode(String string, int n) {
        int n2 = this.sRendMode.indexOf(string);
        if (n2 >= 0) {
            if (n2 > 0 && this.sRendMode.charAt(n2 - 1) == '-') {
                this.iRendMode &= ~n;
                return;
            }
            this.iRendMode |= n;
        }
    }

    public boolean WasOut() {
        boolean bl = this.wasOut;
        this.wasOut = false;
        return bl;
    }

    private void AddPos(float f, float f2, boolean bl) {
        float f3;
        float f4 = this.vf;
        if (this.FovMode) {
            f4 = f2;
            f2 = 0.0f;
        }
        if (this.tarCntX > 0) {
            f3 = 1.0f - (float)(this.tarCntX += -1) / (float)this.tarMaxX;
            f3 *= 1.0f - f3;
            this.vx *= 1.0f - f3;
            this.posx = this.posx * (1.0f - f3) + this.tarX * f3;
        }
        if (this.tarCntY > 0) {
            f3 = 1.0f - (float)(this.tarCntY += -1) / (float)this.tarMaxY;
            f3 *= f3;
            this.vy *= 1.0f - f3;
            this.posy = this.posy * (1.0f - f3) + this.tarY * f3;
        }
        if (this.tarCntF > 0) {
            f3 = 1.0f - (float)(this.tarCntF += -1) / (float)this.tarMaxF;
            f3 *= f3;
            this.vf *= 1.0f - f3;
            this.posf = this.posf * (1.0f - f3) + this.tarF * f3;
        }
        if (bl) {
            this.vx = (float)((double)this.vx * 0.98);
            this.vy = (float)((double)this.vy * 0.98);
            this.vf = (float)((double)this.vf * 0.98);
        }
        this.posx += f;
        this.posy += f2;
        this.posf += f4;
        if (this.posf < -44.0f) {
            this.posf = -44.0f;
        }
        if (this.posf > 134.0f) {
            this.posf = 134.0f;
        }
    }

    public synchronized void showInfo(String string) {
        boolean bl;
        if (screen == null) {
            return;
        }
        if (!this.loaded) {
            this.Progress(this.progress);
            if (this.debug == 0) {
                return;
            }
        }
        if (string != null) {
            if ((Render.mode & 0x200) == 0) {
                if (!this.standAlone) {
                    this.showStatus(string);
                }
            } else {
                this.infoString = string;
                this.trace(this.infoString);
                this.update(screen);
            }
        } else if (this.port.model != null) {
            if ((Render.mode & 0x200) == 0) {
                this.infoString = this.gndString;
            } else {
                long l = System.currentTimeMillis();
                if (this.averTime == null) {
                    this.averTime = new FilterFloat(100);
                    this.time = l;
                }
                long l2 = (long)this.averTime.get(l - this.time);
                this.time = l;
                this.infoString = "" + this.d.width + "*" + this.d.height + " Faces " + this.g.qface + " Verts " + this.g.qvert + " Length " + this.g.pixDat + "  Frame time " + l2 + "ms";
                if ((Render.mode & 0x40) > 0) {
                    this.showStatus(this.infoString);
                    this.infoString = null;
                }
            }
        }
        if (this.infoString == null) {
            return;
        }
        int n = 10;
        int n2 = this.size().height - 20;
        if (this.port != null && this.port.window != null) {
            n = this.port.window.x + 10;
            n2 = this.port.window.y + this.port.window.height - 20;
        }
        boolean bl2 = bl = n2 > this.port.window.y + this.port.window.height;
        if (!bl && infoBack) {
            this.drawString(this.infoString, n, n2, !this.regApp || !this.regDat ? new Color(8, 8, 8) : this.InfoColor);
            this.infoRect = this.strRect;
            return;
        }
        if (bl) {
            Rectangle rectangle = this.getStringRect(this.infoString, n, n2);
            if (this.gnd != null) {
                this.draw(rectangle);
            } else {
                screen.setColor(this.BackColor);
                screen.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        screen.setColor(!this.regApp || !this.regDat ? Color.red : this.InfoColor);
        screen.drawString(this.infoString, 10, this.size().height - 15);
    }

    public void setProgress(float f, float f2) {
        this.pMin = f;
        this.pMax = f2;
        this.Progress(0.0f);
    }

    protected String password(String string) {
        int n = 1;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            if (string.charAt(n3) != ' ') {
                if ((n *= string.charAt(n3) + '\u0001') < 0) {
                    n = -n;
                }
                n %= 305419896;
            }
            ++n3;
        }
        char[] cArray = new char[17];
        n3 = 0;
        do {
            int n4 = n % 10;
            switch (n3 % 6) {
                case 0: {
                    n4 += 65;
                    n /= 2;
                    break;
                }
                case 1: {
                    n4 += 66;
                    n /= 3;
                    break;
                }
                case 2: {
                    n4 += 48;
                    n /= 4;
                    break;
                }
                case 3: {
                    n4 += 48;
                    n /= 5;
                    break;
                }
                case 4: {
                    n4 += 48;
                    n /= 6;
                    break;
                }
                case 5: {
                    n4 = 45;
                }
            }
            cArray[n3] = (char)n4;
        } while (++n3 < 17);
        return new String(cArray);
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return true;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
    }

    int getI(StringTokenizer stringTokenizer) {
        try {
            return (int)Float.valueOf(stringTokenizer.nextToken()).floatValue();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void show() {
        if (!this.standAlone) {
            super.show();
            return;
        }
        if (this.choice != null) {
            this.choice.move(this.size().width - this.choice.size().width - 3, 3);
        }
        super.show();
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.pressed = true;
        if (this.dragmode) {
            return this.mouseMove(event, n, n2);
        }
        this.stop = this.wait;
        this.AddVel(n - this.mx, n2 - this.my, 1.0f, 1.0f);
        this.mx = n;
        this.my = n2;
        this.AddPos(this.vx, this.vy, true);
        return true;
    }

    public boolean setText(String string) {
        this.mtlText = string;
        return true;
    }

    public boolean isSpace(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == ' ') {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }
}

