#include <graph.h>
#include <time.h>
#include <stdlib.h>

#define Getrandom( min, max ) ((rand() % (int)(((max)+1) - (min))) + (min))

clock_t interval[80], previoustime[80];
char screenbuffer[2000];

void Doevents();
void Move( int );
void Refresh();

void main()
{
	int i;
	srand( (unsigned)time( NULL ) );
	for( i = 0; i < 80; i++ )
	{
		interval[i] = Getrandom( 40, 10000 );
		previoustime[i] = 0;
	}
	_setvideomode( _TEXTC80 );
	_clearscreen( _GCLEARSCREEN );
	_settextcolor( 2 );
	_wrapon( _GWRAPOFF );
	_displaycursor( _GCURSOROFF );
	for( i = 0; i < 2000; i++ )
		screenbuffer[i] = '\x020';
	while( 1 )
	{
		Doevents();
		Refresh();
	}
}

void Doevents()
{
	int i, j;
	clock_t *itvptr, currtime, *pvtptr;
	itvptr = interval;
    currtime = clock();
	pvtptr = previoustime;
	for( i = 0; i < 80; i++ )
	{
		if( currtime - *pvtptr > *itvptr )
		{
			*pvtptr = currtime;
			Move( i );
		}
		itvptr++;
		pvtptr++;
	}
}

void Move( int column )
{
	int i;
	char *scnbufptr;
	scnbufptr = &screenbuffer[column];
	for( i = 0; i < 24; i++ )
	{
		*scnbufptr = *(scnbufptr + 80);
		scnbufptr += 80;
	}
	*scnbufptr = Getrandom( '0', '9' );
}

void Refresh()
{
	int i;
	_settextposition( 1, 1 );
	_wrapon( _GWRAPON );
	_outmem( screenbuffer, 1999 );
	_wrapon( _GWRAPOFF );
	_outmem( screenbuffer, 1 );
}
