#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <conio.h>
#include <graph.h>

#define KBD_LEFT 0x4B00
#define KBD_RIGHT 0x4D00
#define KBD_ENTER 0x0D

void swap(int *pa, int *pb);
int kbd();

void main()
{
	int i, j, biglooper;
	int a[10];
	int b[4], aChecked[4], bChecked[4];
	int aNum, bNum, key;
	struct rccoord textpos;

	srand( (unsigned)time(NULL) );
	for(i = 0; i < 10; i++)
		a[i] = (i + 1) % 10; /* assigning value 1 .. 0 */
	for(i = 0; i < 4; i++)
		swap( &a[i] , &a[10 - 1 - rand() % (10 - i)] );
		/* assigning random numbers to a[0] to a[3] */

	for(biglooper = 0; biglooper < 8; biglooper++)
	{
		memset(bChecked, 0, sizeof(bChecked));
		/* here bChecked is used to record the usage of "b" buffer */
		_outtext("Please enter the number you guess: [....]");
		textpos = _gettextposition();
		textpos.col = 37;
		_settextposition(textpos.row, 37);
		while(1)
		{
			/* data consistency list in this loop:
			 * textpos, b, bChecked; real screen position
			 */

			if( (key = getch()) == 0 )
				key = getch() << 8;

			switch(key)
			{
			case KBD_RIGHT:
				if(textpos.col != 37 + 3)
				{
					textpos.col++;
					_settextposition(textpos.row, textpos.col);
				}
				break;
			case KBD_LEFT:
				if(textpos.col != 37)
				{
					textpos.col--;
					_settextposition(textpos.row, textpos.col);
				}
				break;
			case KBD_ENTER:
				{
					int valid = 1;
					for(i = 0; i < 4; i++)
					{
						if(!bChecked[i])
						{
							valid = 0;
							break;
						}
					}
					if(valid)
						goto BREAK_LOOP;
				}
				break;
			default:
				if( '0' <= key && key <= '9' )
				{ /* check the duplication first */
					{
						int duplicate = 0;
						for(i = 0; i < 4; i++)
						{
							if(bChecked[i] && key - '0' == b[i])
							{
								duplicate = 1;
								break;
							}
						}
						if(!duplicate)
						{
							b[textpos.col - 37] = key - '0';
							bChecked[textpos.col - 37] = 1;
							{
								char buf[2] = {key, '\0'};
								_outtext(buf);
								if( textpos.col - 37 == 3 ) /* if at the right end of the line */
									_settextposition(textpos.row, textpos.col); /* jump back to previous position */
								else
									textpos.col++; /* remember to keep all the data consistent */
							}
						}
						else /* because i still keeps the value, the value can be replaced */
						{
							bChecked[i] = 0;
							_settextposition(textpos.row, 37 + i);
							_outtext(".");
							b[textpos.col - 37] = key - '0';
							bChecked[textpos.col - 37] = 1;
							{
								char buf[2] = {key, '\0'};
								_settextposition(textpos.row, textpos.col);
								/* remember to set to the correct place before writing to screen */
								_outtext(buf);
								if( textpos.col - 37 == 3 ) /* if at the right end of the line */
									_settextposition(textpos.row, textpos.col); /* jump back to previous position */
								else
									textpos.col++; /* remember to keep all the data consistent */
							}
						}
					}
				}
			}
		}
	BREAK_LOOP:
		_outtext("\n");
		memset(bChecked, 0, sizeof(bChecked));
		memset(aChecked, 0, sizeof(aChecked));
		aNum = 0;
		for(i = 0; i < 4; i++)
		{
			if(a[i] == b[i])
			{
				aChecked[i] = 1; /* check the found item */
				bChecked[i] = 1; /* ditto */
				aNum++;
			}
		}
		bNum = 0;
		for(i = 0; i < 4; i++)
		{
			if(!bChecked[i])
			{
				for(j = 0; j < 4; j++)
				{
					if(!aChecked[j])
					{
						if(b[i] == a[j])
						{
							aChecked[j] = 1;
							bChecked[i] = 1;
							bNum++;
						}
					}
				}
			}
		}
		if(aNum != 4)
		{
			{
				char buf[16];
				sprintf(buf, "%dA %dB\n", aNum, bNum);
				_outtext(buf);
			}
		}
		else
		{
			_outtext("Yes, that's right!\n");
			break;
		}
	}
	if(aNum != 4)
	{
		_outtext("Sorry, your guess is wrong!\n");
		{
			char buf[64];
			sprintf(buf, "The correct answer is %d%d%d%d", a[0], a[1], a[2], a[3]);
			_outtext(buf);
		}
	}
}

void swap(int *pa, int *pb)
{
	int temp;
	temp = *pa;
	*pa = *pb;
	*pb = temp;
}

int kbd()
{
	int key;
	if(!kbhit())
		return 0;
	else
	{
		if( (key = getch()) == 0 )
			return getch() << 8;
		else
			return key;
	}
}
