#include <graph.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include "cexpr0.h"

int OnGridX(int i);
int OnGridY(int i);
int Func(double f, double *g);
int ScrPos(int i, int *j);
void ScrSet();
double round(double f);
int InSpan(FILE *stream, double x);
double LineReadCalc(FILE *stream, double x);
char *FileGetLine(char *str, int maxlen, FILE *fp);

double fMaxX, fMaxY, fMinX, fMinY, fTransX, fTransY;
int iGrids;
double fGridX, fGridY;
extern double varX;

void main()
{
	int i, j, c;
	double fDelta;
	InitFuncFactor();/* Always remember to call this to initialize function
		list, never forget!!! */
	_setvideomode(_VRES16COLOR);
	_clearscreen(_GCLEARSCREEN);
	/* Set the screen variables */
	ScrSet();
	_clearscreen(_GCLEARSCREEN);
	while(1)
	{
		/* Drawing the function */
		_setcolor(7);
		for(i = 0; i < 640;)
		{
			while(!ScrPos(i, &j) && i < 640)
				i++;
			_moveto(i, j);
			while(ScrPos(i, &j) && i < 640)
			{
				_lineto(i, j);
				i++;
			}
		}
		/* Drawing the Grids */
		if(iGrids)
		{
			for(i = 0; i < 640; i++)
			{
				if(j = OnGridX(i))
				{
					_setcolor(j);
					_moveto(i, 0);
					_lineto(i, 479);
				}
			}
			for(j = 0; j < 480; j++)
			{
				if(i = OnGridY(j))
				{
					_setcolor(i);
					_moveto(0, j);
					_lineto(639, j);
				}
			}
		}
		/* Accept key information */
		while(1)
		{
			if(c = getch())
			{
				switch(tolower(c))
				{
				case '.':
					fDelta = (fMaxX - fMinX) / 4;
					fMaxX -= fDelta;
					fMinX += fDelta;
					fTransX = (fMaxX - fMinX) / 639;
					fDelta = (fMaxY - fMinY) / 4;
					fMaxY -= fDelta;
					fMinY += fDelta;
					fTransY = 479 / (fMaxY - fMinY);
					goto BREAK_DO0;
				case ',':
					fDelta = (fMaxX - fMinX) / 2;
					fMaxX += fDelta;
					fMinX -= fDelta;
					fTransX = (fMaxX - fMinX) / 639;
					fDelta = (fMaxY - fMinY) / 2;
					fMaxY += fDelta;
					fMinY -= fDelta;
					fTransY = 479 / (fMaxY - fMinY);
					goto BREAK_DO0;
				case 'a':
					fDelta = (fMaxX - fMinX) * .2;
					fMaxX = fMaxX + fDelta;
					fMinX = fMinX + fDelta;
					goto BREAK_DO0;
				case 'w':
					fDelta = (fMaxY - fMinY) * .2;
					fMaxY = fMaxY - fDelta;
					fMinY = fMinY - fDelta;
					goto BREAK_DO0;
				case 'd':
					fDelta = (fMaxX - fMinX) * .2;
					fMaxX = fMaxX - fDelta;
					fMinX = fMinX - fDelta;
					goto BREAK_DO0;
				case 'x':
					fDelta = (fMaxY - fMinY) * .2;
					fMaxY = fMaxY + fDelta;
					fMinY = fMinY + fDelta;
					goto BREAK_DO0;
				case 'g':
					iGrids = iGrids ? 0 : 1;
					goto BREAK_DO0;
				case 't':
					fGridX *= 2;
					fGridY *= 2;
					goto BREAK_DO0;
				case 'b':
					fGridX /= 2;
					fGridY /= 2;
					goto BREAK_DO0;
				case 27:
					goto EXIT_PROGRAM;
				}
			}
			else
				getch();/* clears getch() second byte */
		}
BREAK_DO0:
		/* Before redrawing, clears the screen */
		_clearscreen(_GCLEARSCREEN);
	}
EXIT_PROGRAM:
	;
}

int Func(double f, double *g)
{
	int k;
	static FILE *fp1 = NULL;
	static firstRun = 1;
	if(firstRun)/* Just started */
	{
		fp1 = fopen("funcdraw.ini", "r");
		firstRun = 0;
	}
	if(!fp1)/* file not opened */
	{
		*g = f * f;
		k = 1;
	}
	else
	{
		rewind(fp1);
		k = 0;/* clears k to avoid end-of-file */
		while(!feof(fp1) && !k)
		{
			if(InSpan(fp1, f))
				k = 1;
			*g = LineReadCalc(fp1, f);/* always get g to pass the line in file */
		}
	}
	/* no close() calling, the file will be automatically closed on exit */
	return k;
}

int OnGridX(int i)
{
	double f, f1;
	int ret;
	f = fTransX / fGridX;
	f1 = (i * fTransX + fMinX) / fGridX;
	if(floor(f1 - f * .5) != floor(f1 + f * .5))
	{
		ret = 1;
		if((f1 - f * .5) * (f1 + f * .5) < 0)
			ret = 14;
	}
	else
		ret = 0;
	return ret;
}

int OnGridY(int i)
{
	double f, f1;
	int ret;
	f = 1 / fTransY / fGridY;
	f1 = (fMaxY - i / fTransY) / fGridY;
	if(floor(f1 - f * .5) != floor(f1 + f * .5))
	{
		ret = 1;
		if((f1 - f * .5) * (f1 + f * .5) < 0)
			ret = 4;
	}
	else
		ret = 0;
	return ret;
}

int ScrPos(int i, int *j)
{
	int k;
	double h, f, g;
	f = i * fTransX + fMinX;
	k = Func(f, &g);
	/* The screen coordinates are up-side down. */
	if(k)
	{
		h = (fMaxY - g) * fTransY;
		if(h < 0 || h > 479)
			k = 0;
		else
			*j = round(h);
	}
	return k;
}

double round(double f)
{
	if(f - floor(f) >= .5)
		return ceil(f);
	else
		return floor(f);
}

void ScrSet()
{
	char c;
	int useDefaults = 0;
	printf("Do you want to use the default values? ");
	fflush(stdin);
	c = getchar();
	if(tolower(c) == 'y')
	{
		useDefaults = 1;
	}
	else
	{
		printf("Please enter MX, MY, mX, mY: ");
		fflush(stdin);
		scanf("%lf, %lf, %lf, %lf", &fMaxX, &fMaxY, &fMinX, &fMinY);
		printf("Please enter Grids ON/OFF[0/1], GX, GY: ");
		fflush(stdin);
		scanf("%d, %lf, %lf", &iGrids, &fGridX, &fGridY);
		/* fMaxX should be larger than fMinX */
		if(fMaxX <= fMinX || fMaxY <= fMinY)
			useDefaults = 1;
		/* fGridX should be above zero */
		if(fGridX <= 0)
			fGridX = 1;
		if(fGridY <= 0)
			fGridY = 1;
	}
	if(useDefaults)
	{
		fMaxX = 10;
		fMaxY = 7.5;
		fMinX = -10;
		fMinY = -7.5;
		iGrids = 0;
		fGridX = 1;
		fGridY = 1;
		fTransX = (fMaxX - fMinX) / 639;
		fTransY = 479 / (fMaxY - fMinY);
	}
}

int InSpan(FILE *stream, double x)
{
	char str[32];
	double left = -HUGE_VAL, right = HUGE_VAL;
	int i, j;
	CALCEXPR tempRslt;
	if(!FileGetLine(str, 32, stream))
		return 0;
	else
	{
		for(i = 0; str[i] != 0 && str[i] != ','; i++)
		{
			if(str[i] == 'x')
				return 0;/* avoid x, which will cause error calculation in CalcExpr() */
		}
		tempRslt = CalcExpr(str, 0, i - 1);
		if(tempRslt.errorno == -1)/* valid */
			left = tempRslt.result;
		for(j = i; str[j]; j++)
		{
			if(str[j] == 'x')
				return 0;/* avoid x */
		}
		tempRslt = CalcExpr(str, i + 1, j - 1);
		if(tempRslt.errorno == -1)/* valid */
			right = tempRslt.result;
		return (x > left && x < right);/* successfully returns */
	}
}

double LineReadCalc(FILE *stream, double x)
{
	char str[256];
	CALCEXPR tempRslt;
	double ret;
	varX = x;
	if(FileGetLine(str, 256, stream))
	{
		tempRslt = CalcExpr(str, 0, strlen(str));
		if(tempRslt.errorno == -1)/* successful */
			ret = tempRslt.result;
		else
			ret = 0;/* not successful */
	}
	else
		ret = 0;
	return ret;
}

char *FileGetLine(char *str, int maxlen, FILE *fp)
{
	int i, buf;
	if(feof(fp))
		return NULL;
	for(i = 0; i < maxlen - 1; i++)
	{
		if((buf = fgetc(fp)) == -1)
			break;
		else if(buf == '\n')
			break;/* i keeps its value */
		else
			str[i] = buf;
	}
	str[i] = '\0';
	return str;/* successfully returns */
}
