#include "mouse.h"
#include <graph.h>
#include <stdio.h>
#include <conio.h>

typedef struct _Area
{
	int x1, y1, x2, y2;
	struct _Area *next;
}Area;

typedef struct _Key
{
	int key;
	struct _Key *next;
}Key;

Area *areah = NULL;
Key *keyHead = NULL;
EVENT mouse = { 0, 0, 0 };

int AddToKey( int key );
int AreaCheck();
int AddToArea( Area area1 );
int InArea( Area area );
void ClearAreas();
int WaitForClick();
int GetKey();
void ClearKeys();

void main()
{
	int a;
	Area area[4] = {
		{ 1, 1, 10, 1, NULL },
		{ 71, 1, 80, 1, NULL },
		{ 1, 25, 10, 25, NULL },
		{ 71, 25, 80, 25, NULL } };

	for( a = 3; a >= 0; a-- )
		AddToArea( area[a] );

	for( a = (int)'4'; a >= (int)'1'; a-- )
		AddToKey( a );

	_setvideomode( _TEXTC80 );
	_clearscreen( _GCLEARSCREEN );
	_setbkcolor( 7 );
	_settextcolor( 0 );
	_wrapon( _GWRAPOFF );
	_outtext( "  Area 1  " );
	_settextposition( 1, 71 );
	_outtext( "  Area 2  " );
	_settextposition( 25, 1 );
	_outtext( "  Area 3  " );
	_settextposition( 25, 71 );
	_outtext( "  Area 4  " );
	_setbkcolor( 0 );
	_settextcolor( 7 );
	do
	{
		a = WaitForClick();
		_settextposition( 13, 28 );
		printf( "You clicked in Area %d.", a );
	}while( a != 4 );
}

int EventCheck( int key )
{
	int a;
	Area *area;
	Key *keyPtr;
	if( mouse.fsBtn )
		for( a = 1, area = areah; area != NULL; a++, area = area->next )
			if( InArea( *area ) )
				return a;
	for( a = 1, keyPtr = keyHead; keyPtr != NULL; a++, keyPtr = keyPtr->next )
		if( key == keyPtr->key )
			return a;
	return 0;
}

int AddToArea( Area area1 )
{
	Area *area;
	area = (Area *)malloc( (size_t)sizeof( Area ) );
	if( area == NULL )
		return EOF;
	area->next = areah;
	areah = area;
	area->x1 = area1.x1;
	area->y1 = area1.y1;
	area->x2 = area1.x2;
	area->y2 = area1.y2;
	return 0;
}

int InArea( Area area )
{
	int x, y, x1, y1, x2, y2;
	x = mouse.x;
	y = mouse.y;
	x1 = area.x1;
	y1 = area.y1;
	x2 = area.x2;
	y2 = area.y2;
	if( x>=x1 && y>=y1 && x<=x2 && y<=y2 )
		return 1;
	return 0;
}

void ClearAreas()
{
	Area *area;
	for( area = areah->next; areah != NULL; area = area->next )
	{
		free( areah );
		areah = area;
	}
}

int WaitForClick()
{
	int a;
	do
	{
		GetPtrPos( &mouse );
		a = GetKey();
	}while( !(a = EventCheck( a )) );
	return a;
}

int AddToKey( int key )
{
	Key *newKey;
	newKey = (Key *)malloc( (size_t)sizeof( Key ) );
	if( newKey == NULL )
		return EOF;
	newKey->next = keyHead;
	newKey->key = key;
	keyHead = newKey;
	return 0;
}

int GetKey()
{
	int a;
	if( !kbhit() )
		return 0;
	if( a = getch() )
		return a;
	else
		return getch();
}

void ClearKeys()
{
	Key *keyPtr;
	for( keyPtr = keyHead->next; keyHead != NULL; keyPtr = keyPtr->next )
	{
		free( keyHead );
		keyHead = keyPtr;
	}
}
