typedef struct _CALCEXPR
{
	int errorno;/* -1 represents no error, position represents syntax error, other errors are listed below */
	double result;
	int right;
}CALCEXPR;
/* other errors: -2 --- operator calculation error
-3 --- number string cannot be converted or number string too long
-4 --- function calculation error
-5 --- function or variable not exist
-6 --- function name or variable name too long */
typedef struct _CALCFUNC
{
	int errorno;/* non-zero represents error, zero represents no error, other errors are listed below */
	double result;
}CALCFUNC;
/* other errors: */
typedef struct _FUNCFACTOR
{
	char name[33];
	int arguNum;
}FUNCFACTOR;

CALCEXPR CalcExpr(const char *expr, int left, int right);/* this function requires a right pointer to show where to end */
CALCEXPR GetNumber(const char *expr, int left);/* this function doesn't need a right pointer, because a function has a closing parenthese to close the expression, and a number has a definite end of its expression */
CALCEXPR GetFuncOrVar(const char *expr, int left);/* this function doesn't need a right pointer, because a function has a closing parenthese to close the expression, and a variable has a definite end of its expression */
int FuncExist(const char *funcname);/* this function decides whether a function exists, if true it returns the number of its parameters, otherwise returns -1 */
CALCFUNC CalcFunc(const char *funcname, double *argulist);/* this function calculates a function with specified values */
int OperStepGTE(char oper1, char oper2);/* this function decides whether the left operator is >= the right operator */
CALCFUNC GetVar(const char *varname);
CALCFUNC OperCalc(char oper, double param1, double param2);
void InitFuncFactor();

