#include <stdio.h>
#include <string.h>
#include <math.h>
#include "cexpr0.h"

FUNCFACTOR funcList[15];
double varX;

CALCEXPR CalcExpr(const char *expr, int left, int right)
{
	int i, operStkTop = -1, numStkTop = -1;/* numStk and operStk are two stacks for calculation */
	char c, operStk[10], operator;/* temporarily the result is held by operator and operand */
	CALCEXPR exprval;/* temporarily holds the operand result, and will be made the return value */
	CALCFUNC operCalcRslt;/* temporarily holds the operator-operand calculation result */
	double numStk[10], operand;
	i = left;/* i represents the position in the string */
	if(left > right)
	{
		exprval.errorno = i;
		return exprval;/* a big error: left is more than right */
	}
	while(1)
	{
		/* from here is the operand reading part */
		while(expr[i] == ' ')
			i++;/* skips blank space */
		c = expr[i];
		if(c == '\0')
		{
			exprval.errorno = i;
			return exprval;/* a big error: expression empty or without succeeding operand */
		}
		if(c >= '0' && c <= '9' || c == '-' || c == '.')
			exprval = GetNumber(expr, i);/* prototype: CALCEXPR GetNumber(const char *expr, int left) */
		else if(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '(')
			exprval = GetFuncOrVar(expr, i);/* prototype: CALCEXPR GetFuncOrVar(const char *expr, int left) */
		else
		{
			exprval.errorno = i;/* there should be either a variable or a function */
			return exprval;
		}
		if(exprval.errorno != -1)
			return exprval;/* expression return value indicates error */
		/* makes a copy of operand */
		operand = exprval.result;
		/* operand reading finishes */
		/* from here is the operator reading part */
		i = exprval.right + 1;/* reassigns i value, exprval.right is the right pointer given by GetNumber() or GetFuncOrVar() */
		while(expr[i] == ' ')
			i++;/* skips blank space */
		c = expr[i];/* to get the operator, if the operator is not available just return the processed value */
		if(c == '\0' || i > right)
		{
			break;/* the operator is not available, pass to past treatment */
		}
		else
		{
			switch(c)
			{
			case '+':
			case '-':
			case '*':
			case '/':
			case '^':
				;/* do nothing, wait for treatment */
				break;
			default:
				exprval.errorno = i;/* after an operand should be an operator, if there is neither end-of-string nor operator, an error is easy to be seen */
				return exprval;/* an error occurred */
			}
		}
		i++;/* increases i, for next reading operation */
		/* makes a copy of operator */
		operator = c;
		/* operator reading finishes */
		/* the calculation part */
		if(operStkTop >= 0)
		{
			while(OperStepGTE(operStk[operStkTop], operator))/* calculates the existing stack elements until the priority of the current operator is the highest in the operStk */
			{
				operCalcRslt = OperCalc(operStk[operStkTop], numStk[numStkTop], operand);/* prototype: CALCFUNC OperCalc(char oper, double param1, double param2); */
				if(operCalcRslt.errorno)/* an error occurred */
				{
					exprval.errorno = -2;/* operator calculation error */
					return exprval;
				}
				operand = operCalcRslt.result;
				numStkTop--; operStkTop--;/* decreases numStkTop and operStkTop for next operation */
				if(numStkTop == -1)
					break;/* ends if stack empty */
			}
		}/* executes regular transportation */
		operStkTop++; operStk[operStkTop] = operator;/* transports operator to the stack*/
		numStkTop++; numStk[numStkTop] = operand;/* transports operand to the stack */
		/* calculation finishes */
	}
	/* past treatment */
	while(numStkTop != -1)
	{
		operCalcRslt = OperCalc(operStk[operStkTop], numStk[numStkTop], operand);
		if(operCalcRslt.errorno)/* an error occurred */
		{
			exprval.errorno = -2;/* operator calculation error */
			return exprval;
		}
		operand = operCalcRslt.result;
		numStkTop--; operStkTop--;/* decreases numStkTop and operStkTop for next operation */
	}
	exprval.result = operand;
	exprval.right = right;
	exprval.errorno = -1;/* no error, successfully returns */
	return exprval;
}

CALCFUNC OperCalc(char oper, double param1, double param2)
{
	CALCFUNC ret;
	ret.errorno = 0;/* clear errorno */
	switch(oper)
	{
	case '+':
		ret.result = param1 + param2;
		break;
	case '-':
		ret.result = param1 - param2;
		break;
	case '*':
		ret.result = param1 * param2;
		break;
	case '/':
		if(param2 == 0.0)
		{
			ret.errorno = 1;/* an error occurs */
			break;
		}
		ret.result = param1 / param2;
		break;
	case '^':
		if(param1 == 0.0 && param2 <= 0.0)/* e.g.: 0 ^ 0; 0 ^ -1 */
		{
			ret.errorno = 1;/* an error occurs */
			break;
		}
		else if(param1 < 0.0 && param2 != floor(param2))/* e.g.: -1 ^ .5 */
		{
			ret.errorno = 1;/* an error occurs */
			break;
		}
		ret.result = pow(param1, param2);
		break;
	}
	return ret;
}

CALCEXPR GetNumber(const char *expr, int left)
{
	int state, j, i = left;/* initialize i */
	char c;
	CALCEXPR ret;
	char str[32];
	c = expr[i];/* a full part number may seem to be like this: -1.23e-23, seven parts in all */
	if(c >= '0' && c <= '9')
	{
		state = 1;
	}
	else switch(c)
	{
	case '-':
		state = 0;
		break;
	case '.':
		state = 2;
		break;
	}
	i++;/* increases i for the next operation */
	while(1)
	{
		c = expr[i];
		switch(state)
		{
		case 0:/* state '-' */
			if(c >= '0' && c <= '9')
			{
				state = 1;
			}
			else
			{
				ret.errorno = i;
				return ret;
			}
			break;
		case 1:
			if(c >= '0' && c <= '9')
				;/* goes on without doing anything */
			else if(c == '.')
				state = 2;
			else if(c == 'e' || c == 'E')
				state = 4;
			else
			{
				ret.right = i - 1;/* assigns right value and goes out of the loop */
				goto BREAK_DO;
			}
			break;
		case 2:
			if(c >= '0' && c <= '9')
				state = 3;
			else
			{
				ret.errorno = i;/* there should be number on the right of '.' */
				return ret;
			}
			break;
		case 3:
			if(c >= '0' && c <= '9')
				;/* goes on without doing anything */
			else if(c == 'e' || c == 'E')
				state = 4;
			else
			{
				ret.right = i - 1;/* assigns right value and goes out of the loop */
				goto BREAK_DO;
			}
			break;
		case 4:
			if(c == '-')
				state = 5;
			else if(c <= '9' && c >= '0')
				state = 6;
			else
			{
				ret.errorno = i;
				return ret;
			}
			break;
		case 5:
			if(c >= '0' && c <= '9')
				state = 6;
			else
			{
				ret.errorno = i;
				return ret;
			}
			break;
		case 6:
			if(c >= '0' && c <= '9')
				;/* doing nothing */
			else
			{
				ret.right = i - 1;/* assigns right value and goes out of the loop */
				goto BREAK_DO;
			}
			break;
		}
		i++;/* increase i */
	}
BREAK_DO:
	if(ret.right - left > 31)/* the number is too long for the string to hold */
	{
		ret.errorno = -3;
		return ret;/* an error occurred */
	}
	for(j = left; j < i; j++)
		str[j - left] = expr[j];
	str[j - left] = '\0';
	if(sscanf(str, "%lf", &ret.result))/* get the value, treatment if successful */
	{
		ret.errorno = -1;/* successfully return */
		return ret;
	}
	else
	{
		ret.errorno = -3;/* string cannot be converted */
		return ret;
	}
}

CALCEXPR GetFuncOrVar(const char *expr, int left)
{
	int j, k, l, m, i = left;/* initialize i */
	char str[33];
	double argulist[10];
	CALCFUNC tempRslt;
	CALCEXPR ret;
	while((expr[i] >= 'A' && expr[i] <= 'Z') || (expr[i] >= 'a' && expr[i] <= 'z')
			|| expr[i] == '_' || (expr[i] >= '0' && expr[i] <= '9'))
		i++;
	if(i - left > 31)/* name too long */
	{
		ret.errorno = -6;/* function name or variable name too long */
		return ret;
	}
	if(expr[i] == '(')/* function */
	{
		for(j = left; j <= i; j++)/* gets the name of the function, including '(' */
		{
			str[j - left] = expr[j];
		}
		str[j - left] = '\0';
		if((j = FuncExist(str)) != -1)/* function exists */
		{
			if(j > 0)/* argument number not zero */
			{
				for(k = 0; j > 0; j--, k++)
				{
					i++;/* increases i to point at the right of the split mark such as ',' */
					l = i;/* assigns left value */
					m = 0;/* resets m to store the layer number of the parenthesis in the expression */
					while(1)
					{
						if(m == 0 && expr[i] == ((j == 1) ? ')' : ','))
							break;
						else if(expr[i] == '(')
							m++;/* increases parenthesis layer number */
						else if(expr[i] == ')')
							m--;/* without the possibility of the ending parenthesis (it is excluded above), decreases parenthesis layer */
						else if(expr[i] == '\0')/* end-of-string error */
						{
							ret.errorno = i;
							return ret;
						}
						i++;/* increases string pointer */
					}
					ret = CalcExpr(expr, l, i - 1);
					if(ret.errorno != -1)/* an error occurred */
						return ret;
					argulist[k] = ret.result;
				}
				tempRslt = CalcFunc(str, argulist);
				if(tempRslt.errorno)/* an error occurred */
				{
					ret.errorno = -4;/* function calculation error */
					return ret;
				}
				ret.result = tempRslt.result;
				ret.right = i;
				ret.errorno = -1;
				return ret;/* successfully returns */
			}
			else
			{
				if(expr[++i] != ')')
				{
					ret.errorno = i;/* an error occurs */
					return ret;
				}
				else
				{
					tempRslt = CalcFunc(str, argulist);
					/* no parameter, so always successful */
					ret.right = i;
					ret.result = tempRslt.result;
					ret.errorno = -1;
					return ret;
				}
			}
		}
		else/* function doesn't exist */
		{
			ret.errorno = -5;/* function not exist error */
			return ret;
		}
	}
	else/* variable */
	{
		for(j = left; j < i; j++)/* gets the name of the variable */
		{
			str[j - left] = expr[j];
		}
		str[j - left] = '\0';
		tempRslt = GetVar(str);
		if(tempRslt.errorno)/* variable not exist */
		{
			ret.errorno = -5;
			return ret;
		}
		ret.errorno = -1;
		ret.result = tempRslt.result;
		ret.right = i - 1;
		return ret;/* successfully returns */
	}
}

int FuncExist(const char *funcname)
{
	int i, isExist = 0;/* clears the mark */
	char str[33];
	for(i = 0; funcList[i].name[0]; i++)
	{
		strcpy(str, funcList[i].name);
		if(!strcmp(funcname, funcList[i].name))/* found */
		{
			isExist = 1;
			break;
		}
	}
	if(isExist)/* found */
		return funcList[i].arguNum;
	else
		return -1;/* not found */
}

CALCFUNC CalcFunc(const char *funcname, double *argulist)
{
	int i = 0;
	CALCFUNC ret;
	while(strcmp(funcname, funcList[i].name) != 0)
		i++;/* goes to the function number, specifying internal functions */
	switch(i)
	{
	case 0:
		ret.result = sin(argulist[0]);
		break;
	case 1:
		ret.result = cos(argulist[0]);
		break;
	case 2:
		ret.result = tan(argulist[0]);/* although (2 * n - 1) * pi should be avoided but it's almost impossible to decide correctly through a computer */
		break;
	case 3:
		ret.result = argulist[0];
		break;
	case 4:
		ret.result = exp(argulist[0]);/* automatical overflow avoiding */
		break;
	case 5:
		if(argulist[0] <= 0.0)
		{
			ret.errorno = 1;
			return ret;
		}
		ret.result = log(argulist[0]);
		break;
	case 6:
		if(argulist[0] < 0.0)
		{
			ret.errorno = 1;
			return ret;
		}
		ret.result = sqrt(argulist[0]);
		break;
	case 7:
		ret.result = floor(argulist[0]);
		break;
	case 8:
		ret.result = fabs(argulist[0]);
		break;
	case 9:
		ret.result = log10(argulist[0]);
	}
	ret.errorno = 0;/* no error, successfully returns */
	return ret;
}

void InitFuncFactor()
{
	int i, an[15] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
	char str[15][10] = {"sin(", "cos(", "tan(", "(", "exp(", "log(", "sqrt(", "floor(", "fabs(", "log10", "", "", "", "", ""};/* makes null string as the end of the function name list */
	for(i = 0; i < 15; i++)
	{
		strcpy(funcList[i].name, str[i]);
		funcList[i].arguNum = an[i];
	}
}

int OperStepGTE(char oper1, char oper2)
{
	int step1;
	switch(oper1)
	{
	case '+':
	case '-':
		step1 = 1;
		break;
	case '*':
	case '/':
		step1 = 2;
		break;
	case '^':
		step1 = 3;
		break;
	}
	switch(oper2)
	{
	case '+':
	case '-':
		return (step1 >= 1) ? 1 : 0;
	case '*':
	case '/':
		return (step1 >= 2) ? 1 : 0;
	case '^':
		return (step1 >= 3) ? 1 : 0;
	}
}

CALCFUNC GetVar(const char *varname)
{
	CALCFUNC ret;
	if(strcmp(varname, "x") != 0)/* variable not exist */
		ret.errorno = 1;/* an error occurred */
	else
	{
		ret.errorno = 0;
		ret.result = varX;/* gets the global variable as the variable request */
	}
	return ret;
}
