#include <graph.h>
#include <conio.h>
#include "boxinput.h"
#include "fixvalid.h"

#define LEFT 19200
#define RIGHT 19712
#define BACKSPACE 8
#define DELETE 21248
#define HOME 18176
#define END 20224
#define ENTER 13
#define ESC 27

void FixBoxIn( int x, int y, int len, int tc, int bc, double *dp,
			   int prec, int (*InKeySet)( int ) )
{
	struct videoconfig curVidConf;
	char fs[7], s[21], ds[21];
	int a, b, c, d, e, f, sl, dss = 0, dsp = 0;

	_getvideoconfig( &curVidConf );
	if( curVidConf.mode != _TEXTC80 )
		_setvideomode( _TEXTC80 );
	_displaycursor( _GCURSORON );

	sprintf( fs, "%%.%dlf", prec );
	sprintf( s, fs, *dp );
	for( a = 0; s[a]; a++ )
		ds[a] = s[a];
	sl = a;
	for( ; a < len; a++ )
		ds[a] = '\x020';
	ds[len] = 0;

	_settextposition( y, x );
	_displaycursor( _GCURSORON );
	_settextcolor( tc );
	_setbkcolor( bc );
	_outtext( ds );

	_settextposition( y, x );
	b = 1;
	while( b )
	{
		c = 0;
		while( !c )
		{
			a = WaitForKey();
			if( InKeySet( a ) )
				c = 1;
			else if( a == ENTER )
				c = 2;
			else if( a == ESC )
				c = 3;
			else if( a == BACKSPACE || a == LEFT || a == RIGHT
					 || a == DELETE || a == HOME || a == END )
				c = 4;
		}
		switch( c )
		{
			case 1:
				if( sl < 20 )
				{
					InsChar( s, dss + dsp, (char)a );
					sl++;

					if( dsp < len - 1 )
						dsp++;
					else
						dss++;
				}
				break;

			case 2:
				if( FixedValid( s ) && sscanf( s, "%lf", dp ) == 1 )
					b = 0;
				else
					printf( "\a" );
				break;

			case 3:
				b = 0;
				break;

			case 4:
				switch( a )
				{
					case LEFT:
						if( dss + dsp )
						{
							if( dsp )
								dsp--;
							else
								dss--;
						}
						break;
					case RIGHT:
						if( dss + dsp < sl )
						{
							if( dsp < len - 1 )
								dsp++;
							else
								dss++;
						}
						break;

					case HOME:
						dsp = 0;
						dss = 0;
						break;

					case END:
						if( sl - dss < len )
							dsp = sl - dss;
						else
						{
							dss = sl - len + 1;
							dsp = len - 1;
						}
						break;

					case DELETE:
						if( dss + dsp < sl )
						{
							DelChar( s, dss + dsp );
							sl--;
						}
						break;
					case BACKSPACE:
						if( dss + dsp )
						{
							DelChar( s, dss + dsp - 1 );
							sl--;
							if( dsp )
								dsp--;
							else
								dss--;
						}
				}
		}
		_settextposition( y, x );
		_outtext( BlkPrt( s, dss, len, ds ) );
		_settextposition( y, x + dsp );
	}
}

void DelChar( char *str, int pos )
{
	int i;
	for( i = pos; str[i]; i++ )
		str[i] = str[i + 1];
}

void InsChar( char *str, int pos, char ch )
{
	int i, j;
	for( j = 0; str[j]; j++ )
		;
	for( i = j; i != pos; i-- )
		str[i] = str[i - 1];
	str[pos] = ch;
	str[j + 1] = '\0';
}

int WaitForKey()
{
	int a;
	if( a = getch() )
		return a;
	return getch() * 0x100;
}

char *BlkPrt( char *s, int dss, int len, char *ds )
{
	int i, j;
	for( i = 0; s[dss + i] && i < len; i++ )
		ds[i] = s[dss + i];
	for( ; i < len; i++ )
		ds[i] = '\x020';
	return ds;
}
