#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct _DECLINT
{
	short len;
	unsigned short *ptr;
}DECLINT;

void TimeDec(DECLINT data1, DECLINT data2, DECLINT data3);
unsigned short *CreateDec(DECLINT *dataPtr, short n);
void CopyDec(DECLINT data1, DECLINT data2);
void PresetDec(DECLINT data1, short i);
void DestroyDec(DECLINT *dataPtr);
void ShowAns();/* the main process */

void main()
{
	ShowAns();
}

void ShowAns()
{
	short i, j, k;
	short n, flag;
	char str[5];
	DECLINT dli1, dli2, dli3;
	CreateDec(&dli1, 50);
	CreateDec(&dli2, 50);
	CreateDec(&dli3, 50);
	printf("Please enter an integer between 1 and 100: ");
	do
	{
		fflush(stdin);
	}while(scanf("%d", &n) < 1);
	printf("%d! = ", n);
	PresetDec(dli1, 1);
	for(i = 1; i <= n; i++)
	{
		PresetDec(dli2, i);
		TimeDec(dli1, dli2, dli3);
		CopyDec(dli1, dli3);
	}
	flag = 0;
	for(i = 49; i >= 0; i--)
	{
		if(!flag)
		{
			if(dli1.ptr[i])
				flag = 1;
		}
		if(flag)
		{
			itoa(dli1.ptr[i], str, 10);
			if(flag == 1)
				flag = 2;
			else
			{
				if((j = strlen(str)) < 4)
				{
					for(k = 0; k < 4 - j; k++)
						printf("0");
				}
			}
			printf(str);
		}
	}
	printf("\n");
}

void TimeDec(DECLINT data1, DECLINT data2, DECLINT data3)
{
	short i, j, data1Top, data2Top, n, m;
	unsigned long buf, timeBuf;
	PresetDec(data3, 0);
	for(i = data1.len - 1; i >= 0; i--)
	{
		if(data1.ptr[i])
			break;
	}
	data1Top = i;
	for(i = data2.len - 1; i >= 0; i--)
	{
		if(data2.ptr[i])
			break;
	}
	data2Top = i;
	if((data1Top + 1) + (data2Top + 1) > data3.len)
		return;
	for(i = 0; i <= data1Top; i++)
	{
		for(j = 0; j <= data2Top; j++)
		{
			timeBuf = (unsigned long)data1.ptr[i] * data2.ptr[j];
			buf = timeBuf % 10000 + data3.ptr[i + j];
			data3.ptr[i + j] = buf % 10000;
			if(buf > 10000)
			{
				n = i + j + 1;
				while(n < data3.len - 1)
				{
					if(data3.ptr[n] != 9999)
					{
						data3.ptr[n]++;
						break;
					}
					data3.ptr[n] = 0;
					n++;
				}
			}
			buf = timeBuf / 10000 + data3.ptr[i + j + 1];
			data3.ptr[i + j + 1] = buf % 10000;
			if(buf > 10000)
			{
				n = i + j + 2;
				while(n < data3.len - 1)
				{
					if(data3.ptr[n] != 9999)
					{
						data3.ptr[n]++;
						break;
					}
					data3.ptr[n] = 0;
					n++;
				}
			}
		}
	}
}

unsigned short *CreateDec(DECLINT *dataPtr, short n)
{
	dataPtr->ptr = (unsigned short *)malloc(n * 2);
	dataPtr->len = (dataPtr->ptr == NULL)? 0 : n;
}

void CopyDec(DECLINT data1, DECLINT data2)
{
	memset(data1.ptr, 0, data1.len * 2);
	memcpy(data1.ptr, data2.ptr, min(data1.len, data2.len) * 2);
}

void PresetDec(DECLINT data1, short i)
{
	memset(data1.ptr, 0, data1.len * 2);
	data1.ptr[0] = i;
}

void DestroyDec(DECLINT *dataPtr)
{
	free(dataPtr->ptr);
	dataPtr->len = 0;
}
