#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define BIT(data, index) (data[(index) / 16] & (1 << ((index) % 16)))
struct LONGINT
{
	short len;
	unsigned short *ptr;
};

void DispAns();/* the main process */
void Add(struct LONGINT adder1, struct LONGINT adder2, struct LONGINT ans);
void Sub(struct LONGINT subbed, struct LONGINT subber, struct LONGINT ans);
void Preset(struct LONGINT setter, short val);
void Time(struct LONGINT timer1, struct LONGINT timer2, struct LONGINT ans);
short Div(struct LONGINT divided, struct LONGINT divider, struct LONGINT quo, struct LONGINT rmd);
void Copy(struct LONGINT copied, struct LONGINT copier);
unsigned short *Create(struct LONGINT *created, short len);
void Destroy(struct LONGINT *destroyed);
short WindowGT(struct LONGINT left, struct LONGINT right, short leftBase, short rightBase, short leftTop, short rightTop);
void WindowSub(struct LONGINT subbed, struct LONGINT subber, short subBase, short subberBase, short subberTop);
void Inc(struct LONGINT li, short index);

void main()
{
	DispAns();
	/*struct LONGINT li1, li2, li3, li4;
	Create(&li1, 1);
	Create(&li2, 1);
	Create(&li3, 1);
	Create(&li4, 1);
	Preset(li1, 10);
	Preset(li2, 9);
	printf("%d ", Div(li1, li2, li3, li4));
	printf("%d\n", li4.ptr[0]);*/
}

void DispAns()
{
	char str[1023];
	short i, flag, n;
	struct LONGINT li1, li2, li3, li4;
	Create(&li1, 50);
	Create(&li2, 50);
	Create(&li3, 50);
	Create(&li4, 50);
	Preset(li2, 1);
	printf("Please enter the number (1~100): ");
	do
	{
		do
		{
			fflush(stdin);
		}while(scanf("%d", &n) < 1);
	}while(n > 100 || n < 1);
	printf("%d! = ", n);
	for(i = 2; i <= n; i++)
	{
		Preset(li1, i);
		Time(li1, li2, li3);
		Copy(li2, li3);
	}
	Preset(li1, 10);
	i = 0;
	while(Div(li2, li1, li3, li4))
	{
		str[i++] = li4.ptr[0] + '0';
		Copy(li2, li3);
	}
	str[i] = li4.ptr[0] + '0';
	flag = 0;
	for(i = i; i >= 0; i--)
	{
		if(str[i] != '0')
			flag = 1;
		if(flag)
			printf("%c", str[i]);
	}
	printf("\n"); fflush(stdin); getchar();
}

void Add(struct LONGINT adder1, struct LONGINT adder2, struct LONGINT ans)
{
	short i, n;
	long buf;
	Copy(ans, adder2);
	for(i = 0; i < ans.len; i++)
	{
		buf = (long)adder1.ptr[i] + ans.ptr[i];
		ans.ptr[i] = buf & 0x0000FFFF;
		if(buf & 0xFFFF0000)
		{
			n = i + 1;
			while(n < ans.len)
			{
				ans.ptr[n]++;
				if(ans.ptr[n])
					break;
				n++;
			}
		}
	}
}

void Sub(struct LONGINT subbed, struct LONGINT subber, struct LONGINT ans)
{
	short i, n;
	long buf;
	Copy(ans, subbed);
	for(i = 0; i < ans.len; i++)
	{
		buf = (long)ans.ptr[i] - subber.ptr[i];
		ans.ptr[i] = buf & 0x0000FFFF;
		if(buf < 0)
		{
			n = i + 1;
			while(n < ans.len)
			{
				ans.ptr[n]--;
				if(ans.ptr[n] != 0xFFFF)
					break;
				n++;
			}
		}
	}
}

void Preset(struct LONGINT setter, short val)
{
	memset(setter.ptr, 0, setter.len * 2);
	setter.ptr[0] = val;
}

void Time(struct LONGINT timer1, struct LONGINT timer2, struct LONGINT ans)
{
	short i, j, n, timer1Top, timer2Top;
	unsigned long buf, timeBuf;
	for(i = timer1.len - 1; i >= 0; i--)
	{
		if(timer1.ptr[i])
			break;
	}
	timer1Top = i;
	for(i = timer2.len - 1; i >= 0; i--)
	{
		if(timer2.ptr[i])
			break;
	}
	timer2Top = i;
	Preset(ans, 0);
	if((timer1Top + 1) + (timer2Top + 1) > ans.len)
		return;
	for(i = 0; i <= timer1Top; i++)
	{
		for(j = 0; j <= timer2Top; j++)
		{
			timeBuf = (unsigned long)timer1.ptr[i] * timer2.ptr[j];
			buf = (timeBuf & 0x0000FFFF) + ans.ptr[i + j];
			ans.ptr[i + j] = buf & 0x0000FFFF;
			if(buf & 0xFFFF0000)
			{
				n = i + j + 1;
				while(n < ans.len)
				{
					ans.ptr[n]++;
					if(ans.ptr[n])
						break;
					n++;
				}
			}
			buf = (timeBuf >> 16) + ans.ptr[i + j + 1];
			ans.ptr[i + j + 1] = buf & 0x0000FFFF;
			if(buf & 0xFFFF0000)
			{
				n = i + j + 2;
				while(n < ans.len)
				{
					ans.ptr[n]++;
					if(ans.ptr[n])
						break;
					n++;
				}
			}
		}
	}
}

short Div(struct LONGINT divided, struct LONGINT divider, struct LONGINT quo,
		  struct LONGINT rmd)
{
	short i, j, dividerTop, rmdTop;
	short ret;
	Copy(rmd, divided);
	for(i = rmd.len - 1; i >= 0; i--)
	{
		if(rmd.ptr[i])
			break;
	}
	rmdTop = i * 16 + 15;
	Preset(quo, 0);
	for(i = divider.len - 1; i >= 0; i--)
	{
		if(divider.ptr[i])
			break;
	}
	for(i = i * 16 + 15; i >= 0; i--)
	{
		if(BIT(divider.ptr, i))
			break;
	}
	dividerTop = i;

	for(j = rmdTop - dividerTop; j >= 0; j--)
	{
		if(!WindowGT(divider, rmd, 0, j, dividerTop, rmdTop))
		{
			WindowSub(rmd, divider, j, 0, dividerTop);
			Inc(quo, j);
			rmdTop = j + dividerTop;
		}
	}
	ret = 0;
	for(j = 0; j < quo.len; j++)
	{
		if(quo.ptr[j])
		{
			ret = 1;
			break;
		}
	}
	return ret;
}

void Copy(struct LONGINT copied, struct LONGINT copier)
{
	memset(copied.ptr, 0, copied.len * 2);
	memcpy(copied.ptr, copier.ptr, min(copier.len, copied.len) * 2);
}

unsigned short *Create(struct LONGINT *created, short len)
{
	created->ptr = (unsigned short *)malloc(len * 2);
	created->len = len;
	return created->ptr;
}

void Destroy(struct LONGINT *destroyed)
{
	free(destroyed->ptr);
	destroyed->len = 0;
}

short WindowGT(struct LONGINT left, struct LONGINT right, short leftBase,
			   short rightBase, short leftTop, short rightTop)
{
	short i, ret, realLeftTop, realRightTop;
	ret = 0;
	for(i = rightTop; !BIT(right.ptr, i); i--)
		;
	realRightTop = i;
	for(i = leftTop; !BIT(left.ptr, i); i--)
		;
	realLeftTop = i;
	if(realLeftTop - leftBase > realRightTop - rightBase)
		return 1;
	if(realLeftTop - leftBase < realRightTop - rightBase)
		return 0;
	for(i = realLeftTop - leftBase; i >= 0; i--)
	{
		if(BIT(left.ptr, leftBase + i) && !BIT(right.ptr, rightBase + i))
		{
			ret = 1;
			break;
		}
		else if(!BIT(left.ptr, leftBase + i) && BIT(right.ptr, rightBase + i))
		{
			ret = 0;
			break;
		}
	}
	return ret;
}

void WindowSub(struct LONGINT subbed, struct LONGINT subber, short subBase,
			   short subberBase, short subberTop)
{
	int j, n;
	for(j = subberTop - subberBase; j >= 0; j--)
	{
		if(BIT(subber.ptr, j + subberBase))
		{
			n = j + subBase;
			while(!BIT(subbed.ptr, n))
			{
				subbed.ptr[n / 16] += 1 << (n % 16);
				n++;
			}
			subbed.ptr[n / 16] -= 1 << (n % 16);
		}
	}
}

void Inc(struct LONGINT li, short index)
{
	int i;
	for(i = index; i < li.len * 16; i++)
	{
		if(!BIT(li.ptr, i))
		{
			li.ptr[i / 16] += 1 << (i % 16);
			break;
		}
	}
}
