// Sphere.h: interface for the CSphere class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SPHERE_H__016BFC64_38B8_11D7_B70D_000000000000__INCLUDED_)
#define AFX_SPHERE_H__016BFC64_38B8_11D7_B70D_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Shape.h"  // base class
#include "Plane.h"  // dependency
#include "Ray.h" // dependency
#include "3DVector.h" // dependency
#include "3DDirection.h" // dependency
#include "3DMatrix.h" // dependency

class CSphere: public CShape
{
protected:
    C3DVector center;
    double radius;
    static const int lineRes; // line resolution
public:
    bool CalculateIntersection(const CRay &ray, C3DVector &intersection, bool negative) const;
    CSphere(const C3DVector &vctCenter, double dblRadius);
	CSphere();
	virtual ~CSphere();
    void Draw(CDC *pDC, const CScreenViewer &screenViewer1, POINT ptBasePosition) const;
    void Draw2(CDC *pDC, const CScreenViewer &screenViewer1, POINT ptBasePosition, int width) const;
    C3DDirection GetNormal(const C3DVector &pntOnSurf) const;
    void GetParameters(double &center_x, double &center_y, double &center_z, double &o_radius) const;
    CString GetShapeType(void) const;
    bool IsInObject(const C3DVector &pnt) const;
    bool IsInOrOnObject(const C3DVector &pnt) const;
    bool IsOnObject(const C3DVector &pnt) const;
    void Set(const C3DVector &vctCenter, double dblRadius);
    void SetParameters(double center_x, double center_y, double center_z, double o_radius);
    void SetToDefault(void);
};

#endif // !defined(AFX_SPHERE_H__016BFC64_38B8_11D7_B70D_000000000000__INCLUDED_)
