// Shape.h: interface for the CShape class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SHAPE_H__38E56A33_3843_11D7_B70C_000000000000__INCLUDED_)
#define AFX_SHAPE_H__38E56A33_3843_11D7_B70C_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "3DVector.h"   // dependency
#include "Ray.h" // dependency
#include "ScreenViewer.h"   // dependency
#include "3DDirection.h" // dependency
#include <math.h>

class CShape  
{
protected:
    POINT Draw_PntInCSToMnt(CDC *pDC, const C3DVector &vctPoint, const CScreenViewer &screenViewer1, POINT ptBasePosition) const;
    POINT Draw_PntInCSToMnt2(CDC *pDC, const C3DVector &vctPoint, const CScreenViewer &screenViewer1, POINT ptBasePosition, int width) const;
public:
	static const double PI;
public:
    virtual bool CalculateIntersection(const CRay &ray, C3DVector &intersection, bool negative) const;
	CShape();
	virtual ~CShape();
    virtual void Draw(CDC *pDC, const CScreenViewer &screenViewer1, POINT ptBasePosition) const;
    virtual void Draw2(CDC *pDC, const CScreenViewer &scrnVwr, POINT basePos, int width) const;
    virtual C3DDirection GetNormal(const C3DVector &pntOnSurf) const;
    virtual CString GetShapeType(void) const;
    virtual bool IsInObject(const C3DVector &pnt) const;
    virtual bool IsInOrOnObject(const C3DVector &pnt) const;
    virtual bool IsOnObject(const C3DVector &pnt) const;
};

#endif // !defined(AFX_SHAPE_H__38E56A33_3843_11D7_B70C_000000000000__INCLUDED_)
