// ScreenViewer.h: interface for the CScreenViewer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCREENVIEWER_H__F5DBF895_31A1_11D7_B6FD_000000000000__INCLUDED_)
#define AFX_SCREENVIEWER_H__F5DBF895_31A1_11D7_B6FD_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "3DVector.h"   // dependency
#include "3DDirection.h"    // dependency
#include "3DMatrix.h"   // dependency
#include "Plane.h"  // dependency
#include "Ray.h" // dependency
#include <math.h>

class CScreenViewer  
{
protected:
    struct buffer_t
    {
        C3DDirection u; // u axis in world coordinate system
        C3DDirection v; // v axis in world coordinate system
        C3DMatrix WToVMatrix;   // world to viewer matrix
        C3DVector vrp2; // vrp in viewer coordinates
        C3DMatrix WToSMatrix;   // world to screen matrix
        C3DMatrix SToCMatrix;   // screen to clipping space matrix
        C3DMatrix CToSMatrix;   // clipping to screen matrix
        C3DMatrix WToCMatrix;   // world to clipping space matrix
        C3DMatrix projectionMatrix; //projection matrix
        C3DMatrix CToSPrjMatrix; // clipping space to screen conversion and projection matrix
        double clipA;   // "a-value", z coordinate of the front clipping window in clipping space
    }buffer;
public:
    C3DVector vrp;      // view reference point, on the screen
    C3DVector cop;      // viewer position, relative to vrp in world coordinates
    C3DDirection vpn;   // screen direction, from the surface to deeper places
    C3DDirection vup;   // up direction from the viewer's point of view
	double uMax;        // maximum horizontal position of the screen
	double uMin;        // minimum horizontal position of the screen
	double vMax;        // maximum vertical position of the screen
	double vMin;        // minimum vertical position of the screen
	double frClip;      // z coordinate of the front clipping plane, which is nearer the eyes, position relative to the screen
	double bkClip;      // z coordinate of the back clipping plane, which is farther from the eyes, position relative to the screen
public:
    C3DMatrix ChMatrix(void) const;
    void Clip(CPlane &plnClippedPlane, CPlane &plnSourcePlane) const;
    C3DVector ClpBndIntersection(const C3DVector &vctInnerPoint, const C3DVector &vctOuterPoint) const;  // intersection of the clipping bound and a line segment
    C3DVector ConvertPointCToS(const C3DVector &vctPointInClpSpace) const;
    C3DVector ConvertPointSToC(const C3DVector &vctPointInScreen) const;
    POINT ConvertPointCToMonitor(const C3DVector &vctPointInClpSpc) const;
    POINT ConvertPointCToMonitor2(const C3DVector &pntInC, int width) const;
    POINT ConvertPointSToMonitor(const C3DVector &vctPointInScreen) const;
    C3DVector ConvertPointWToC(const C3DVector &vctPointInWorld) const;
    C3DVector ConvertPointWToS(const C3DVector &vctPointInWorld) const;
    void CreateRayThroughScreen(CRay &result, int xpos, int ypos, int xmax, int ymax) const;
    CScreenViewer(const CScreenViewer &svrSource);
	CScreenViewer();
	virtual ~CScreenViewer();
    bool IsInsideOrOnside(const C3DVector &vctPoint) const;
    C3DMatrix ProjectionMatrix(void) const;
    C3DVector ProjectPoint(const C3DVector &vctPointInScreen) const;
    C3DVector ProjectPointInClippingSpace(const C3DVector &vctPointInClpSpc) const;
    C3DMatrix RMatrix(void) const;
    void SetBasic(const C3DVector &newvrp, const C3DVector &newcop, const C3DDirection &newvpn, const C3DDirection &newvup);
    C3DMatrix TMatrix(void) const;
    void UpdateAll(void);
    void UpdateClpEnvironment(void);    // update the clipping environment
    void UpdateUV(void);
    void UpdateWToVMatrix(void);
    void UpdateWToSMatrix(void);
};

#endif // !defined(AFX_SCREENVIEWER_H__F5DBF895_31A1_11D7_B6FD_000000000000__INCLUDED_)
