// RenderBox.cpp : implementation file
//

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "RenderBox.h"
#include "Ray.h"
#include "Render.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRenderBox dialog


CRenderBox::CRenderBox(CWnd* pParent /*=NULL*/)
	: CDialog(CRenderBox::IDD, pParent), m_bitmap(), m_memoryDC()
{
	//{{AFX_DATA_INIT(CRenderBox)
	//}}AFX_DATA_INIT
}


void CRenderBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRenderBox)
	DDX_Control(pDX, IDOK, m_buttonOK);
	DDX_Control(pDX, IDC_STATIC_PICTURE, m_picture);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRenderBox, CDialog)
	//{{AFX_MSG_MAP(CRenderBox)
	ON_WM_PAINT()
	ON_MESSAGE(WM_THREAD_FINISHED, OnThreadFinished)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRenderBox message handlers

void CRenderBox::OnPaint() 
{
	m_criticalSection.Lock();
	CPaintDC dc( this ); // device context for painting; do not remark it
	CPaintDC controlDC( &m_picture );
	CRect pictureRect( 0, 0, m_pictureSize.cx, m_pictureSize.cy );
	CRect pasteRect;

	if( pasteRect.IntersectRect( &controlDC.m_ps.rcPaint, &pictureRect ) ) {
		controlDC.BitBlt( pasteRect.left, pasteRect.top, pasteRect.Width(), pasteRect.Height(), &m_memoryDC, pasteRect.left, pasteRect.top, SRCCOPY );
	}
	m_criticalSection.Unlock();
	// Do not call CDialog::OnPaint() for painting messages
}

UINT CRenderBox::RenderPicture(LPVOID pParam)
{
	CRenderBox *pRenderBox = (CRenderBox *)pParam;
	UINT i = 0;
	UINT j = 0;
	COLORREF colorReference1 = RGB( 0x00, 0xFF, 0x00 );
	COLORREF colorReference2 = RGB( 0x00, 0x00, 0xFF );
	COLORREF currentColor;
	UINT pictureWidth;
	UINT pictureHeight;
	CRect dialogUpdateRect( 0, 0, 1, 1 );
	CRect updateRect;
	CRay firstRay;

	pRenderBox->m_criticalSection.Lock();
	//pictureWidth = pRenderBox->m_pictureSize.cx;
	//pictureHeight = pRenderBox->m_pictureSize.cy;
	pictureWidth = 240;
	pictureHeight = 180;
	pRenderBox->m_quitMethod = QM_INTERRUPTED;
    while( !pRenderBox->m_toStop ) {
		pRenderBox->m_criticalSection.Unlock();
		updateRect.left = j;
		updateRect.top = i;
		updateRect.right = j + 1;
		updateRect.bottom = i + 1;
		pRenderBox->m_criticalSection.Lock();
		pRenderBox->m_memoryDC.SetPixel(j, i, RGB(0, 255, 0)); // indicator
		pRenderBox->InvalidateRect( &dialogUpdateRect, FALSE );
		pRenderBox->m_picture.InvalidateRect( &updateRect, FALSE );
		pRenderBox->m_criticalSection.Unlock();
		pRenderBox->m_pDocument->frontSv.CreateRayThroughScreen(
			firstRay, j - 160, i - 120, 160, 120);
		currentColor = CRender::RenderRay(
			firstRay, pRenderBox->m_pDocument->objset.cplxObjs);
		/* Tester code
		currentColor = RGB( 
			(
				GetRValue( colorReference1 ) * (pictureWidth - j + pictureHeight - i) +
				GetRValue( colorReference2 ) * (j + i)
			) / (pictureWidth + pictureHeight), 
			(
				GetGValue( colorReference1 ) * (pictureWidth - j + pictureHeight - i) +
				GetGValue( colorReference2 ) * (j + i)
			) / (pictureWidth + pictureHeight), 
			(
				GetBValue( colorReference1 ) * (pictureWidth - j + pictureHeight - i) +
				GetBValue( colorReference2 ) * (j + i)
			) / (pictureWidth + pictureHeight)
		);
		*/
		pRenderBox->m_criticalSection.Lock();
		pRenderBox->m_memoryDC.SetPixel( j, i, currentColor );
		pRenderBox->InvalidateRect( &dialogUpdateRect, FALSE );
		pRenderBox->m_picture.InvalidateRect( &updateRect, FALSE );
		pRenderBox->m_criticalSection.Unlock();
		j++;
		if( j == pictureWidth ) {
			i++;
			j = 0;
		}
		if( i == pictureHeight ) {
			i = 0;
			pRenderBox->m_criticalSection.Lock();
			pRenderBox->m_quitMethod = QM_NORMAL;
			break;
		}
		pRenderBox->m_criticalSection.Lock();
    }
	pRenderBox->m_criticalSection.Unlock();
	::SendMessage( pRenderBox->m_hWnd, WM_THREAD_FINISHED, 0, 0 );
	// Mustn't use dialog elements any more.
    return 0;
}

LRESULT CRenderBox::OnThreadFinished(WPARAM wParam, LPARAM lParam)
{
	if( m_quitMethod == QM_INTERRUPTED ) {
		CDialog::OnCancel();
	} else {
		SetWindowText("Ⱦ");
		m_running = false;
		m_buttonOK.EnableWindow();
	}
	return 0;
}

BOOL CRenderBox::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CDC *pControlDC = m_picture.GetDC();
	CRect tempRect;
	m_memoryDC.CreateCompatibleDC( pControlDC );
	m_picture.GetClientRect( &tempRect );
	m_pictureSize.cx = tempRect.Width();
	m_pictureSize.cy = tempRect.Height();
	m_bitmap.CreateCompatibleBitmap( pControlDC, m_pictureSize.cx, m_pictureSize.cy );
	m_picture.ReleaseDC( pControlDC );
	m_memoryDC.SelectObject( &m_bitmap );
	m_buttonOK.EnableWindow( FALSE );

	m_toStop = false;
	m_running = true;
	SetWindowText("Ⱦ...");
	AfxBeginThread( RenderPicture, this, THREAD_PRIORITY_NORMAL );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CRenderBox::OnCancel() 
{
	if( m_running ) {
		m_criticalSection.Lock();
		m_toStop = TRUE;
		m_criticalSection.Unlock();
	} else {
		CDialog::OnCancel();
	}
}
