COLORREF OldRenderRay(const CRay &firstray, const CPhysicalObject objects[], int numofobj)
{
	/*
    ASSERT(numofobj >= 0);
    if(numofobj == 0)
    {
        return CLight(0.0, 0.0, 0.0).ConvertToColorRef(1.0);;
    }

    CRay *pRay;     // pointer to current ray
    CRay rays[21];  // ray stack
    int progpos[21];   // progress position stack; "progress" means the progress of traversing the ray tree
    int depth;   // tracing depth
    C3DVector stpnt;    // buffer for the start point of the ray
    C3DVector temppnt;      // temporary point
    C3DVector nearestpnt;  // point nearest to start point of the ray
    bool newrayflag;     // new ray flag; whether there is a new ray or not
	CLight lights[21];  // lights in differenct layers; pRay->Light is not used for storing light
    CLight templight;      // temporary light
    int objidx[21];   // object indices in different layers
    int intscnt;   // count for intersections
    int i;  // loop variable
    const CPhysicalObject *pObject;   // pointer to current object
    int tmlvl; // time level; used to avoid spending too long time
    int drcirc[21]; // circle number when treating diffuse reflection
    int drang[21]; // angle when treating diffuse reflection
    CRay baserays[21]; // base rays when treating diffuse reflection
    C3DDirection tempdir; // temporary direction
    double theta; // temporary theta
    double phi; // temporary phi

    rays[0] = firstray;
    pRay = &rays[0];
	*/
    /*************************************************************************
     * progpos: holds the status of the traversing progress.
     * The traverse can be represented using a recursive form as follows:
     *
     * TRAVERSE(RAY)
     * {
     * POSITION0:
     *    DETERMINEOBJECT();
     *    IF(RAY != NULL)
     *    {
     * POSITION1:
     *       MRRAY = TRAVERSE(RAY->MR);
     * POSITION2:
     *       DRRAY = TRAVERSE(RAY->DR);
     * POSITION3:
     *       RFRRAY = TRAVERSE(RAY->RFR);
     * POSITION4:
     *       LIGHT = SUMLIGHT(MRRAY, DRRAY, RFRRAY);
     *       RAY.LIGHT = LIGHT;
     *    }
     * POSITION5:
     * }
     *
     * These positions are to be stored in the progpos array.
     ***************************************************************************/
	/*
    progpos[0] = 0;
    depth = 0;
    tmlvl = 0;
    while(depth >= 0)
    {
        switch(progpos[depth])
        {
        case 0:
            lights[depth].Set(0, 0, 0); // set to zero light; a light is required to return
            if(pRay != NULL && depth < 20 && tmlvl < 16){ // if depth is >= 20, the recurse cannot go on
                // get the index of object with which the ray intersects
                intscnt = 0; // reset intersection count
                for(i = 1; i < numofobj; i++){
                    if(objects[i].CalculateIntersection(*pRay, temppnt)){
                        intscnt++;
                        if(intscnt == 1){
                            nearestpnt = temppnt;
                            objidx[depth] = i;
                        }else if(temppnt.DistanceTo(stpnt) < nearestpnt.DistanceTo(stpnt)){
                            // take the nearer point
                            nearestpnt = temppnt;
                            objidx[depth] = i;
                        }
                    }
                }
                if(intscnt != 0){
                    progpos[depth] = 1;
                }else{   // return the background light (zero light)
                    progpos[depth] = 5;
                }
            }else{   // end current layer; return zero light
                progpos[depth] = 5;
            }
            break;
        case 1:
            // treat mirror reflection
            pObject = &objects[objidx[depth]];
            newrayflag = pObject->GetMRRay(*pRay, rays[depth + 1]); // try to get the mirror reflection ray
            if(newrayflag){ // the ray exists
                pRay = &rays[depth];
            }else{ // the ray doens't exist
                pRay = NULL;
            }
            // recurse
            progpos[depth] = 2; // the return address
            depth++;
            tmlvl++;
            progpos[depth] = 0; // the start address
            break;
        case 2:
            // decrement tmlvl
            tmlvl--;
            // add the light of mirror reflection first
            pObject = &objects[objidx[depth]];
            lights[depth].Add(pObject->FilterMRLight(lights[depth + 1]));
            // treat diffuse reflection: collect light over head
            newrayflag = objects[objidx[depth]].GetDRRay(*pRay, rays[depth + 1]);
            if(newrayflag){
                progpos[depth] = 20;
            }else{
                pRay = NULL;
                progpos[depth] = 25;
            }
            break;
        case 20:
			*/
            /* add light from many rays:
            -------------------------------------
                pRay = rays[depth + 1];
                baserays[depth] = rays[depth + 1];
                RECURSE(pRay);
                for(i = 1; i <= 9; i++){
                    for(j = 0; j < i * 6; j++){
                        phi = asin((double)i / 9.5); // this should be put here to avoid another stack
                        theta = PI * (double)j / (double)(i * 3);
                        rays[depth + 1].SetDirection(theta, phi);
                        RECURSE(pRay);
                    }
                }
            ---------------------------------------
             */
			/*
            pRay->Set(rays[depth + 1]);
            baserays[depth] = rays[depth + 1];
            drcirc[depth] = 1;
            drang[depth] = 0;
            // recurse
            progpos[depth] = 21;
            depth++;
            tmlvl += 8; // quite time-consuming
            progpos[depth] = 0; // always zero
            break;
        case 21:
            // decrement tmlvl
            tmlvl -= 8;
            // add the light
            // NOTE: 271 = 1 + (1 + 2 + ... + 9) * 6. It is the number of times of sampling.
            lights[depth].Add((1.0 / 271.0) * objects[objidx[depth]].FilterDRLight(lights[depth + 1]));
            phi = asin((double)drcirc[depth] / 9.5); // this should be put here to avoid another stack
            theta = CShape::PI * (double)drang[depth] / (double)(drcirc[depth] * 3);
            tempdir.SetThetaPhi(theta, phi);
            tempdir *= C3DMatrix::RotateMatrix(rays[depth].GetDirection().GetPhi(), 1);
            tempdir *= C3DMatrix::RotateMatrix(rays[depth].GetDirection().GetTheta(), 2);
            rays[depth + 1].SetDirection(tempdir);
            // recurse
            progpos[depth] = 21;
            depth++;
            tmlvl += 8;
            progpos[depth] = 0;
            drang[depth]++;
            // the recurse will happen after the variables are incremented
            if(drang[depth] >= drcirc[depth] * 6){
                drang[depth] = 0;
                drcirc[depth]++;
            }
            if(drcirc[depth] > 9){
                tmlvl -= 8; // decrement tmlvl
                progpos[depth] = 3;
            }
            break;
        case 25:
            // recurse
            progpos[depth] = 26;
            depth++;
            tmlvl++;
            progpos[depth] = 0;
        case 26:
            // decrement tmlvl
            tmlvl--;
            progpos[depth] = 3;
            break;
        case 3:
            // get the refraction ray
            newrayflag = objects[objidx[depth]].GetRfrRay(*pRay, rays[depth + 1]);
            if(newrayflag){
                pRay = &rays[depth + 1];
            }else{
                pRay = NULL;
            }
            // recurse
            progpos[depth] = 4;
            depth++;
            tmlvl++;
            progpos[depth] = 0;
            break;
        case 4:
            // decrement tmlvl
            tmlvl--;
            // add the light returned by the refraction recurse if necessary (there may be no recurse so it might be zero)
            if(pRay != NULL){ // the ray for recurse has been set (pRay = rays[depth + 1])
                pObject = &objects[objidx[depth]];
                lights[depth].Add(pObject->FilterRfrLight(lights[depth + 1], rays[depth].GetStartPoint().DistanceTo(pRay->GetStartPoint())));
                if(pObject->IsLightSource()){
                    lights[depth].Add(pObject->GetLight());
                }
            }
            progpos[depth] = 5;
            break;
        case 5:
            depth--;
            // no need to set progpos
            break;
        }
    }
    return lights[0].ConvertToColorRef(1);
	*/
}
