// Render.h: interface for the CRender class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RENDER_H__18604F8B_44EC_4BE1_9134_2B79C57F3A5A__INCLUDED_)
#define AFX_RENDER_H__18604F8B_44EC_4BE1_9134_2B79C57F3A5A__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "MainFrm.h"

#include "Ray.h"    // dependency
#include "PhysicalObject.h" // dependency
#include "3DMatrix.h" // dependency

class CRender  
{
protected:
	static int MaxTimeLevel;
    static CLight RenderRay_Traverse(const CRay &ray, const CObArray &objects, int tmlvl, C3DVector *pEndPoint = NULL);
    static CLight RenderRay_Diffuse(const CRay &baseray, const CObArray &objects, int tmlvl);
public:
	CRender();
	virtual ~CRender();
    static COLORREF RenderRay(const CRay &firstray, const CObArray &objects);
	friend class CMainFrame;
};

#endif // !defined(AFX_RENDER_H__18604F8B_44EC_4BE1_9134_2B79C57F3A5A__INCLUDED_)
