// Render.cpp: implementation of the CRender class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "Render.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

int CRender::MaxTimeLevel = 10;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRender::CRender()
{
}

CRender::~CRender()
{
}

COLORREF CRender::RenderRay(const CRay &firstray, const CObArray &objects)
{
	int nObjects = objects.GetSize();
    ASSERT(nObjects >= 0);
    if (nObjects == 0) {
        return CLight(0.0, 0.0, 0.0).ConvertToColorRef(1.0);;
    } else {
        return RenderRay_Traverse(firstray, objects, 0).ConvertToColorRef(1.0);
    }
}

CLight CRender::RenderRay_Traverse(
	const CRay &ray, // ray in
	const CObArray &objects, // objects
	int timeLevel, // time level
	C3DVector *pEndPoint // end point for returning
)
{
    CLight light; // light result
    if (timeLevel + 1 > MaxTimeLevel)
	{
		return light; // too time-consuming
	}

    int i; // loop variable
    C3DVector sttPnt; // start point of the ray
    C3DVector tmpPnt; // temporary point
    C3DVector nrstPnt; // nearest point
    int itsnCnt; // intersection count
    int objIdx; // object index
    CRay newRay; // may be the MR ray, the base DR ray or the refraction ray
    //CRay drRay; // diffuse reflection ray
    int tmpTrndIdx; // temporary tree node index
	int trndIdx; // tree node index (buffer for the object)
	int nObjects = objects.GetSize();

	// find the nearest intersection
    itsnCnt = 0;
    for (i = 0; i < nObjects; i++) {
        if (((CPhysicalObject *)(objects[i]))->CalculateIntersection(ray, tmpPnt, tmpTrndIdx)) {
            itsnCnt++;
            if (itsnCnt == 1) {
				objIdx = i;
                nrstPnt = tmpPnt;
				trndIdx = tmpTrndIdx;
            } else if (tmpPnt.DistanceTo(sttPnt) < nrstPnt.DistanceTo(sttPnt)) {
				objIdx = i;
                nrstPnt = tmpPnt;
				trndIdx = tmpTrndIdx;
            }
        }
    }
    if (itsnCnt == 0) { return light; } // default light
	if (pEndPoint != NULL)
	{
		*pEndPoint = nrstPnt;
	}

    if (((CPhysicalObject *)(objects[objIdx]))->IsLightSource()) {
		return ((CPhysicalObject *)(objects[objIdx]))->GetLight();
	}

	// get the out going ray and traverse
    if (((CPhysicalObject *)(objects[objIdx]))->GetMRRay(ray, nrstPnt, trndIdx, newRay)) {
        light.Add(((CPhysicalObject *)(objects[objIdx]))->
			FilterMRLight(
				RenderRay_Traverse(
					newRay, objects, timeLevel + 1
				)
			)
		);
    }
    if (((CPhysicalObject *)(objects[objIdx]))->GetDRRay(ray, nrstPnt, trndIdx, newRay)) {
        light.Add(((CPhysicalObject *)(objects[objIdx]))->
			FilterDRLight(
				RenderRay_Diffuse(
					newRay, objects, timeLevel
				)
			)
		); // pass the timeLevel on
    }
	{
		int rfrDir = ((CPhysicalObject *)(objects[objIdx]))->
			GetRfrRay(ray, nrstPnt, trndIdx, newRay); 
			// refraction direction: in or out
		// 1 - in; 0 - no refraction; -1 - out
		if (rfrDir != 0)
		{
			if (rfrDir > 0)
			{ // into the object
				C3DVector newRayEndPoint;
				CLight sublight(RenderRay_Traverse(
					newRay, objects, timeLevel + 1, &newRayEndPoint));
				light.Add(((CPhysicalObject *)(objects[objIdx]))->
					FilterRfrLight(sublight, 
						newRay.GetStartPoint().DistanceTo(newRayEndPoint)
					)
				);
			} else { // out of the object, no need to filter
				light.Add(RenderRay_Traverse(
					newRay, objects, timeLevel + 1));
			}
		}
    }
    return light;
}

CLight CRender::RenderRay_Diffuse(const CRay &baseray, const CObArray &objects, int timeLevel)
{
    CLight light; // light result
	if (timeLevel + 5 > MaxTimeLevel)
	{
		return light;
	}
    int i; // loop variable
    int j; // loop variable
    CRay dfsRay; // diffuse reflection ray
    double phi; // phi angle
    double theta; // theta angle
    C3DDirection tmpDir; // temporary direction
    C3DMatrix brrotPhi; // rotation matrix of the phi angle of the base ray
    C3DMatrix brrotTheta; // rotation matrix of the theta angle of the base ray
	int nObjects = objects.GetSize();

    brrotPhi = C3DMatrix::RotateMatrix(baseray.GetDirection().GetPhi(), 1);
    brrotTheta = C3DMatrix::RotateMatrix(baseray.GetDirection().GetTheta(), 2);
    dfsRay.Set(baseray); // set the default diffuse ray (especially the start point)
    // use i * 6 points per circle. 9 circles in all. 271 dots in all.
    light.Add((1.0 / 271.0) * RenderRay_Traverse(dfsRay, objects, timeLevel + 5));
    for (i = 1; i <= 9; i++) {
        phi = asin((double)i / 9.5);
        for (j = 0; j < i * 6; j++) {
            theta = CShape::PI * (double)j / (double)(i * 3); // actually 2 * PI * j / i * 6
            tmpDir.SetThetaPhi(theta, phi);
            tmpDir *= brrotPhi;
            tmpDir *= brrotTheta;
            dfsRay.SetDirection(tmpDir);
            light.Add((1.0 / 271.0) * RenderRay_Traverse(dfsRay, objects, timeLevel + 5));
        }
    }
    return light;
}
