// Ray.h: interface for the CRay class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RAY_H__F5DBF891_31A1_11D7_B6FD_000000000000__INCLUDED_)
#define AFX_RAY_H__F5DBF891_31A1_11D7_B6FD_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "3DVector.h"   // dependency
#include "3DDirection.h"    // dependency
#include "Light.h"	// dependency

class CRay  
{
protected:
    C3DVector startPoint;   // start point of the ray
    C3DDirection direction; // direction of the ray
	CLight light;   // light of the ray
public:
    CRay(const CRay& otherray);
	CRay();
	virtual ~CRay();
    C3DDirection GetDirection(void) const;
    CLight GetLight(void)const;
    C3DVector GetStartPoint(void) const;
    void Set(const CRay &otherray);
    void SetDirection(const C3DDirection &newdir);
    void SetLight(double dblRed, double dblGreen, double dblBlue);
    void SetStartPoint(const C3DVector &stPnt);
	void SetToDefault();
};

#endif // !defined(AFX_RAY_H__F5DBF891_31A1_11D7_B6FD_000000000000__INCLUDED_)
