// Ray.cpp: implementation of the CRay class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "Ray.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRay::CRay(const CRay &otherray)
{
    startPoint.Set(otherray.startPoint);
    direction.Set(otherray.direction);
    light.Set(otherray.light);
}

CRay::CRay() // set the startPoint (0.0, 0.0, 0.0), direction (0.0, 0.0, 1.0) and 
	// light (0.0, 0.0, 0.0)
{
}

CRay::~CRay()
{
}

C3DDirection CRay::GetDirection(void) const
{
    return direction;
}

CLight CRay::GetLight(void) const
{
    return light;
}

C3DVector CRay::GetStartPoint(void) const
{
    return startPoint;
}

void CRay::Set(const CRay &otherray)
{
    startPoint.Set(otherray.startPoint);
    direction.Set(otherray.direction);
    light.Set(otherray.light);
}

void CRay::SetDirection(const C3DDirection &newdir)
{
    direction.Set(newdir);
}

void CRay::SetLight(double dblRed, double dblGreen, double dblBlue)
{
    light.Set(dblRed, dblGreen, dblBlue);
}

void CRay::SetStartPoint(const C3DVector &stPnt)
{
    startPoint.Set(stPnt);
}

void CRay::SetToDefault()
{
	startPoint.Clear();
	direction.Set(0.0, 0.0, 1.0);
	light.SetToDefault();
}
