// Plane.h: interface for the CPlane class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PLANE_H__0B7450E1_333E_11D7_B701_000000000000__INCLUDED_)
#define AFX_PLANE_H__0B7450E1_333E_11D7_B701_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "3DVector.h"   // dependency

class CPlane  
{
protected:
    struct pointlistnode_t
    {
        pointlistnode_t *next;
        C3DVector point;
    }*firstPoint;
    pointlistnode_t *currentPoint;
public:
    void AddPoint(const C3DVector &vctPoint);
    void AddPoint(double dblX, double dblY, double dblZ);
    void Clear(void);
	CPlane();
    CPlane(const CPlane &plnSource);
	virtual ~CPlane();
    C3DVector GetCurrentPoint(void) const;
    void GoToNextPoint(void);
    bool IsCPAvailable(void) const;
    CPlane &operator=(const CPlane& plnSource);
    void Rewind(void);
};

#endif // !defined(AFX_PLANE_H__0B7450E1_333E_11D7_B701_000000000000__INCLUDED_)
