// Plane.cpp: implementation of the CPlane class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "Plane.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void CPlane::AddPoint(const C3DVector &vctPoint)
{
    pointlistnode_t *pPoint;    // for storing new node

    // NOTE: The new point is added to be the new first node.
    pPoint = new pointlistnode_t;
    pPoint->point = vctPoint;
    if(firstPoint == NULL) {
        pPoint->next = NULL;
        firstPoint = pPoint;
    } else {
        pPoint->next = firstPoint;
        firstPoint = pPoint;
    }
}

void CPlane::AddPoint(double dblX, double dblY, double dblZ)
{
    pointlistnode_t *pPoint;    // for storing new node

    // NOTE: The new point is added to be the new first node.
    pPoint = new pointlistnode_t;
    pPoint->point.Set(dblX, dblY, dblZ);
    if(firstPoint == NULL) {
        pPoint->next = NULL;
        firstPoint = pPoint;
    } else {
        pPoint->next = firstPoint;
        firstPoint = pPoint;
    }
}

void CPlane::Clear(void)
{
    pointlistnode_t *pLeadingPoint;     // leading point list node
    pointlistnode_t *pFollowingPoint;   // following point list node

    // free resources
    if(firstPoint != NULL)
    {
        pLeadingPoint = firstPoint->next;   // may be NULL; no access violation
        pFollowingPoint = firstPoint;       // mustn't be NULL
        while(pLeadingPoint != NULL)
        {
            delete pFollowingPoint;         // deleting is safe
            pFollowingPoint = pLeadingPoint;    // mustn't be NULL
            pLeadingPoint = pLeadingPoint->next;    // may be NULL
        }
        delete pFollowingPoint; // no duplicating deletion
        firstPoint = NULL;      // needed for Clear function
        currentPoint = NULL;    // needed for Clear function
    }
}

CPlane::CPlane()
{
    firstPoint = NULL;
    currentPoint = NULL;
}

CPlane::CPlane(const CPlane &plnSource)
{
    pointlistnode_t *pSourceNode;       // source point list node
    pointlistnode_t *pDestinationNode;  // destination point list node
    pointlistnode_t *pPreviousNode;     // previous node to the destination node

    // copy all the nodes first
    pSourceNode = plnSource.firstPoint;
    if(pSourceNode != NULL)
    {
        firstPoint = new pointlistnode_t;
        firstPoint->point = pSourceNode->point;
        firstPoint->next = NULL;    // preset to NULL
        pPreviousNode = firstPoint;
        pSourceNode = pSourceNode->next;
        while(pSourceNode != NULL)
        {
            pDestinationNode = new pointlistnode_t;
            pDestinationNode->point = pSourceNode->point;
            pDestinationNode->next = NULL; // preset to NULL
            pPreviousNode->next = pDestinationNode;
            pPreviousNode = pPreviousNode->next;
            pSourceNode = pSourceNode->next;
        }
    }
    else
    {
        firstPoint = NULL;
    }
    currentPoint = NULL;
}

CPlane::~CPlane()
{
    pointlistnode_t *pLeadingPoint;     // leading point list node
    pointlistnode_t *pFollowingPoint;   // following point list node

    // free resources
    if(firstPoint != NULL)
    {
        pLeadingPoint = firstPoint->next;   // may be NULL; no access violation
        pFollowingPoint = firstPoint;       // mustn't be NULL
        while(pLeadingPoint != NULL)
        {
            delete pFollowingPoint;         // deleting is safe
            pFollowingPoint = pLeadingPoint;    // mustn't be NULL
            pLeadingPoint = pLeadingPoint->next;    // may be NULL
        }
        delete pFollowingPoint; // no duplicating deletion
    }
}

C3DVector CPlane::GetCurrentPoint(void) const
{
    if(currentPoint == NULL)
    {
        return C3DVector();
    }
    else
    {
        return currentPoint->point;
    }
}

void CPlane::GoToNextPoint(void)
{
    // Because points were inserted reversely, the next point is a point inserted right before the current point.
    if(currentPoint == NULL)
        return;
    currentPoint = currentPoint->next;
}

bool CPlane::IsCPAvailable(void) const
{
    return (currentPoint == NULL)? false: true;
}

CPlane &CPlane::operator=(const CPlane &plnSource)
{
    pointlistnode_t *pSourceNode;       // source point list node
    pointlistnode_t *pDestinationNode;  // destination point list node
    pointlistnode_t *pPreviousNode;     // previous node to the destination node

    if(this == &plnSource)
    {   // duplicating
        return *this;
    }
    Clear();
    pSourceNode = plnSource.firstPoint;
    if(pSourceNode != NULL)
    {
        firstPoint = new pointlistnode_t;
        firstPoint->point = pSourceNode->point;
        firstPoint->next = NULL;    // preset to NULL
        pPreviousNode = firstPoint;
        pSourceNode = pSourceNode->next;
        while(pSourceNode != NULL)
        {
            pDestinationNode = new pointlistnode_t;
            pDestinationNode->point = pSourceNode->point;
            pDestinationNode->next = NULL; // preset to NULL
            pPreviousNode->next = pDestinationNode;
            pPreviousNode = pPreviousNode->next;
            pSourceNode = pSourceNode->next;
        }
    }
    return *this;
}

void CPlane::Rewind(void)
{
    // Because points were inserted reversely, this first node contains the last inserted point.
    currentPoint = firstPoint;
}
