// PhysicalObject.h: interface for the CPhysicalObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PHYSICALOBJECT_H__96DD2CC2_3A1B_464A_AFE2_ED01810150F3__INCLUDED_)
#define AFX_PHYSICALOBJECT_H__96DD2CC2_3A1B_464A_AFE2_ED01810150F3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Shape.h"  // dependency
#include "3DVector.h"   // dependency
#include "Ray.h"    // dependency

class CPhysicalObject: public CObject  
{
protected:
    double mrredrate;
    double mrgrnrate;
    double mrblurate;
    double drredrate;
    double drgrnrate;
    double drblurate;
    double ior; // index of refraction
    double rfredrate; // transparence for 10cm thick board
    double rfgrnrate;
    double rfblurate;
    struct tagBuffer{
        double max_mrrate;
        double max_drrate;
        double rfbase; // rfbase = 1 - max_mrrate - max_drrate
        double rfredk; // exp(rfredk) = rfredrate; rfredk = log(rfredrate)
        double rfgrnk;
        double rfbluk;
    }buffer;
    bool lightsrcflag; // light source flag
    CLight light; // light of the light source, if it is
public:
    virtual bool CalculateIntersection(const CRay &ray, C3DVector &vctIntersection, int &shpIdx) const;
    virtual void Clear(void);
	CPhysicalObject();
	virtual ~CPhysicalObject();
    virtual CLight FilterDRLight(const CLight &light) const;
    virtual CLight FilterMRLight(const CLight &light) const;
    virtual CLight FilterRfrLight(const CLight &light, double dist) const;
    virtual bool GetDRRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const;
    CLight GetLight(void) const;
    virtual bool GetMRRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const;
    void GetParameters(int &o_mrRed, int &o_mrGreen, int &o_mrBlue, double &o_mrRate, int &o_drRed, int &o_drGreen, int &o_drBlue, double &o_drRate, double &o_ior, int &o_rfrRed, int &o_rfrGreen, int &o_rfrBlue, int &o_nrmlFlag, double &o_lsRed, double &o_lsGreen, double &o_lsBlue) const;
    virtual int GetRfrRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const;
    bool IsLightSource(void) const;
    void SetParameters(int o_mrRed, int o_mrGreen, int o_mrBlue, double o_mrRate, int o_drRed, int o_drGreen, int o_drBlue, double o_drRate, double o_ior, int o_rfrRed, int o_rfrGreen, int o_rfrBlue, int o_nrmlFlag, double o_lsRed, double o_lsGreen, double o_lsBlue);
    void UpdateBuffer(void);
};

#endif // !defined(AFX_PHYSICALOBJECT_H__96DD2CC2_3A1B_464A_AFE2_ED01810150F3__INCLUDED_)
