// PhysicalObject.cpp: implementation of the CPhysicalObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "PhysicalObject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

bool CPhysicalObject::CalculateIntersection(const CRay &ray, C3DVector &vctIntersection, int &shpIdx) const
{
    ASSERT(false); // do not let it run
    return false;
}

CPhysicalObject::CPhysicalObject(): light()
{
    lightsrcflag = false;
    mrredrate = 0.3;
    mrgrnrate = 0.3;
    mrblurate = 0.3;
    drredrate = 0.0;
    drgrnrate = 0.0;
    drblurate = 0.0;
    ior = 1.5;
    rfredrate = 1.0;
    rfgrnrate = 0.7;
    rfblurate = 0.7;
    UpdateBuffer();
}

CPhysicalObject::~CPhysicalObject()
{
}

void CPhysicalObject::Clear(void)
{
	ASSERT(false);
}

CLight CPhysicalObject::FilterDRLight(const CLight &light) const
{
    ASSERT(false); // do not let it run
    return CLight(0.0, 0.0, 0.0);
}

CLight CPhysicalObject::FilterMRLight(const CLight &light) const
{
    ASSERT(false); // do not let it run
    return CLight(0.0, 0.0, 0.0);
}

CLight CPhysicalObject::FilterRfrLight(const CLight &light, double dist) const
{
    ASSERT(false); // do not let it run
    return CLight(0.0, 0.0, 0.0);
}

bool CPhysicalObject::GetDRRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const
{
    ASSERT(false);
    return false;
}

CLight CPhysicalObject::GetLight(void) const
{
    if (lightsrcflag) {
        return light;
    } else {
		ASSERT(false); // should not call this function if the object is not a light source
        return CLight(0.0, 0.0, 0.0);
    }
}

bool CPhysicalObject::GetMRRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const
{
    ASSERT(false);
    return false;
}

void CPhysicalObject::GetParameters(
    int &o_mrRed, int &o_mrGreen, int &o_mrBlue, double &o_mrRate, 
    int &o_drRed, int &o_drGreen, int &o_drBlue, double &o_drRate, 
	double &o_ior, 
    int &o_rfrRed, int &o_rfrGreen, int &o_rfrBlue, 
    int &o_nrmlFlag, 
    double &o_lsRed, double &o_lsGreen, double &o_lsBlue
) const
{
    // get the largest from the rates as o_mrRate
    if(!lightsrcflag){
        o_mrRed = (int)(255.0 * mrredrate / buffer.max_mrrate);
        o_mrGreen = (int)(255.0 * mrgrnrate / buffer.max_mrrate);
        o_mrBlue = (int)(255.0 * mrblurate / buffer.max_mrrate);
        o_mrRate = buffer.max_mrrate;
        o_drRed = (int)(255.0 * drredrate / buffer.max_drrate);
        o_drGreen = (int)(255.0 * drgrnrate / buffer.max_drrate);
        o_drBlue = (int)(255.0 * drblurate / buffer.max_drrate);
        o_drRate = buffer.max_drrate;
		o_ior = ior;
        o_rfrRed = (int)(255.0 * rfredrate);
        o_rfrGreen = (int)(255.0 * rfgrnrate);
        o_rfrBlue = (int)(255.0 * rfblurate);
        o_nrmlFlag = 0;
    }else{
        o_lsRed = light.GetRed();
        o_lsGreen = light.GetGreen();
        o_lsBlue = light.GetBlue();
        o_nrmlFlag = 1;
    }
}

int CPhysicalObject::GetRfrRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const
{
    ASSERT(false);
    return false;
}

bool CPhysicalObject::IsLightSource(void) const
{
    return lightsrcflag;
}

void CPhysicalObject::SetParameters(
    int i_mrRed, int i_mrGreen, int i_mrBlue, double i_mrRate, 
    int i_drRed, int i_drGreen, int i_drBlue, double i_drRate, 
	double i_ior, 
    int i_rfrRed, int i_rfrGreen, int i_rfrBlue, 
    int i_nrmlFlag, 
    double i_lsRed, double i_lsGreen, double i_lsBlue
)
{
    if(i_nrmlFlag == 0){
        mrredrate = i_mrRate * (double)i_mrRed / 255.0;
        mrgrnrate = i_mrRate * (double)i_mrGreen / 255.0;
        mrblurate = i_mrRate * (double)i_mrBlue / 255.0;
        drredrate = i_drRate * (double)i_drRed / 255.0;
        drgrnrate = i_drRate * (double)i_drGreen / 255.0;
        drblurate = i_drRate * (double)i_drBlue / 255.0;
		ior = i_ior;
        rfredrate = (double)i_rfrRed / 255.0;
        rfgrnrate = (double)i_rfrGreen / 255.0;
        rfblurate = (double)i_rfrBlue / 255.0;
        lightsrcflag = false;
    }else if(i_nrmlFlag == 1){
        light.Set(i_lsRed, i_lsGreen, i_lsBlue);
        lightsrcflag = true;
    }
	ASSERT(0.0 <= buffer.max_drrate && buffer.max_drrate <= 1.0 && 
		0.0 <= buffer.max_mrrate && buffer.max_mrrate <= 1.0);
	ASSERT(buffer.max_drrate + buffer.max_mrrate <= 1 + C3DVector::EPSILON);
    UpdateBuffer();
}

void CPhysicalObject::UpdateBuffer(void)
{
    if(lightsrcflag) return;
    buffer.max_mrrate = mrredrate;
    if (buffer.max_mrrate < mrgrnrate)
	{
		buffer.max_mrrate = mrgrnrate;
	}
    if (buffer.max_mrrate < mrblurate)
	{
		buffer.max_mrrate = mrblurate;
	}
    buffer.max_drrate = drredrate;
    if (buffer.max_drrate < drgrnrate)
	{
		buffer.max_drrate = drgrnrate;
	}
    if (buffer.max_drrate < drblurate)
	{
		buffer.max_drrate = drblurate;
	}
    buffer.rfbase = 1.0 - buffer.max_mrrate - buffer.max_drrate;
	if (rfredrate > C3DVector::EPSILON)
	{
		buffer.rfredk = log(rfredrate);
	}
	if (rfgrnrate > C3DVector::EPSILON)
	{
		buffer.rfgrnk = log(rfgrnrate);
	}
	if (rfblurate > C3DVector::EPSILON)
	{
		buffer.rfbluk = log(rfblurate);
	}
}
