// ObjectSelectionBox.cpp : implementation file
//

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "ObjectSelectionBox.h"
#include "ComplexObject.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectSelectionBox dialog


CObjectSelectionBox::CObjectSelectionBox(CWnd* pParent /*=NULL*/)
	: CDialog(CObjectSelectionBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjectSelectionBox)
	m_selectedString = _T("");
	//}}AFX_DATA_INIT
}


void CObjectSelectionBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectSelectionBox)
	DDX_Control(pDX, IDC_LIST_OBJECTS, m_objlist);
	DDX_LBString(pDX, IDC_LIST_OBJECTS, m_selectedString);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectSelectionBox, CDialog)
	//{{AFX_MSG_MAP(CObjectSelectionBox)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectSelectionBox user defined functions
void CObjectSelectionBox::AddListItems(const CObArray &cplxObjs, int actObj)
{
    CComplexObject *cplxObj_ptr; // pointer to current complex object
    int i;
    CString str; // string buffer
	CString type; // object type buffer
    CString shape; // shape type buffer

    for (i = 0; i < cplxObjs.GetSize(); i++)
	{
        cplxObj_ptr = (CComplexObject *)(cplxObjs.GetAt(i));
		if (cplxObj_ptr->IsLightSource())
		{
			type = _T("Դ");
		}
		else
		{
			type = _T("ͨ壺");
		}
        if (cplxObj_ptr->IsSimpleObject())
		{
            if (cplxObj_ptr->GetShapeType() == "Cuboid")
			{
                shape = _T("");
            }
			else if(cplxObj_ptr->GetShapeType() == "Sphere")
			{
                shape = _T("");
            }
            str.Format(_T("%d. %s塣%s"), i, (LPCTSTR)type, (LPCTSTR)shape);
        }
		else
		{
            str.Format(_T("%d. %s塣%d塣"), i, (LPCTSTR)type, cplxObj_ptr->GetShapeCount());
        }
        m_objlist.AddString(str);
    }
    if (cplxObjs.GetSize() > 0)
	{
        m_objlist.SetCurSel(actObj);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CObjectSelectionBox message handlers

BOOL CObjectSelectionBox::OnInitDialog() 
{
	CDialog::OnInitDialog();

    AddListItems(*m_obArray_ptr, m_actObj);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CObjectSelectionBox::OnOK() 
{
    if(UpdateData(TRUE)){
        _stscanf(m_selectedString.GetBuffer(0), "%d.", &m_actObj);
    }

    CDialog::OnOK();
}
