// ObjectParaBox.cpp : implementation file
//

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "ObjectParaBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CObjectParaBox dialog


CObjectParaBox::CObjectParaBox(CWnd* pParent /*=NULL*/)
	: CDialog(CObjectParaBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjectParaBox)
	m_drBlue = 0;
	m_drGreen = 0;
	m_drRate = 0.0;
	m_drRed = 0;
	m_lsBlue = 0.0;
	m_lsGreen = 0.0;
	m_lsRed = 0.0;
	m_mrBlue = 0;
	m_mrGreen = 0;
	m_mrRate = 0.0;
	m_mrRed = 0;
	m_nrmlObj_flag = -1;
	m_rfrBlue = 0;
	m_rfrGreen = 0;
	m_rfrRed = 0;
	m_ior = 0.0;
	//}}AFX_DATA_INIT
}


void CObjectParaBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjectParaBox)
	DDX_Text(pDX, IDC_DRBLUE, m_drBlue);
	DDV_MinMaxInt(pDX, m_drBlue, 0, 255);
	DDX_Text(pDX, IDC_DRGREEN, m_drGreen);
	DDV_MinMaxInt(pDX, m_drGreen, 0, 255);
	DDX_Text(pDX, IDC_DRRATE, m_drRate);
	DDV_MinMaxDouble(pDX, m_drRate, 0., 1.);
	DDX_Text(pDX, IDC_DRRED, m_drRed);
	DDV_MinMaxInt(pDX, m_drRed, 0, 255);
	DDX_Text(pDX, IDC_LSBLUE, m_lsBlue);
	DDV_MinMaxDouble(pDX, m_lsBlue, 0., 100.);
	DDX_Text(pDX, IDC_LSGREEN, m_lsGreen);
	DDV_MinMaxDouble(pDX, m_lsGreen, 0., 100.);
	DDX_Text(pDX, IDC_LSRED, m_lsRed);
	DDV_MinMaxDouble(pDX, m_lsRed, 0., 100.);
	DDX_Text(pDX, IDC_MRBLUE, m_mrBlue);
	DDV_MinMaxInt(pDX, m_mrBlue, 0, 255);
	DDX_Text(pDX, IDC_MRGREEN, m_mrGreen);
	DDV_MinMaxInt(pDX, m_mrGreen, 0, 255);
	DDX_Text(pDX, IDC_MRRATE, m_mrRate);
	DDV_MinMaxDouble(pDX, m_mrRate, 0., 1.);
	DDX_Text(pDX, IDC_MRRED, m_mrRed);
	DDV_MinMaxInt(pDX, m_mrRed, 0, 255);
	DDX_Radio(pDX, IDC_RADIO_NRMLOBJ, m_nrmlObj_flag);
	DDX_Text(pDX, IDC_RFRBLUE, m_rfrBlue);
	DDV_MinMaxInt(pDX, m_rfrBlue, 0, 255);
	DDX_Text(pDX, IDC_RFRGREEN, m_rfrGreen);
	DDV_MinMaxInt(pDX, m_rfrGreen, 0, 255);
	DDX_Text(pDX, IDC_RFRRED, m_rfrRed);
	DDV_MinMaxInt(pDX, m_rfrRed, 0, 255);
	DDX_Text(pDX, IDC_IOR, m_ior);
	DDV_MinMaxDouble(pDX, m_ior, 0., 5.);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjectParaBox, CDialog)
	//{{AFX_MSG_MAP(CObjectParaBox)
	ON_BN_CLICKED(IDC_RADIO_LS, OnRadioLs)
	ON_BN_CLICKED(IDC_RADIO_NRMLOBJ, OnRadioNrmlObj)
	ON_BN_CLICKED(IDC_BTN_DRCOLOR, OnBtnDrColor)
	ON_BN_CLICKED(IDC_BTN_MRCOLOR, OnBtnMrColor)
	ON_BN_CLICKED(IDC_BTN_RFRCOLOR, OnBtnRfrColor)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectParaBox user defined functions

void CObjectParaBox::DisableLSControls(void)
{
    CWnd *ctrlPtr; // pointer to a control
    int ctrls[] = {
        IDC_STATIC_LS_L,
        IDC_STATIC_LS_LR,
        IDC_LSRED,
        IDC_STATIC_LS_LG,
        IDC_LSGREEN,
        IDC_STATIC_LS_LB,
        IDC_LSBLUE
    }; // light source controls
    int i; // loop variable
    for(i = 0; i < sizeof(ctrls) / sizeof(int); i++){
        ctrlPtr = GetDlgItem(ctrls[i]);
        ctrlPtr->EnableWindow(FALSE);
    }
}

void CObjectParaBox::DisableNormalControls(void)
{
    CWnd *ctrlPtr; // pointer to a control
    int ctrls[] = {
        IDC_STATIC_NRML_M,
        IDC_STATIC_NRML_MR,
        IDC_MRRED,
        IDC_STATIC_NRML_MG,
        IDC_MRGREEN,
        IDC_STATIC_NRML_MB,
        IDC_MRBLUE,
        IDC_STATIC_NRML_ME,
        IDC_MRRATE,
        IDC_BTN_MRCOLOR,
        IDC_STATIC_NRML_D,
        IDC_STATIC_NRML_DR,
        IDC_DRRED,
        IDC_STATIC_NRML_DG,
        IDC_DRGREEN,
        IDC_STATIC_NRML_DB,
        IDC_DRBLUE,
        IDC_STATIC_NRML_DE,
        IDC_DRRATE,
        IDC_BTN_DRCOLOR,
        IDC_STATIC_NRML_F,
		IDC_STATIC_NRML_IOR,
		IDC_IOR,
        IDC_STATIC_NRML_FR,
        IDC_RFRRED,
        IDC_STATIC_NRML_FG,
        IDC_RFRGREEN,
        IDC_STATIC_NRML_FB,
        IDC_RFRBLUE,
        IDC_BTN_RFRCOLOR
    }; // light source controls
    int i; // loop variable
    for(i = 0; i < sizeof(ctrls) / sizeof(int); i++){
        ctrlPtr = GetDlgItem(ctrls[i]);
        ctrlPtr->EnableWindow(FALSE);
    }
}

void CObjectParaBox::EnableLSControls(void)
{
    CWnd *ctrlPtr; // pointer to a control
    int ctrls[] = {
        IDC_STATIC_LS_L,
        IDC_STATIC_LS_LR,
        IDC_LSRED,
        IDC_STATIC_LS_LG,
        IDC_LSGREEN,
        IDC_STATIC_LS_LB,
        IDC_LSBLUE
    }; // light source controls
    int i; // loop variable
    for(i = 0; i < sizeof(ctrls) / sizeof(int); i++){
        ctrlPtr = GetDlgItem(ctrls[i]);
        ctrlPtr->EnableWindow(TRUE);
    }
}

void CObjectParaBox::EnableNormalControls(void)
{
    CWnd *ctrlPtr; // pointer to a control
    int ctrls[] = {
        IDC_STATIC_NRML_M,
        IDC_STATIC_NRML_MR,
        IDC_MRRED,
        IDC_STATIC_NRML_MG,
        IDC_MRGREEN,
        IDC_STATIC_NRML_MB,
        IDC_MRBLUE,
        IDC_STATIC_NRML_ME,
        IDC_MRRATE,
        IDC_BTN_MRCOLOR,
        IDC_STATIC_NRML_D,
        IDC_STATIC_NRML_DR,
        IDC_DRRED,
        IDC_STATIC_NRML_DG,
        IDC_DRGREEN,
        IDC_STATIC_NRML_DB,
        IDC_DRBLUE,
        IDC_STATIC_NRML_DE,
        IDC_DRRATE,
        IDC_BTN_DRCOLOR,
        IDC_STATIC_NRML_F,
		IDC_STATIC_NRML_IOR,
		IDC_IOR,
        IDC_STATIC_NRML_FR,
        IDC_RFRRED,
        IDC_STATIC_NRML_FG,
        IDC_RFRGREEN,
        IDC_STATIC_NRML_FB,
        IDC_RFRBLUE,
        IDC_BTN_RFRCOLOR
    }; // light source controls
    int i; // loop variable
    for(i = 0; i < sizeof(ctrls) / sizeof(int); i++){
        ctrlPtr = GetDlgItem(ctrls[i]);
        ctrlPtr->EnableWindow(TRUE);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CObjectParaBox message handlers

void CObjectParaBox::OnRadioLs() 
{
    EnableLSControls();
    DisableNormalControls();
}

void CObjectParaBox::OnRadioNrmlObj() 
{
    EnableNormalControls();
    DisableLSControls();
}

BOOL CObjectParaBox::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    if(m_nrmlObj_flag == 0){ // normal
        EnableNormalControls();
        DisableLSControls();
    }else{ // light source
        EnableLSControls();
        DisableNormalControls();
    }
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CObjectParaBox::OnBtnDrColor() 
{
    CColorDialog dlg;
	CString tmpStr;
    if(dlg.DoModal() == IDOK){
		tmpStr.Format(_T("%d"), GetRValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_DRRED)->SetWindowText(tmpStr);
		tmpStr.Format(_T("%d"), GetGValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_DRGREEN)->SetWindowText(tmpStr);
		tmpStr.Format(_T("%d"), GetBValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_DRBLUE)->SetWindowText(tmpStr);
    }
}

void CObjectParaBox::OnBtnMrColor() 
{
    CColorDialog dlg;
	CString tmpStr;
    if(dlg.DoModal() == IDOK){
		tmpStr.Format(_T("%d"), GetRValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_MRRED)->SetWindowText(tmpStr);
		tmpStr.Format(_T("%d"), GetGValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_MRGREEN)->SetWindowText(tmpStr);
		tmpStr.Format(_T("%d"), GetBValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_MRBLUE)->SetWindowText(tmpStr);
    }
}

void CObjectParaBox::OnBtnRfrColor() 
{
    CColorDialog dlg;
	CString tmpStr;
    if(dlg.DoModal() == IDOK){
		tmpStr.Format(_T("%d"), GetRValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_RFRRED)->SetWindowText(tmpStr);
		tmpStr.Format(_T("%d"), GetGValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_RFRGREEN)->SetWindowText(tmpStr);
		tmpStr.Format(_T("%d"), GetBValue(dlg.m_cc.rgbResult));
		GetDlgItem(IDC_RFRBLUE)->SetWindowText(tmpStr);
    }
}
