// Light.h: interface for the CLight class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LIGHT_H__486FCD9A_C187_415A_A908_FAC075050A9C__INCLUDED_)
#define AFX_LIGHT_H__486FCD9A_C187_415A_A908_FAC075050A9C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <math.h>

// this class uses the three-color system to represent light, which is not very accurate.
class CLight  
{
protected:
	double red;     // brightness of the red part of the light
	double green;   // brightness of the green part of the light
	double blue;    // brightness of the blue part of the light
public:
    void Add(const CLight &light);
    CLight(const CLight &light);
	CLight(double dblRed, double dblGreen, double dblBlue);
	CLight();
	virtual ~CLight();
	COLORREF ConvertToColorRef(double dblScale) const;
	double GetRed(void) const;
	double GetGreen(void) const;
	double GetBlue(void) const;
    CLight &MultiplyRate(double dblRedRate, double dblGreenRate, double dblBlueRate);
    friend CLight operator*(double dblNumber, const CLight &light);
	void Set(double dblRed, double dblGreen, double dblBlue);
    void Set(const CLight &otherlight);
	void SetToDefault(void);
};

#endif // !defined(AFX_LIGHT_H__486FCD9A_C187_415A_A908_FAC075050A9C__INCLUDED_)
