// Light.cpp: implementation of the CLight class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "Light.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void CLight::Add(const CLight &light)
{
    red += light.red;
    green += light.green;
    blue += light.blue;
}

CLight::CLight(const CLight &light)
{
	Set(light); // for simplicity and consistency
}

CLight::CLight(double dblRed, double dblGreen, double dblBlue)
{
	Set(dblRed, dblGreen, dblBlue);
}

CLight::CLight()
{
	SetToDefault();
}

CLight::~CLight()
{
}

COLORREF CLight::ConvertToColorRef(double dblScale) const
{
	int tmpRed;      // temporary red value
	int tmpGrn;    // temporary green value
	int tmpBlu;     // temporary blue value
    double dblRatio;    // convertion ratio

    ASSERT(dblScale >= 0.0 && 
		red >= 0.0 && 
		green >= 0.0 && 
		blue >= 0.0);
    dblRatio = dblScale * 255.0;
	tmpRed = (int)(dblRatio * red + 0.5);   // rounded to integer; 
		// because negative values are impossible, there is no need 
		// to use the floor function
	tmpGrn = (int)(dblRatio * green + 0.5);
	tmpBlu = (int)(dblRatio * blue + 0.5);
	if (tmpRed > 255) {
        tmpRed = 255;
    }
    if (tmpGrn > 255) {
        tmpGrn = 255;
    }
    if (tmpBlu > 255) {
        tmpBlu = 255;
    }
    return RGB(tmpRed, tmpGrn, tmpBlu);
}

double CLight::GetRed(void) const
{
	return red;
}

double CLight::GetGreen(void) const
{
	return green;
}

double CLight::GetBlue(void) const
{
	return blue;
}

CLight operator*(double dblNumber, const CLight &light)
{
    return CLight(light.red * dblNumber, light.green * dblNumber, light.blue * dblNumber);
}

CLight &CLight::MultiplyRate(double dblRedRate, double dblGreenRate, double dblBlueRate)
{
    ASSERT(dblRedRate >= 0.0 && dblGreenRate >= 0.0 && dblBlueRate >= 0.0);
    red *= dblRedRate;
    green *= dblGreenRate;
    blue *= dblBlueRate;
    return *this;
}

void CLight::Set(double dblRed, double dblGreen, double dblBlue)
{
	ASSERT(dblRed >= 0.0 && dblGreen >= 0.0 && dblBlue >= 0.0);
	red = dblRed;
	green = dblGreen;
	blue = dblBlue;
}

void CLight::Set(const CLight &otherlight)
{
    red = otherlight.red;
    green = otherlight.green;
    blue = otherlight.blue;
}

void CLight::SetToDefault(void)
{
	red = 0.0;
	green = 0.0;
	blue = 0.0;
}