// GraphicsConclusionView.cpp : implementation of the CGraphicsConclusionView class
//

#include "stdafx.h"
#include "GraphicsConclusion.h"

#include "GraphicsConclusionDoc.h"
#include "GraphicsConclusionView.h"

#include "CuboidParaBox.h"
#include "Cuboid.h"
#include "SphereParaBox.h"
#include "Sphere.h"
#include "ObjectParaBox.h"
#include "PhysicalObject.h"
#include "ObjectSelectionBox.h"
#include "RenderBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionView

IMPLEMENT_DYNCREATE(CGraphicsConclusionView, CView)

BEGIN_MESSAGE_MAP(CGraphicsConclusionView, CView)
	//{{AFX_MSG_MAP(CGraphicsConclusionView)
	ON_COMMAND(ID_OBJ_DRAW_CBD, OnObjDrawCbd)
	ON_COMMAND(ID_OBJ_DRAW_SPHR, OnObjDrawSphr)
	ON_COMMAND(ID_OBJ_DELETE, OnObjDelete)
	ON_COMMAND(ID_OBJ_MDF_SHPPARA, OnObjMdfShpPara)
	ON_COMMAND(ID_OBJ_MDF_OBJPARA, OnObjMdfObjPara)
	ON_COMMAND(ID_OBJ_SELOBJ, OnObjSelObj)
	ON_COMMAND(ID_OBJ_BOOL_AND, OnObjBoolAnd)
	ON_COMMAND(ID_OBJ_BOOL_OR, OnObjBoolOr)
	ON_COMMAND(ID_OBJ_BOOL_DIFF, OnObjBoolDiff)
	ON_COMMAND(ID_OBJ_BOOL_DISASM, OnObjBoolDisasm)
	ON_COMMAND(ID_DRAW_RENDER, OnDrawRender)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionView construction/destruction

CGraphicsConclusionView::CGraphicsConclusionView()
{
	// TODO: add construction code here

}

CGraphicsConclusionView::~CGraphicsConclusionView()
{
}

BOOL CGraphicsConclusionView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionView drawing

void CGraphicsConclusionView::OnDraw(CDC* pDC)
{
	CGraphicsConclusionDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

    CRect clntRect; // the client rectangle
    CSize paneSize; // the size of each pane

    // Calculate and draw the bound of the panes
    GetClientRect(&clntRect);
    paneSize = clntRect.Size();
    paneSize.cx /= 2;
    paneSize.cy /= 2;
    if(paneSize.cx == 0 && paneSize.cy == 0) return;
    pDC->MoveTo(paneSize.cx + 1, 0);
    pDC->LineTo(paneSize.cx + 1, clntRect.Height());
    pDC->MoveTo(0, paneSize.cy + 1);
    pDC->LineTo(clntRect.Width(), paneSize.cy + 1);
    
    //CSphere testsphere; // test sphere
    CPoint paneCtr; // center of each pane

    // draw information inside the panes
    paneCtr.x = paneSize.cx / 2;
    paneCtr.y = paneSize.cy / 2;
    DrawObjects(pDoc, pDC, pDoc->frontSv, paneCtr, paneSize.cx);
    paneCtr.x = paneSize.cx + 1 + paneSize.cx / 2;
    paneCtr.y = paneSize.cy / 2;
    DrawObjects(pDoc, pDC, pDoc->leftSv, paneCtr, paneSize.cx);
    paneCtr.x = paneSize.cx / 2;
    paneCtr.y = paneSize.cy + 1 + paneSize.cy / 2;
    DrawObjects(pDoc, pDC, pDoc->topSv, paneCtr, paneSize.cx);
    paneCtr.x = paneSize.cx + 1 + paneSize.cx / 2;
    paneCtr.y = paneSize.cy + 1 + paneSize.cy / 2;
    DrawObjects(pDoc, pDC, pDoc->userSv, paneCtr, paneSize.cx);
}

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionView diagnostics

#ifdef _DEBUG
void CGraphicsConclusionView::AssertValid() const
{
	CView::AssertValid();
}

void CGraphicsConclusionView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CGraphicsConclusionDoc* CGraphicsConclusionView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGraphicsConclusionDoc)));
	return (CGraphicsConclusionDoc*)m_pDocument;
}
#endif //_DEBUG

int CGraphicsConclusionView::GetObjectSelection(void)
{
    CObjectSelectionBox dlg;
    CGraphicsConclusionDoc *pDoc = GetDocument();
    dlg.m_obArray_ptr = &(pDoc->objset.cplxObjs);
    dlg.m_actObj = pDoc->objset.actObj;
    if(dlg.DoModal() == IDOK){
        return dlg.m_actObj;
    }else{
        return -1;
    }
}

void CGraphicsConclusionView::BoolOperation(char op)
{
    CGraphicsConclusionDoc *pDoc = GetDocument();
    int otherobj; // index of the other object
    if ((otherobj = GetObjectSelection()) != -1) {
        if (otherobj != pDoc->objset.actObj) {
            ((CComplexObject *)(pDoc->objset.cplxObjs[pDoc->objset.actObj]))->
                CombineWith(*((CComplexObject *)(pDoc->objset.cplxObjs[otherobj])), op);
            delete pDoc->objset.cplxObjs.GetAt(otherobj);
            pDoc->objset.cplxObjs.RemoveAt(otherobj);
            if (otherobj < pDoc->objset.actObj) {
                pDoc->objset.actObj--;
            }
            Invalidate();
        } else {
            MessageBox("ܽͬв㡣", "");
        }
    } else {
        MessageBox("ûѡ塣", "");
    }
}

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionView message handlers

void CGraphicsConclusionView::OnObjDrawCbd() 
{
	CGraphicsConclusionDoc *pDoc = GetDocument();
    CComplexObject *cplxObjPtr = new CComplexObject(); // complex object

    cplxObjPtr->AddCuboid();
    pDoc->objset.cplxObjs.Add(cplxObjPtr);
    pDoc->objset.actObj = pDoc->objset.cplxObjs.GetSize() - 1;
    Invalidate();
}

void CGraphicsConclusionView::OnObjDrawSphr() 
{
	CGraphicsConclusionDoc *pDoc = GetDocument();
    CComplexObject *cplxObjPtr = new CComplexObject(); // complex object

    cplxObjPtr->AddSphere();
    pDoc->objset.cplxObjs.Add(cplxObjPtr);
    pDoc->objset.actObj = pDoc->objset.cplxObjs.GetSize() - 1;
    Invalidate();
}

void CGraphicsConclusionView::OnObjDelete() 
{
	CGraphicsConclusionDoc *pDoc = GetDocument();
    if (pDoc->objset.cplxObjs.GetSize() == 0) {
        MessageBox("ûѡ塣", "ɾ");
        return;
    }
	if (MessageBox("ȷҪɾǰ", "ɾȷ", MB_YESNO) == IDNO) {
		return;
	}
	delete pDoc->objset.cplxObjs.GetAt(pDoc->objset.actObj);
    pDoc->objset.cplxObjs.RemoveAt(pDoc->objset.actObj);
    if(pDoc->objset.actObj >= pDoc->objset.cplxObjs.GetSize()){
        pDoc->objset.actObj--;
    }
    Invalidate();
}

void CGraphicsConclusionView::OnObjMdfShpPara() 
{
	CGraphicsConclusionDoc *pDoc = GetDocument();
    CComplexObject *cpobPtr; // pointer to complex object

    if(pDoc->objset.actObj == -1){
        MessageBox("ûѡ塣", "޸Ĳ");
    }else{
        cpobPtr = ((CComplexObject *)(pDoc->objset.cplxObjs.GetAt(pDoc->objset.actObj)));
        if(cpobPtr->IsSimpleObject()){
            if(cpobPtr->GetShapeType() == CString("Cuboid")){
                {
                    CCuboidParaBox dlg;
                    CCuboid *cuboidPtr;
                    cuboidPtr = (CCuboid *)(cpobPtr->GetShapePtr());
                    cuboidPtr->GetParameters(
                        dlg.m_refend_x, dlg.m_refend_y, dlg.m_refend_z, 
                        dlg.m_depth, dlg.m_width, dlg.m_height, 
                        dlg.m_theta, dlg.m_phi, dlg.m_alpha
                    );
                    dlg.m_theta *= 180.0 / CShape::PI;
                    dlg.m_phi *= 180.0 / CShape::PI;
                    dlg.m_alpha *= 180.0 / CShape::PI;
                    if(dlg.DoModal() == IDOK){
                        dlg.m_theta *= CShape::PI / 180.0;
                        dlg.m_phi *= CShape::PI / 180.0;
                        dlg.m_alpha *= CShape::PI / 180.0;
                        cuboidPtr->SetParameters(
                            dlg.m_refend_x, dlg.m_refend_y, dlg.m_refend_z,
                            dlg.m_depth, dlg.m_width, dlg.m_height,
                            dlg.m_theta, dlg.m_phi, dlg.m_alpha
                        );
                        Invalidate();
                    }
                }
            }else if(cpobPtr->GetShapeType() == CString("Sphere")){
                {
                    CSphereParaBox dlg;
                    CSphere *spherePtr;
                    spherePtr = (CSphere *)(cpobPtr->GetShapePtr());
                    spherePtr->GetParameters(dlg.m_center_x, dlg.m_center_y, dlg.m_center_z, dlg.m_radius);
                    if(dlg.DoModal() == IDOK){
                        spherePtr->SetParameters(
                            dlg.m_center_x, dlg.m_center_y, dlg.m_center_z, 
                            dlg.m_radius
                        );
                        Invalidate();
                    }
                }
            }
        }else{
            MessageBox("ɶɵġ", "޸Ĳ");
        }
    }
}

void CGraphicsConclusionView::OnObjMdfObjPara() 
{
    CGraphicsConclusionDoc *pDoc = GetDocument();
    CPhysicalObject *psobPtr; // pointer to current physical object

    if(pDoc->objset.actObj == -1){
        MessageBox("ûѡ塣", "޸Ĳ");
    }else{
        CObjectParaBox dlg;
        psobPtr = (CPhysicalObject *)(pDoc->objset.cplxObjs.GetAt(pDoc->objset.actObj));
        psobPtr->GetParameters(
            dlg.m_mrRed, dlg.m_mrGreen, dlg.m_mrBlue, dlg.m_mrRate, 
            dlg.m_drRed, dlg.m_drGreen, dlg.m_drBlue, dlg.m_drRate, 
			dlg.m_ior, 
            dlg.m_rfrRed, dlg.m_rfrGreen, dlg.m_rfrBlue, 
            dlg.m_nrmlObj_flag, 
            dlg.m_lsRed, dlg.m_lsGreen, dlg.m_lsBlue
        );
        if(dlg.DoModal() == IDOK){
            psobPtr->SetParameters(
                dlg.m_mrRed, dlg.m_mrGreen, dlg.m_mrBlue, dlg.m_mrRate, 
                dlg.m_drRed, dlg.m_drGreen, dlg.m_drBlue, dlg.m_drRate, 
				dlg.m_ior, 
                dlg.m_rfrRed, dlg.m_rfrGreen, dlg.m_rfrBlue, 
                dlg.m_nrmlObj_flag, 
                dlg.m_lsRed, dlg.m_lsGreen, dlg.m_lsBlue
            );
        }
    }
}

void CGraphicsConclusionView::OnObjSelObj() 
{
    CGraphicsConclusionDoc *pDoc = GetDocument();
    int buf; // integer buffer
    if((buf = GetObjectSelection()) != -1){
        pDoc->objset.actObj = buf;
        Invalidate();
    }
}

void CGraphicsConclusionView::OnObjBoolAnd() 
{
    BoolOperation('*');
}

void CGraphicsConclusionView::OnObjBoolOr() 
{
    BoolOperation('+');
}

void CGraphicsConclusionView::OnObjBoolDiff() 
{
    BoolOperation('-');
}

void CGraphicsConclusionView::OnObjBoolDisasm() 
{
    CComplexObject *newObject; // pointer to the new complex object
    CComplexObject *object; // pointer to current object
    CGraphicsConclusionDoc *pDoc = GetDocument();
    if(pDoc->objset.actObj >= 0){
        object = (CComplexObject *)(pDoc->objset.cplxObjs.GetAt(pDoc->objset.actObj));
        if(!object->IsSimpleObject()){
            newObject = object->Disassemble();
            pDoc->objset.cplxObjs.Add(newObject);
            Invalidate();
        }else{
            MessageBox("Ǽ壬ֽܱ⡣", "ֽ");
        }
    }else{
        MessageBox("ûѡ塣", "ֽ");
    }
}

void CGraphicsConclusionView::OnDrawRender() 
{
    CRenderBox dlg;
	dlg.m_pDocument = GetDocument();
    dlg.DoModal();
}

void CGraphicsConclusionView::DrawObjects( 
	CGraphicsConclusionDoc *pDoc, CDC *pDC, 
	const CScreenViewer &scrnVwr, 
	const CPoint &paneCtr, 
	int width 
)
{
    int i; // loop variable
    for(i = 0; i < pDoc->objset.cplxObjs.GetSize(); i++){
        {
            CPen *pOldPen; // pointer to the old pen
            CPen pen; // pen used when drawing
            if(i == pDoc->objset.actObj){
                pen.CreatePen(PS_SOLID, 1, RGB(192, 192, 192)); 
            }else{
                pen.CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
            }
            pOldPen = pDC->SelectObject(&pen);
            ((CComplexObject *)(pDoc->objset.cplxObjs.GetAt(i)))->
                Draw2(pDC, scrnVwr, paneCtr, width);
            pDC->SelectObject(pOldPen);
        }
    }
}
