// GraphicsConclusionDoc.cpp : implementation of the CGraphicsConclusionDoc class
//

#include "stdafx.h"
#include "GraphicsConclusion.h"

#include "GraphicsConclusionDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionDoc

IMPLEMENT_DYNCREATE(CGraphicsConclusionDoc, CDocument)

BEGIN_MESSAGE_MAP(CGraphicsConclusionDoc, CDocument)
	//{{AFX_MSG_MAP(CGraphicsConclusionDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionDoc construction/destruction

CGraphicsConclusionDoc::CGraphicsConclusionDoc()
{
	// TODO: add one-time construction code here
    C3DVector vrpbuf; // buffer for VRP
    C3DVector copbuf; // buffer for COP
    C3DDirection vpnbuf; // buffer for VPN
    C3DDirection vupbuf; // buffer for VUP

    vrpbuf.Set(-0.15, -0.15, 0.0);
    copbuf.Set(0.0, -0.5, 0.0);
    vpnbuf.Set(0.0, 1.0, 0.0);
    vupbuf.Set(0.0, 0.0, 1.0);
    leftSv.SetBasic(vrpbuf, copbuf, vpnbuf, vupbuf);
    vrpbuf.Set(-0.15, 0.0, 0.15);
    copbuf.Set(0.0, 0.0, 0.5);
    vpnbuf.Set(0.0, 0.0, -1.0);
    vupbuf.Set(-1.0, 0.0, 0.0);
    topSv.SetBasic(vrpbuf, copbuf, vpnbuf, vupbuf);
    vrpbuf.Set(0.0, -0.15, 0.15);
    copbuf.Set(0.288, -0.288, 0.288); // sqrt(x^2 + y^2 + z^2) = 0.5
    vpnbuf.Set(-1.0, 1.0, -1.0);
    vupbuf.Set(-1.0, 1.0, 1.0);
    userSv.SetBasic(vrpbuf, copbuf, vpnbuf, vupbuf);

    objset.actObj = -1; // no active object
}

CGraphicsConclusionDoc::~CGraphicsConclusionDoc()
{
    int i; // loop variable
    for(i = 0; i < objset.cplxObjs.GetSize(); i++){
        delete objset.cplxObjs.GetAt(i);
    }
}

BOOL CGraphicsConclusionDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionDoc serialization

void CGraphicsConclusionDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionDoc diagnostics

#ifdef _DEBUG
void CGraphicsConclusionDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGraphicsConclusionDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGraphicsConclusionDoc commands
