// Cuboid.h: interface for the CCuboid class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CUBOID_H__38E56A35_3843_11D7_B70C_000000000000__INCLUDED_)
#define AFX_CUBOID_H__38E56A35_3843_11D7_B70C_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Shape.h"  // base class
#include "Plane.h"  // dependency
#include "Ray.h"   // dependency
#include "3DVector.h" // dependency
#include "3DDirection.h" // dependency
#include "3DMatrix.h" // dependency

class CCuboid: public CShape
{
protected:
    C3DVector m_referenceEnd; // an end of the cuboid as the reference end
    C3DDirection m_cuboidDirection; // direction of a line from the reference end as a direction of the cuboid
    double m_alpha;   // round turning direction of the cuboid at the reference end around the direction
    double m_depth;   // the depth of the cuboid
    double m_height;  // the height of the cuboid
    double m_width;   // the width of the cuboid
    struct buffer_t
    {
        double phi;
        double theta;
        C3DVector lines[3]; // three typical lines of the cuboid; the first is forward (along cuboidDirection); the second is up; the third is right
        C3DVector ends[8];
    }m_buffer;
public:
    bool CalculateIntersection(const CRay &ray, C3DVector &vctIntersection, bool negative) const;
    CCuboid(const C3DVector &vctRfrEnd, const C3DDirection &dirCbdDrc, double dblAlpha, double dblDepth, double dblHeight, double dblWidth);
	CCuboid();
	virtual ~CCuboid();
    void Draw(CDC *pDC, const CScreenViewer &screenViewer1, POINT ptBasePosition) const;
    void Draw2(CDC *pDC, const CScreenViewer &scrnVwr, POINT basePos, int width) const;
    C3DDirection GetNormal(const C3DVector &pntOnSurf) const;
    CString GetShapeType(void) const;
    void GetParameters(double &refend_x, double &refend_y, double &refend_z, double &o_depth, double &o_width, double &o_height, double &o_theta, double &o_phi, double &o_alpha) const;
    bool IsInObject(const C3DVector &pnt) const;
    bool IsInOrOnObject(const C3DVector &pnt) const;
    bool IsOnObject(const C3DVector &pnt) const;
    void Set(const C3DVector &vctRfrEnd, const C3DDirection &dirCbdDrc, double dblAlpha, double dblDepth, double dblHeight, double dblWidth);
    void SetParameters(double refend_x, double refend_y, double refend_z, double o_depth, double o_width, double o_height, double o_theta, double o_phi, double o_alpha);
    void SetToDefault(void);
    void UpdateBuffer(void);
};

#endif // !defined(AFX_CUBOID_H__38E56A35_3843_11D7_B70C_000000000000__INCLUDED_)
