// ComplexObject.h: interface for the CComplexObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GEOMETRYOBJECT_H__D5F14A08_C54E_453E_A9CF_0B9ADCFC3068__INCLUDED_)
#define AFX_GEOMETRYOBJECT_H__D5F14A08_C54E_453E_A9CF_0B9ADCFC3068__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "PhysicalObject.h" // base class
#include "Cuboid.h" // dependency
#include "Sphere.h" // dependency

class CComplexObject: public CPhysicalObject
{
protected:
    struct tagShapeTree{
        union{
            CShape *pShape; // pointer to the shape
            char op; // operator
        };
        tagShapeTree *parent;
        tagShapeTree *lchild;
        tagShapeTree *rchild;
    }*stRoot; // shape tree root
    tagShapeTree **leafptrs; // tree leaf pointer array
    int numofleaves; // the number of tree leaves
protected:
    bool GetIntersection(int leafIdx, const CRay &ray, C3DVector &intersection) const;
    bool IsValidIntersection(const C3DVector &intersection) const;
    bool IsInObject(tagShapeTree *root, const C3DVector &pnt) const;
    bool IsInOrOnObject(tagShapeTree *root, const C3DVector &pnt) const;
    bool IsNegativeShape(int leafIdx) const;
    bool IsOnObject(tagShapeTree *root, const C3DVector &pnt) const;
    void ReleaseShapeTree(tagShapeTree *root);
    int ShapeTreeNodeCount(tagShapeTree *root);
public:
    void AddCuboid(void);
    void AddSphere(void);
    bool CalculateIntersection(const CRay &ray, C3DVector &vctIntersection, int &o_leafIdx) const;
	CComplexObject();
	virtual ~CComplexObject();
    void Clear(void);
    bool CombineWith(CComplexObject &objOther, char op);
    CComplexObject *Disassemble(void);
    void Draw2(CDC *pDC, const CScreenViewer &scrnVwr, POINT basePos, int width) const;
    CLight FilterDRLight(const CLight &light) const;
    CLight FilterMRLight(const CLight &light) const;
    CLight FilterRfrLight(const CLight &light, double distance) const;
    bool GetDRRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const;
    bool GetMRRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const;
    int GetRfrRay(const CRay &rayIn, const C3DVector &intersection, int shpIdx, CRay &rayOut) const;
    int GetShapeCount(void) const;
    CString GetShapeType(void) const;
    CShape *GetShapePtr(void);
    bool IsSimpleObject(void) const;
};

#endif // !defined(AFX_GEOMETRYOBJECT_H__D5F14A08_C54E_453E_A9CF_0B9ADCFC3068__INCLUDED_)
