// 3DVector.h: interface for the C3DVector class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_3DVECTOR_H__07CD15A1_302B_11D7_B6F7_000000000000__INCLUDED_)
#define AFX_3DVECTOR_H__07CD15A1_302B_11D7_B6F7_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <math.h>

class C3DVector  
{
protected:
    union
    {
        double adata[4];    // array data
        struct vector_t
        {
            double x;
            double y;
            double z;
            double t;
        }vdata;             // vector data
    };
public:
    friend class C3DMatrix;
public:
    static const double EPSILON;
public:
    C3DVector(const C3DVector &vctSource);
    C3DVector(double dblX, double dblY, double dblZ);
	C3DVector();
	virtual ~C3DVector();
    void Clear(void);
    double DistanceTo(const C3DVector &vctOther) const;
    void Get(double &dblX, double &dblY, double &dblZ) const;
    double GetArrayItem(int intAxis) const;
    double GetModel(void) const;
    double GetX(void) const;
    double GetY(void) const;
    double GetZ(void) const;
    double operator*(const C3DVector &vctOther) const;
    friend C3DVector operator*(double dblScale, const C3DVector &vctSource);
    friend C3DVector operator*(const C3DVector &vector1, const C3DMatrix &matrix2);
    friend C3DVector &operator*=(C3DVector &vector1, const C3DMatrix &matrix2);
    C3DVector operator+(const C3DVector &vctOther) const;
    C3DVector operator-(void) const;
    C3DVector operator-(const C3DVector &vctOther) const;
    C3DVector &operator-=(const C3DVector &vctOther);
    C3DVector &operator+=(const C3DVector &vctOther);
    C3DVector &operator=(const C3DVector &vctSource);
    bool operator==(const C3DVector &vctOther) const;
    virtual void Set(const C3DVector &vctSource);
    virtual void Set(double dblX, double dblY, double dblZ);
    virtual void SetX(double dblX);
    virtual void SetY(double dblY);
    virtual void SetZ(double dblZ);
    void StandardizePoint(void);
    void UnitizeVector(void);
    C3DVector XMultiply(const C3DVector &vctOther) const;
};

#endif // !defined(AFX_3DVECTOR_H__07CD15A1_302B_11D7_B6F7_000000000000__INCLUDED_)
