// 3DMatrix.h: interface for the C3DMatrix class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_3DMATRIX_H__ECBE77C4_30F5_11D7_B6FB_000000000000__INCLUDED_)
#define AFX_3DMATRIX_H__ECBE77C4_30F5_11D7_B6FB_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "3DVector.h"   // dependency
#include <math.h>

class C3DMatrix  
{
protected:
    double data[16];
public:
    C3DMatrix(const double dblArray[]);
    C3DMatrix(const C3DMatrix &mtxSource);
	C3DMatrix();
	virtual ~C3DMatrix();
    void Clear(void);
    void Get(double dblArray[]) const;
    bool Inverse(void);
    static C3DMatrix MoveMatrix(double dblIncrX, double dblIncrY, double dblIncrZ);
    friend C3DVector operator*(const C3DVector &vector1, const C3DMatrix &matrix2);
    friend C3DVector &operator*=(C3DVector &vector1, const C3DMatrix &matrix2);
    C3DMatrix operator*(const C3DMatrix &mtxOther) const;
    C3DMatrix &operator=(const C3DMatrix &mtxSource);
    static C3DMatrix RotateMatrix(double dblTheta, int intAxis);
    void Set(const double dblArray[]);
    void SetItem(int intNumber, double dblValue);
    void SetToUnit(bool blnClear);
    static C3DMatrix ShiftMatrix(double dblScaleA, double dblScaleB, int intAxis);
    static C3DMatrix SizingMatrix(double dblScaleX, double dblScaleY, double dblScaleZ);
};

#endif // !defined(AFX_3DMATRIX_H__ECBE77C4_30F5_11D7_B6FB_000000000000__INCLUDED_)
