// 3DDirection.h: interface for the C3DDirection class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_3DDIRECTION_H__F5DBF894_31A1_11D7_B6FD_000000000000__INCLUDED_)
#define AFX_3DDIRECTION_H__F5DBF894_31A1_11D7_B6FD_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "3DVector.h"	// base class
#include <math.h>

class C3DDirection: public C3DVector
{
protected:
    // diable part of base class members
    C3DVector::Set;
    C3DVector::SetX;
    C3DVector::SetY;
    C3DVector::SetZ;
    C3DVector::StandardizePoint;
    C3DVector::UnitizeVector;
public:
    C3DDirection(const C3DDirection &dirSource);
    C3DDirection(const C3DVector &vctSource);
    C3DDirection(double dblX, double dblY, double dblZ);
	C3DDirection();
	virtual ~C3DDirection();
    void FineTune(void);
    double GetPhi(void) const;
    double GetTheta(void) const;
    C3DDirection &operator=(const C3DDirection &dirSource);
    C3DDirection &operator=(const C3DVector &vctSource);
    void Set(const C3DDirection &dirSource);
    void Set(const C3DVector &vctSrc);
    void Set(double dblX, double dblY, double dblZ);
    void SetThetaPhi(double dblTheta, double dblPhi);
};

#endif // !defined(AFX_3DDIRECTION_H__F5DBF894_31A1_11D7_B6FD_000000000000__INCLUDED_)
