// 3DDirection.cpp: implementation of the C3DDirection class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsConclusion.h"
#include "3DDirection.h"
#include "Shape.h"		// dependency

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

C3DDirection::C3DDirection(const C3DDirection &dirSource): 
	C3DVector(dirSource)
{
}

C3DDirection::C3DDirection(const C3DVector &vctSource): 
	C3DVector(vctSource)
{
    ASSERT(vdata.x != 0.0 || vdata.y != 0.0 || vdata.z != 0.0);
    C3DVector::UnitizeVector();
}

C3DDirection::C3DDirection(double dblX, double dblY, double dblZ): 
	C3DVector(dblX, dblY, dblZ)
{
    ASSERT(dblX != 0.0 || dblY != 0.0 || dblZ != 0.0);
    C3DVector::UnitizeVector();
}

C3DDirection::C3DDirection():
	C3DVector(0.0, 0.0, 1.0)
{
}

C3DDirection::~C3DDirection()
{
}

void C3DDirection::FineTune(void)
{
    C3DVector::UnitizeVector();
}

double C3DDirection::GetPhi(void) const
{
    return acos(vdata.z);
}

double C3DDirection::GetTheta(void) const
{
    if(vdata.x != 0.0){
        return atan2(vdata.y, vdata.x);
    }else{
        return vdata.y * CShape::PI / 2.0;
    }
}

C3DDirection &C3DDirection::operator=(const C3DDirection &dirSource)
{
    C3DVector::operator=(dirSource);
    return *this;
}

C3DDirection &C3DDirection::operator=(const C3DVector &vctSource)
{
    C3DVector::operator=(vctSource);
    C3DVector::UnitizeVector();
    return *this;
}

void C3DDirection::Set(const C3DDirection &dirSource)
{
    operator=(dirSource); // for simplicity and consistency
}

void C3DDirection::Set(const C3DVector &vctSrc)
{
	operator=(vctSrc);
}

void C3DDirection::Set(double dblX, double dblY, double dblZ)
{
    C3DVector::Set(dblX, dblY, dblZ);
    C3DVector::UnitizeVector();
}

void C3DDirection::SetThetaPhi(double dblTheta, double dblPhi)
{
    double dblSinPhi;

    dblSinPhi = sin(dblPhi);
    vdata.z = cos(dblPhi);
    vdata.x = cos(dblTheta) * dblSinPhi;
    vdata.y = sin(dblTheta) * dblSinPhi;
}
