'
'=================================================================
'-----------------------------------------------------------------
'
'  SPEED (working title)
'  THE GAME
'
'  Michael "the wizard" Purvis
'
'
'
'
'  Run QB4.5 with the /lqb command line parameter. In QB1.1, add
'  an extra comment symbol to the first line below.
'
'  Tweak the gameplay constants below for optimal performance.
'
'-----------------------------------------------------------------
'=================================================================
'

'$INCLUDE: 'QB.BI'

DEFINT A-Z
DECLARE SUB pal (n AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER)
DECLARE FUNCTION Multikey% (T%)
DECLARE SUB PutSpin (x%, y%, cel%)
DECLARE SUB PutMan (x%, y%, cel%)
DECLARE SUB PutPixel (x%, y%, c%)
DECLARE SUB HideMouse ()
DECLARE SUB ShowMouse ()
DECLARE SUB GetMouseCord (K%, K3%, M4%)
DECLARE SUB StartMouse ()
DECLARE SUB pix12 (horizontal%, vertical%, layer%)
DECLARE SUB Store88 (column%, ystart%, ystop%, where$)
DECLARE SUB Put88 (column%, ystart%, where$)
DECLARE SUB PutCharFlip (x%, y%, cel%, startrow%, stoprow%)
DECLARE SUB PutChar (x%, y%, cel%, startrow%, stoprow%, layer%)
DECLARE SUB writestring (x%, y%, text$, wid%, height%, layer%)
DECLARE SUB HorizBar (y AS INTEGER, height AS LONG, action AS INTEGER, layer AS INTEGER)
DECLARE FUNCTION MainMenu% (lastscore AS LONG, lasttime AS LONG, lastkilled AS LONG, lastescaped AS LONG)
DECLARE FUNCTION BitFlip% (source%)
												 
RANDOMIZE TIMER




'=================================================================
'-----------------------------------------------------------------
'
'  INITIALIZE CONSTANTS AND ARRAYS
'
'-----------------------------------------------------------------
'=================================================================

DIM SHARED dev   'skip menu and gameover sequences
dev = 0

'-----------------------------------------------------------------
' GAMEPLAY CONSTANTS
'-----------------------------------------------------------------

'Player Movement and Jumping
'--------------------------------
CONST Acceleration = .6
CONST TopSpeed = .6
CONST StandStillTime = 1000
CONST SlowDown = 600
CONST JumpFallOff = 80
CONST jumpvertex = -.12
CONST JumpInitialVelocity = -1

'Life and Score
'--------------------------------
CONST LifeMax = 180
CONST LifeOffPerCycle = .02
CONST LifeOffExtraPerSecond = .0001
CONST LifeOffPerHit = 30
CONST LifeGainPerKill = 20
CONST HitScore = 50
CONST KillScore = 500
CONST KillScoreExtraPerSecond = 2
CONST ScorePerFrame = 1
CONST invincibleframes = 200
CONST LifeStayMax = 1000

'Bullets and Firing
'--------------------------------
CONST OnScreenBulletMax = 7
CONST BulletSpeed = 1.5
CONST BulletGap = 45

'Particles and Gibs
'--------------------------------
CONST ParticleMax = 40
CONST ParticleGrav = .01
CONST HitBloom = 2
CONST KillBloom = 10

'Enemies
'--------------------------------
CONST OnScreenEnemyMax = 14
CONST enemyspawntime = 400
CONST Enemy1Speed = .25
CONST EnemyYThrowback = .4
CONST EnemyHP = 3

'Technical/Visual
'--------------------------------
CONST crosshairs = 151  '(varying styles- 150 thru 153)

DIM hp3%(3)  'first sprite in the three levels of enemy hp animation.

DATA 183, 179, 209
READ hp3%(1), hp3%(2), hp3%(3)


'-----------------------------------------------------------------
' SYSTEM CONSTANTS
'-----------------------------------------------------------------

CONST framesperretrace = 5

Null$ = CHR$(0)
CONST UP = 72, DOWN = 80

DIM SHARED Inregs AS RegType, Outregs AS RegType

DIM SHARED bitfield(7) AS INTEGER
	bitfield(0) = 128: bitfield(1) = 64: bitfield(2) = 32
	bitfield(3) = 16: bitfield(4) = 8: bitfield(5) = 4
	bitfield(6) = 2: bitfield(7) = 1


'-----------------------------------------------------------------
' ARRAYS FOR THE FONT, SPRITES, AND MAP
'-----------------------------------------------------------------


'first dimension is the cel, second is the line
DIM SHARED Info%(255, 7)

'x/y co-ordinates for 8x8 blocks
DIM SHARED Map%(80, 60)


'-----------------------------------------------------------------
' HIGH SCORE ARRAYS
'-----------------------------------------------------------------

DIM SHARED names$(10), scores&(10), times!(10), kills%(10), escapes%(10)


'-----------------------------------------------------------------
' TYPE DEFINITION AND ARRAY FOR ENEMIES/TARGETS
'-----------------------------------------------------------------

TYPE enemyTYPE
	x AS SINGLE
	y AS SINGLE
	xchng AS SINGLE
	ychng AS SINGLE
	hp AS INTEGER
	cel AS INTEGER
	jump AS INTEGER
	index AS INTEGER
END TYPE

DIM enemy(OnScreenEnemyMax) AS enemyTYPE


'-----------------------------------------------------------------
' TYPE DEFINITION AND ARRAY FOR PARTICLES AND BULLETS
'-----------------------------------------------------------------


'Particles
TYPE particleTYPE
	x AS SINGLE
	y AS SINGLE
	xchng AS SINGLE
	ychng AS SINGLE
	ctr AS LONG
	'lifetime AS LONG
END TYPE

DIM SHARED Particle(ParticleMax) AS particleTYPE

'Bullets
TYPE bulletTYPE
	x AS SINGLE
	y AS SINGLE
	xchng AS SINGLE
	ychng AS SINGLE
END TYPE

DIM SHARED bullets(OnScreenBulletMax) AS bulletTYPE



'=================================================================
'-----------------------------------------------------------------
'
'  INITIALIZE PROGRAM
'
'-----------------------------------------------------------------
'=================================================================



'-----------------------------------------------------------------
' LOADING THE FONT AND SPRITES
'-----------------------------------------------------------------


OPEN "RUNNER.FNT" FOR BINARY AS #1

FOR rcel = 0 TO 255
	FOR rline = 0 TO 7
		GET #1, (rcel * 8) + rline + 1, Info%(rcel, rline)
		Info%(rcel, rline) = Info%(rcel, rline) AND 255
	NEXT
NEXT

CLOSE #1

SCREEN 12


'-----------------------------------------------------------------
' LOAD THE HIGH SCORES
'-----------------------------------------------------------------


OPEN "scores.run" FOR BINARY AS #1


bytenum = 1

FOR ctr = 1 TO 10
	thisname$ = ""
	done = 0
	DO
		GET #1, bytenum, holder%
		bytenum = bytenum + 1
		asci% = holder% AND 255
		IF asci% <> 97 + ctr THEN
			asci% = asci% + 32 - ctr
			thisname$ = thisname$ + CHR$(asci%)
		ELSE
			done = 1
		END IF
	LOOP UNTIL done
	names$(ctr) = thisname$
NEXT

FOR ctr = 1 TO 10
	GET #1, , value!
	scores&(ctr) = value! * (ctr + 2)
	GET #1, , value!
	times!(ctr) = value! * 23
NEXT
FOR ctr = 1 TO 10
	GET #1, , valu%
	kills%(ctr) = -valu%
	GET #1, , valu%
	escapes%(ctr) = -valu%
NEXT

CLOSE #1


'-----------------------------------------------------------------
' INITIALIZING THE MOUSE
'-----------------------------------------------------------------


StartMouse
HideMouse

GetMouseCord mButton, mX, mY




'-----------------------------------------------------------------
' INITIALIZING THE SYSTEM AND VARIABLES (and palette)
'-----------------------------------------------------------------


DEF SEG = &HA000


CLS

writestring 8, 470, "wizardcode presents", 16, 7, 1
writestring 8, 470, "wizardcode presents", 16, 7, 2
writestring 8, 470, "wizardcode presents", 16, 7, 3
writestring 8, 470, "wizardcode presents", 16, 7, 4

WHILE INKEY$ = "": WEND


WHILE MainMenu%(score&, gametime&, kills&, escaped&) <> 4 'only play if the user didn't select 'quit'



cel% = 0
IF INT(RND) THEN
	x! = 320 - 210
ELSE
	x! = 320 + 210
END IF
y! = 180
jump = 2
xchng! = 0
ychng! = -jumpvertex

ctr% = 0
bulletctr% = 0
framectr = 0
enemyspawn% = 0


frames% = 0
timestore& = TIMER

starttime& = TIMER
score& = 0
screenscore& = 0
kills& = 0
escaped& = 0
Life! = LifeMax
LastLife! = 0
Invincible% = 0
LifeStay% = 2000

bgpulsectr! = 0
bgpulsechng! = 0

foo% = Multikey%(-1)
  
MOVEMENT = 1


FOR ctr% = 0 TO OnScreenEnemyMax
	enemy(ctr%).x! = -1
NEXT

FOR ctr% = 0 TO ParticleMax
	Particle(ctr%).x! = -1
NEXT

FOR ctr% = 0 TO OnScreenBulletMax
	bullets(ctr%).x! = -1
NEXT

'-----------------------------------------------------------------
' LOADING THE MAP FILE
'-----------------------------------------------------------------

LINE (0, 0)-STEP(639, 479), 0, BF


LINE (0, 0)-STEP(0, 479), 1, B
LINE (639, 0)-STEP(0, 479), 1, B

OPEN "MAP.RUN" FOR BINARY AS #1

blnk% = 250
blck% = 45
FOR y = 1 TO 60
	FOR x = 1 TO 80
		GET #1, ((y - 1) * 80) + x, temp%
		temp% = temp% AND 255
		SELECT CASE temp%
			CASE blnk%
				Map(x, y) = 0
			CASE blck%
				Map(x, y) = 1
				LINE ((x - 1) * 8, (y - 1) * 8)-STEP(8, 8), 1, BF
		END SELECT
	NEXT
  
NEXT

CLOSE #1


writestring 25, 439, CHR$(131) + CHR$(132) + CHR$(133), 8, 7, 3
writestring 25, 449, CHR$(0) + CHR$(129) + CHR$(130), 8, 7, 3
writestring 25, 459, CHR$(0) + CHR$(137) + CHR$(138), 8, 7, 3



writestring 169, 439, CHR$(169) + CHR$(170) + CHR$(171) + CHR$(172), 8, 7, 3

writestring 169, 449, CHR$(0) + CHR$(176) + CHR$(177) + CHR$(178), 8, 7, 3

'WriteString 129, 459, CHR$(0) + CHR$(173) + CHR$(174) + CHR$(175), 8, 7, 3

DIM red(15), green(15), blue(15)

red(0) = 0: green(0) = 0: blue(0) = 0           'bg
red(1) = 15: green(1) = 20: blue(1) = 30        'walls
red(2) = 53: green(2) = 53: blue(2) = 53        'particles/bullets/cursor
red(3) = 53: green(3) = 53: blue(3) = 53        'wall & particles
red(4) = 2: green(4) = 63: blue(4) = 63         'character and HUD font
red(5) = 53: green(5) = 63: blue(5) = 53        'character and wall
red(8) = 63: green(8) = 53: blue(8) = 43        'enemies
red(15) = 63: green(15) = 63: blue(15) = 63

OUT &H3C8, 15
OUT &H3C9, red(15)
OUT &H3C9, green(15)
OUT &H3C9, blue(15)

FOR a = 0 TO 50
	LINE (57, 459)-(57 + INT(3.6 * a), 466), 8, BF
	FOR b = 1 TO 8
		OUT &H3C8, b
		OUT &H3C9, INT((red(b) / 50) * a)
		OUT &H3C9, INT((green(b) / 50) * a)
		OUT &H3C9, INT((blue(b) / 50) * a)
	NEXT
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT




'=================================================================
'-----------------------------------------------------------------
'
'  ANIMATION LOOP
'
'-----------------------------------------------------------------
'=================================================================




DO


'-----------------------------------------------------------------
' KEYPRESS ROUTINES
'-----------------------------------------------------------------


	IF Multikey(72) OR Multikey(17) THEN   'up
		IF jump = 0 THEN
			ychng! = JumpInitialVelocity
			jump = 1
		END IF
	ELSE
		IF jump = 1 AND Invincible% = 0 THEN
			jump = 2
			ychng! = -jumpvertex
		END IF
	END IF
 

	IF Multikey(77) OR Multikey(32) THEN   'right
		IF xchng! < TopSpeed THEN xchng! = xchng! + Acceleration
		MOVEMENT = 2
	ELSE
		IF xchng! > 0 THEN xchng! = xchng! - xchng! / SlowDown
	END IF


	IF Multikey(75) OR Multikey(30) THEN   'left
		IF -xchng! < TopSpeed THEN xchng! = xchng! - Acceleration
		MOVEMENT = 1
	ELSE
		IF xchng! < 0 THEN xchng! = xchng! - xchng! / SlowDown
	END IF


'-----------------------------------------------------------------
' MOUSE ROUTINES
'-----------------------------------------------------------------


	omX = mX
	omY = mY
	GetMouseCord mButton, mX, mY
	IF mX < 4 THEN mX = 4
	IF mX > 634 THEN mX = 634
	IF mY < 4 THEN mY = 4
	IF mY > 475 THEN mY = 475
  
	PutChar omX - 4, omY - 4, 0, 0, 7, 2
	PutChar mX - 4, mY - 4, crosshairs, 0, 7, 2
	
	IF bulletctr% > 0 THEN bulletctr% = bulletctr% - 1

	IF mButton = 1 AND bulletctr% = 0 THEN
		FOR newbullet% = 0 TO OnScreenBulletMax
			IF bullets(newbullet%).x! = -1 THEN EXIT FOR
		NEXT
		rn! = mX - x%
		rise! = mY - y% + 5
		length! = SQR((rn! ^ 2) + (rise! ^ 2))
	  
		IF newbullet% <= OnScreenBulletMax AND length! <> 0 THEN
			bullets(newbullet%).x! = x!
			bullets(newbullet%).y! = y! - 5
			multiple! = BulletSpeed / length!
			bullets(newbullet%).xchng! = rn! * multiple!
			bullets(newbullet%).ychng! = rise! * multiple!
			'WriteString 2, 16, "last bullet:" + STR$(newbullet%), 8, 7, 3
		END IF
		bulletctr% = BulletGap
	END IF
  

'-----------------------------------------------------------------
' UPDATING THE PARTICLES AND BULLETS
'-----------------------------------------------------------------

	FOR thisparticle% = 0 TO ParticleMax
		IF Particle(thisparticle%).x! <> -1 THEN
		  
			IF Particle(thisparticle%).y! > 0 THEN
				pix12 INT(Particle(thisparticle%).x!), INT(Particle(thisparticle%).y!), 130
			 
				Particle(thisparticle%).x! = Particle(thisparticle%).x! + Particle(thisparticle%).xchng!
				Particle(thisparticle%).y! = Particle(thisparticle%).y! + Particle(thisparticle%).ychng!
			 
				Particle(thisparticle%).ychng! = Particle(thisparticle%).ychng! + ParticleGrav

				tempx% = INT(Particle(thisparticle%).x!)
				tempy% = INT(Particle(thisparticle%).y!)

				pix12 tempx%, tempy%, 66
			ELSE
				Particle(thisparticle%).x! = Particle(thisparticle%).x! + Particle(thisparticle%).xchng!
				Particle(thisparticle%).y! = Particle(thisparticle%).y! + Particle(thisparticle%).ychng!
			
				Particle(thisparticle%).ychng! = Particle(thisparticle%).ychng! + ParticleGrav

				tempx% = INT(Particle(thisparticle%).x!)
				tempy% = INT(Particle(thisparticle%).y!)
			END IF

		  
			IF tempx% < 8 THEN
				Particle(thisparticle%).xchng! = ABS(Particle(thisparticle%).xchng!)
			END IF

			IF tempx% > 630 THEN
				Particle(thisparticle%).xchng! = -ABS(Particle(thisparticle%).xchng!)
			END IF
		  
			IF tempx% < 0 OR tempx% > 639 THEN
				Particle(thisparticle%).x! = -1
			END IF

			IF tempy% > 479 THEN
				IF Particle(thisparticle%).ychng! > .7 THEN
					Particle(thisparticle%).ychng! = -(Particle(thisparticle%).ychng! * .6)
				ELSE
					Particle(thisparticle%).x! = -1
				END IF
			END IF
		END IF
	NEXT

	FOR thisbullet% = 0 TO OnScreenBulletMax
		IF bullets(thisbullet%).x! <> -1 THEN
			pix12 INT(bullets(thisbullet%).x!), INT(bullets(thisbullet%).y!), 130
		  
			bullets(thisbullet%).x! = bullets(thisbullet%).x! + bullets(thisbullet%).xchng!
			bullets(thisbullet%).y! = bullets(thisbullet%).y! + bullets(thisbullet%).ychng!
			tempx% = INT(bullets(thisbullet%).x!)
			tempy% = INT(bullets(thisbullet%).y!)
		 
			'IF INT(bullets(thisbullet%).x! - bullets(thisbullet%).xchng!) <> tempx% OR INT(bullets(thisbullet%).y! - bullets(thisbullet%).ychng!) <> tempy% THEN
			'pix12 INT(bullets(thisbullet%).x! - bullets(thisbullet%).xchng!), INT(bullets(thisbullet%).y! - bullets(thisbullet%).ychng!), 130
			pix12 tempx%, tempy%, 66
		  ' END IF

			IF tempx% < 0 OR tempx% > 639 OR tempy% < 0 OR tempy% > 479 THEN
				bullets(thisbullet%).x! = -1
			ELSE
				IF Map(tempx% \ 8 + 1, tempy% \ 8 + 1) = 1 THEN
					FOR newparticle% = 0 TO ParticleMax
						IF Particle(newparticle%).x! = -1 THEN EXIT FOR
					NEXT
					IF newparticle% <= ParticleMax AND length! <> 0 THEN
						Particle(newparticle%).x! = bullets(thisbullet%).x!
						Particle(newparticle%).y! = bullets(thisbullet%).y!
						Particle(newparticle%).xchng! = bullets(thisbullet%).xchng! / 3
						Particle(newparticle%).ychng! = bullets(thisbullet%).ychng! / 3
					END IF
					bullets(thisbullet%).x! = -1
					pix12 tempx%, tempy%, 130
				END IF
			END IF

			FOR enctr% = 0 TO OnScreenEnemyMax
				IF enemy(enctr%).x! <> -1 AND enemy(enctr%).index% <> 3 THEN
					IF INT(bullets(thisbullet%).y!) <= INT(enemy(enctr%).y!) AND INT(bullets(thisbullet%).y!) >= INT(enemy(enctr%).y! - 7) THEN
						IF INT(bullets(thisbullet%).x!) <= INT(enemy(enctr%).x!) + 2 AND INT(bullets(thisbullet%).x!) >= INT(enemy(enctr%).x! - 2) THEN
							'pix12 INT(bullets(thisbullet%).x! - bullets(thisbullet%).xchng!), INT(bullets(thisbullet%).y! - bullets(thisbullet%).ychng!), 130
							pix12 tempx%, tempy%, 130
							score& = score& + HitScore
							enemy(enctr%).hp% = enemy(enctr%).hp% - 1
							IF enemy(enctr%).hp% <= 0 THEN
								enemy(enctr%).index% = 3
								enemy(enctr%).hp% = 0
							ELSE
								enemy(enctr%).index% = 2
							END IF

							FOR a% = 1 TO HitBloom
								FOR newparticle% = 0 TO ParticleMax
									IF Particle(newparticle%).x! = -1 THEN EXIT FOR
								NEXT
								IF newparticle% <= ParticleMax AND length! <> 0 THEN
									Particle(newparticle%).x! = bullets(thisbullet%).x!
									Particle(newparticle%).y! = bullets(thisbullet%).y!
									Particle(newparticle%).xchng! = -bullets(thisbullet%).xchng! / 3
									Particle(newparticle%).ychng! = -bullets(thisbullet%).xchng! / 3
								END IF
							NEXT


							enemy(enctr%).cel% = 0
							enemy(enctr%).xchng! = bullets(thisbullet%).xchng! / 4
							enemy(enctr%).ychng! = bullets(thisbullet%).ychng! / 8 - EnemyYThrowback
							IF enemy(enctr%).ychng! < -.8 THEN enemy(enctr%).ychng! = -.8

							bullets(thisbullet%).x! = -.08
						END IF
					END IF
				END IF
			NEXT
		END IF
	NEXT


'-----------------------------------------------------------------
' UPDATING AND SPAWNING ENEMIES
'-----------------------------------------------------------------

	FOR thisenemy% = 0 TO OnScreenEnemyMax
		IF enemy(thisenemy%).x! <> -1 THEN
			IF enemy(thisenemy%).index% <> 3 AND Invincible% = 0 THEN
				IF enemy(thisenemy%).x! > x! - 4 AND enemy(thisenemy%).x! < x! + 4 THEN
					IF enemy(thisenemy%).y! > y! - 4 AND enemy(thisenemy%).y! < y! + 4 THEN
						'PRINT "hit"
						OUT &H3C8, 0
						OUT &H3C9, 63
						OUT &H3C9, 63
						OUT &H3C9, 63
						Invincible% = invincibleframes%
						LifeStay% = LifeStayMax
						ychng! = JumpInitialVelocity / 2
						jump = 1
						Life! = Life! - LifeOffPerHit
					END IF
				END IF
			END IF

			SELECT CASE enemy(thisenemy%).index%
				CASE 1                                 'normal operation
					IF enemy(thisenemy%).jump = 2 THEN  'falling
						enemy(thisenemy%).ychng! = enemy(thisenemy%).ychng! + (enemy(thisenemy%).ychng! / JumpFallOff)
					  
						IF enemy(thisenemy%).ychng! > 1 THEN enemy(thisenemy%).ychng! = 1

						enemy(thisenemy%).y! = enemy(thisenemy%).y! + enemy(thisenemy%).ychng!
											 
						'check if the fall is broken by a floor piece
						xblock% = INT(enemy(thisenemy%).x!) \ 8 + 1
						yblock% = INT(enemy(thisenemy%).y!) \ 8 + 1
						IF Map(xblock%, yblock%) = 1 THEN
							enemy(thisenemy%).y! = yblock% * 8 - 8
							enemy(thisenemy%).ychng! = 0
							enemy(thisenemy%).jump = 0
							IF RND > .5 THEN
								enemy(thisenemy%).xchng! = Enemy1Speed
							ELSE
								enemy(thisenemy%).xchng! = -Enemy1Speed
							END IF
							enemy(thisenemy%).cel% = 0
						END IF
						PutChar INT(enemy(thisenemy%).x!) - 4, INT(enemy(thisenemy%).y!) - 7, hp3%(enemy(thisenemy%).hp%), 0, 7, 4
					ELSE                                 'walking
						oldx% = INT(enemy(thisenemy%).x!)
						enemy(thisenemy%).x! = enemy(thisenemy%).x! + enemy(thisenemy%).xchng!
						IF oldx% <> INT(enemy(thisenemy%).x!) THEN
							enemy(thisenemy%).cel% = enemy(thisenemy%).cel% + 1
							IF enemy(thisenemy%).cel% > 3 THEN enemy(thisenemy%).cel% = 0
						END IF
						xblock% = INT(enemy(thisenemy%).x!) \ 8 + 1
						yblock% = INT(enemy(thisenemy%).y!) \ 8 + 1
						IF Map(xblock%, yblock%) = 0 THEN
							enemy(thisenemy%).ychng! = -jumpvertex
							enemy(thisenemy%).jump = 2
							'PRINT 'foo"
						END IF
						IF enemy(thisenemy%).y! > yblock% * 8 - 8 THEN
							enemy(thisenemy%).y! = enemy(thisenemy%).y! - 1
							'enemy(thisenemy%).xchng! = -enemy(thisenemy%).xchng!
						END IF

						IF Map(xblock%, yblock% - 1) = 1 THEN
							enemy(thisenemy%).xchng! = -enemy(thisenemy%).xchng!
						END IF
						'IF enemy(thisenemy%).hp% > 0 AND enemy(thisenemy%).hp% < 4 THEN
							PutChar INT(enemy(thisenemy%).x!) - 4, INT(enemy(thisenemy%).y!) - 7, hp3%(enemy(thisenemy%).hp%) + enemy(thisenemy%).cel%, 0, 7, 4
						'END IF
					END IF

				CASE 2                              'Stunned
					enemy(thisenemy%).ychng! = enemy(thisenemy%).ychng! + (ABS(enemy(thisenemy%).ychng!) / JumpFallOff)
				  
					IF enemy(thisenemy%).ychng! > 1 THEN enemy(thisenemy%).ychng! = 1
					IF enemy(thisenemy%).ychng! < -1 THEN enemy(thisenemy%).ychng! = -1
					enemy(thisenemy%).xchng! = enemy(thisenemy%).xchng! * .999
				  
					IF enemy(thisenemy%).ychng! > jumpvertex AND enemy(thisenemy%).ychng! < 0 THEN
						enemy(thisenemy%).ychng! = -jumpvertex
					END IF

					'oldx% = INT(enemy(thisenemy%).x!)

					enemy(thisenemy%).y! = enemy(thisenemy%).y! + enemy(thisenemy%).ychng!
					enemy(thisenemy%).x! = enemy(thisenemy%).x! + enemy(thisenemy%).xchng!
															
					'check if the fall is broken by a floor piece
					xblock% = INT(enemy(thisenemy%).x!) \ 8 + 1
					yblock% = INT(ABS(enemy(thisenemy%).y!)) \ 8 + 1

					IF Map(xblock%, yblock% - 1) = 1 THEN
						enemy(thisenemy%).xchng! = -(enemy(thisenemy%).xchng! / 2)
						enemy(thisenemy%).x! = enemy(thisenemy%).x! + enemy(thisenemy%).xchng!
					  
						'enemy(thisenemy%).y! = enemy(thisenemy%).y! + 1
						enemy(thisenemy%).ychng! = -jumpvertex
					ELSE
						 IF Map(xblock%, yblock%) = 1 THEN
							IF enemy(thisenemy%).xchng! > 0 THEN
								enemy(thisenemy%).xchng! = Enemy1Speed
							ELSE
								enemy(thisenemy%).xchng! = -Enemy1Speed
							END IF
							enemy(thisenemy%).index% = 1
							enemy(thisenemy%).jump% = 0
							enemy(thisenemy%).cel% = 0
							enemy(thisenemy%).ychng! = 0
						END IF
					END IF

					'IF enemy(thisenemy%).hp% > -1 THEN
						PutChar INT(enemy(thisenemy%).x!) - 4, INT(enemy(thisenemy%).y!) - 7, hp3%(enemy(thisenemy%).hp%), 0, 7, 4
					'END IF
				CASE 3                         'dead
					enemy(thisenemy%).ychng! = enemy(thisenemy%).ychng! + (ABS(enemy(thisenemy%).ychng!) / JumpFallOff)
				  
					enemy(thisenemy%).hp% = enemy(thisenemy%).hp% + 1
				  
					'PRINT enemy(thisenemy%).cel%
					IF enemy(thisenemy%).hp% >= 20 THEN
						enemy(thisenemy%).hp% = 0
						enemy(thisenemy%).cel% = enemy(thisenemy%).cel% + 1
					END IF

					IF enemy(thisenemy%).cel% = 6 OR enemy(thisenemy%).x! < 1 OR enemy(thisenemy%).x! > 638 THEN
						IF enemy(thisenemy%).x! < 8 THEN enemy(thisenemy%).x! = 8
						IF enemy(thisenemy%).x! > 630 THEN enemy(thisenemy%).x! = 630
						
						FOR a% = 1 TO KillBloom
							FOR newparticle% = 0 TO ParticleMax
								IF Particle(newparticle%).x! = -1 THEN EXIT FOR
							NEXT
							IF newparticle% <= ParticleMax AND length! <> 0 THEN
								Particle(newparticle%).x! = enemy(thisenemy%).x!
								Particle(newparticle%).y! = enemy(thisenemy%).y!
								Particle(newparticle%).xchng! = RND - .5 + (2 * enemy(thisenemy%).xchng!)
								Particle(newparticle%).ychng! = RND - .7
							END IF
						NEXT
						score& = score& + KillScore + (KillScoreExtraPerSecond * (TIMER - starttime&))
						kills& = kills& + 1
						Life! = Life! + LifeGainPerKill
						enemy(thisenemy%).hp% = 0
						enemy(thisenemy%).x! = -1
						enemy(thisenemy%).xchng! = 0
						enemy(thisenemy%).index% = 1
					END IF

					
					IF enemy(thisenemy%).ychng! > 1 THEN enemy(thisenemy%).ychng! = 1
					IF enemy(thisenemy%).ychng! < -1 THEN enemy(thisenemy%).ychng! = -1

					IF enemy(thisenemy%).ychng! > jumpvertex AND enemy(thisenemy%).ychng! < 0 THEN
						enemy(thisenemy%).ychng! = -jumpvertex
					END IF
				  
				  
					enemy(thisenemy%).xchng! = enemy(thisenemy%).xchng! * .995

					enemy(thisenemy%).y! = enemy(thisenemy%).y! + enemy(thisenemy%).ychng!
					enemy(thisenemy%).x! = enemy(thisenemy%).x! + enemy(thisenemy%).xchng!
									
					PutChar INT(enemy(thisenemy%).x!) - 4, INT(enemy(thisenemy%).y!) - 7, 214 + enemy(thisenemy%).cel%, 0, 7, 4
				CASE ELSE
			END SELECT
			'If it goes off the bottom, kill it.
			IF INT(enemy(thisenemy%).y!) >= 479 THEN
				PutChar INT(enemy(thisenemy%).x!) - 4, INT(enemy(thisenemy%).y!) - 7, 0, 0, 7, 4
				enemy(thisenemy%).x! = -1
				escaped& = escaped& + 1
			END IF
		END IF
	NEXT


	IF (enemyspawn% > enemyspawntime%) THEN
		FOR newenemy% = 0 TO OnScreenEnemyMax
			IF enemy(newenemy%).x! = -1 THEN EXIT FOR
		NEXT
		IF newenemy% <= OnScreenEnemyMax THEN
				'BEEP
				'enemy(newenemy%).x! = 320
				enemy(newenemy%).x! = 285 + INT(RND * 70) + 1
				enemy(newenemy%).y! = 10
				enemy(newenemy%).xchng! = 0
				enemy(newenemy%).ychng! = -jumpvertex
				enemy(newenemy%).jump% = 2
				enemy(newenemy%).hp% = EnemyHP
				enemy(newenemy%).cel% = 0
				enemy(newenemy%).index% = 1
				'WriteString 8, 40, "last enemy:" + STR$(newenemy%), 0, 7, 3
		END IF
		enemyspawn% = 0
	END IF



'-----------------------------------------------------------------
' PLAYER MOVEMENT & BOUNDARY CHECKS
'-----------------------------------------------------------------
  
  
	ox% = x%
	x% = INT(x!)
	y% = INT(y!)

	IF mX - x% <> 0 THEN
		gunangle = ATN((mY - y%) / (mX - x%)) * 57
	ELSE
		gunangle = 90
	END IF
 
	IF xchng! > 1 THEN xchng! = 1
	IF xchng! < -1 THEN xchng! = -1
	x! = x! + xchng!

	'check that we haven't run into a wall.
	xblock% = (x! - 1) \ 8 + 1
	yblock% = y% \ 8
	IF Map(xblock%, yblock%) = 1 THEN
		IF xchng! <> 0 THEN
			IF x! > ox% THEN
				x! = x! - 1
				x% = x% - 1
				xchng! = 0
			ELSE
				x! = x! + 1
				x% = x% + 1
				xchng! = 0
			END IF
		END IF
		xchng! = 0
	END IF

  
	'check if there's still a floor here (and that we're not already in the air)
	xblock% = x% \ 8 + 1
	yblock% = y% \ 8 + 1
	IF Map(xblock%, yblock%) = 0 AND jump = 0 THEN
		ychng! = -jumpvertex
		jump = 2
	END IF

	'check if we're sitting 'in' a piece of floor...
	IF (y% > (yblock% - 1) * 8) AND jump = 0 THEN y! = y! - 1
	

	IF x! < 4 THEN x! = 4
	IF x! > 635 THEN x! = 635
	IF y! < 15 THEN ychng! = -jumpvertex
	IF y! > 479 THEN
		PutChar INT(x!) - 2, INT(y!) - 13, 0, 0, 7, 3
		PutChar INT(x!) - 2, INT(y!) - 5, 0, 0, 7, 3
		y! = 15
		y% = 15
	END IF

	IF jump <> 0 THEN
		y! = y! + ychng!
		IF jump = 1 THEN
			ychng! = ychng! - (ychng! / JumpFallOff)
			IF ychng! > jumpvertex THEN
				jump = 2
				ychng! = -ychng!
			END IF
			'check if the jump is broken by a ceiling piece
			xblock% = x% \ 8 + 1
			yblock% = (y% - 6) \ 8
			IF Map(xblock%, yblock%) = 1 THEN
				ychng! = -jumpvertex
				jump = 2
			END IF
		ELSE
			ychng! = ychng! + (ychng! / JumpFallOff)
			IF ychng! > 1 THEN ychng! = 1
		  
			'check if the fall is broken by a floor piece
			xblock% = x% \ 8 + 1
			yblock% = y% \ 8 + 1
			IF Map(xblock%, yblock%) = 1 THEN
				'y! = yblock% * 8 - 8
				ychng! = 0
				jump = 0
			END IF
		END IF
	END IF


'-----------------------------------------------------------------
' DRAWING THE PLAYER ON THE SCREEN
'-----------------------------------------------------------------

  
	IF ox% <> x% THEN
		cel% = cel% + 1
		ctr& = 0
	END IF

	IF cel% > 5 THEN cel% = 0

	IF MOVEMENT > 0 THEN
		SELECT CASE MOVEMENT
			CASE 1
				PutChar x% - 4, y% - 4, cel% + 161, 0, 4, 3
			CASE 2
				PutChar x% - 3, y% - 4, cel% + 193, 0, 4, 3
		END SELECT
		IF x% <= mX THEN
			PutChar x% - 3, y% - 12, 231 + ((gunangle + 90) \ 20), 0, 7, 7
		ELSE
			PutChar x% - 4, y% - 12, 231 + ((gunangle + 90) \ 20) + 9, 0, 7, 7
		END IF
	ELSE
		PutChar x% - 3, y% - 4, 199, 0, 4, 3
		IF x% <= mX THEN
			PutChar x% - 3, y% - 12, 231 + ((gunangle + 90) \ 20), 0, 7, 7
		ELSE
			PutChar x% - 4, y% - 12, 231 + ((gunangle + 90) \ 20) + 9, 0, 7, 7
		END IF
	END IF


'-----------------------------------------------------------------
' TIMERS
'-----------------------------------------------------------------


	enemyspawn% = enemyspawn% + 1

  ' score& = score& + ScorePerFrame

	ctr& = ctr& + 1

	IF ctr& > MovementTime AND MOVEMENT > 0 THEN
		ctr& = 0
		xchng! = 0
		MOVEMENT = MOVEMENT - 2
	END IF

	frames% = frames% + 1
	IF TIMER - timestore& > 1 THEN
		writestring 2, 5, "fps:" + STR$(frames%), 8, 7, 3
		frames% = 0
		timestore& = TIMER
	END IF

	'Vertical Retrace Wait
	framectr = framectr + 1
	IF framectr = framesperretrace THEN
		WAIT &H3DA, 8, 8
		WAIT &H3DA, 8
		framectr = 0
	END IF

	IF LifeStay% = 0 THEN
		Life! = Life! - (LifeOffPerCycle + (LifeOffExtraPerSecond * (TIMER - starttime&)))
	END IF

	IF Life! > 180 THEN Life! = 180

	IF Life! < 60 THEN
		IF bgpulsechng! = 0 THEN bgpulsechng! = .1
	ELSE
		bgpulsechng! = 0
		OUT &H3C8, 1
		OUT &H3C9, red(1)
		OUT &H3C9, green(1)
		OUT &H3C9, blue(1)
	END IF

	IF bgpulsechng! <> 0 THEN
		bgpulse! = bgpulse! + bgpulsechng!
		IF bgpulse! > 30 THEN bgpulsechng! = -ABS(bgpulsechng!)
		IF bgpulse! < 15 THEN bgpulsechng! = ABS(bgpulsechng!)
		OUT &H3C8, 1
		OUT &H3C9, INT(bgpulse!)
		OUT &H3C9, 0
		OUT &H3C9, 0
	END IF

	IF Invincible% > 0 THEN
		Invincible% = Invincible% - 1
		OUT &H3C8, 0
		OUT &H3C9, INT(Invincible% / 10)
		OUT &H3C9, INT(Invincible% / 10)
		OUT &H3C9, INT(Invincible% / 10)
	END IF

	IF LifeStay% > 0 THEN
		OUT &H3C8, 4
		OUT &H3C9, 63
		OUT &H3C9, 63
		OUT &H3C9, 63
		LifeStay% = LifeStay% - 1
		IF LifeStay% < 10 THEN
			OUT &H3C8, 4
			OUT &H3C9, red%(4)
			OUT &H3C9, green%(4)
			OUT &H3C9, blue%(4)
		END IF
	END IF

  

'-----------------------------------------------------------------
' OTHER SCREEN UPDATES
'-----------------------------------------------------------------
	 
	IF screenscore& < score& THEN
		screenscore& = screenscore& + (INT((score& - screenscore&) \ 100) + 1)
	END IF
	writestring 50, 440, STR$(screenscore&), 8, 7, 3

	writestring 201, 440, STR$(escaped&), 8, 7, 3
	writestring 201, 450, STR$(kills&), 8, 7, 3

	writestring 49, 450, LEFT$(STR$(TIMER - starttime&), 7), 8, 7, 3
	'WriteString 57, 460, "no limit", 8, 7, 3

	IF Life! < 0 THEN Life! = 0
	IF LastLife! > Life! THEN
		'LINE (INT(Life!), 458)-(INT(LastLife!), 466), 0, BF
		LINE (57 + INT(Life!), 458)-(57 + INT(LastLife!), 466), 0, BF
	END IF
	LastLife! = Life!
	LINE (57, 459)-STEP(INT(Life!), 7), 8, BF
	writestring 49, 460, STR$(INT(Life!)), 8, 7, 3

	IF Multikey(25) THEN
		WHILE Multikey%(25): WEND
		foo% = Multikey%(-2)
		writestring 296, 470, "Paused", 8, 7, 3
		DO: LOOP UNTIL INKEY$ <> ""
		foo% = Multikey%(-1)
		writestring 296, 470, "      ", 8, 7, 3
	END IF


LOOP UNTIL Multikey%(1) OR Life! = 0

'Kill the keyboard handler
WHILE Multikey%(1): WEND
foo% = Multikey%(-2)
WHILE INKEY$ <> "": WEND

Invincible% = 300

IF dev = 1 THEN END

gametime& = TIMER - starttime&

writestring 280, 280, "Game   Over", 8, 7, 4
starttime& = TIMER

WHILE INKEY$ = "" OR (TIMER - starttime&) < .2 'make the user wait a moment.
	IF Invincible% > 0 THEN Invincible% = Invincible% - 1
	OUT &H3C8, 0
	OUT &H3C9, INT(Invincible% / 10)
	OUT &H3C9, INT(Invincible% / 10)
	OUT &H3C9, INT(Invincible% / 10)
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
WEND

CLS
WEND

FUNCTION BitFlip% (source%)
	IF source% AND 128 THEN target = target + 1
	IF source% AND 64 THEN target = target + 2
	IF source% AND 32 THEN target = target + 4
	IF source% AND 16 THEN target = target + 8
	IF source% AND 8 THEN target = target + 16
	IF source% AND 4 THEN target = target + 32
	IF source% AND 2 THEN target = target + 64
	IF source% AND 1 THEN target = target + 128
	BitFlip% = target%
END FUNCTION

SUB GetMouseCord (K%, M3%, M4%)
Inregs.ax% = 3
CALL INTERRUPT(&H33, Inregs, Outregs)
M3% = Outregs.cx%
M4% = Outregs.dx%
K% = Outregs.bx%
END SUB

SUB HideMouse
Inregs.ax% = 2
CALL INTERRUPT(&H33, Inregs, Outregs)
END SUB

SUB HiScores (lastscore&, lasttime!, lastkills%, lastescapes%)
END SUB

'
' action: 1 to draw, 0 to erase
'
'
SUB HorizBar (y AS INTEGER, height AS LONG, action AS INTEGER, layer AS INTEGER)
	action% = action% * 255
	OUT &H3CF, layer% - 1: OUT &H3C5, bitfield(8 - layer%)
	P& = y%: P& = P& * 80
	FOR ctr& = 0 TO height& * 80 - 1
		POKE P& + ctr&, action%
	NEXT
END SUB

SUB keytest

SCREEN 0
CLS

Z = Multikey(-1)
DO
x = 1
y = 1

 FOR I = 1 TO 128
 
  TEST = Multikey(I)
  LOCATE y, x
  PRINT USING "## =###"; TEST; I

  IF y < 23 THEN
	y = y + 1
  ELSE
	y = 1
	x = x + 9
  END IF

 NEXT I

LOOP WHILE Multikey(1) = 0

Z = Multikey(-2)

END

END SUB

'
' 1 = Play
' 2 = instructions
' 3 = info
' 4 = quit
'
FUNCTION MainMenu% (lastscore AS LONG, lasttime AS LONG, lastkilled AS LONG, lastescaped AS LONG)

IF dev = 1 THEN
	MainMenu% = 1
	EXIT FUNCTION
END IF

cenX = 350
cenY = 360
selection% = 1

Option1Y = 420
OptionSpace = 10

IF lastscore& = 0 THEN
	barheight = 420
ELSE
	barheight = 440
END IF

done = 0

FOR a = 0 TO 14
	pal a, 0, 0, 0
NEXT

LINE (cenX, 0)-STEP(0, 480), 1, B
LINE (0, cenY)-STEP(640, 0), 1, B
LINE (cenX - 8, cenY - 8)-STEP(16, 16), 0, BF

FOR a = 0 TO 63 STEP 5
	pal 0, a, a, a
	pal 1, a, a, a
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT

FOR a = 63 TO 0 STEP -8
	pal 0, a, a, a
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT
 
pal 0, 63, 63, 63


CIRCLE (cenX, cenY), 15, 3

FOR a = 63 TO 0 STEP -4
	pal 0, a, a, a
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT

pal 0, 63, 63, 63
pal 4, 63, 63, 63

CIRCLE (cenX, cenY), 15, 1
writestring cenX - (5 * 40 + 30), cenY - 8, "micro", 40, 7, 1

FOR a = 63 TO 32 STEP -2
	pal 0, a, a, a
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT

pal 0, 63, 63, 63
pal 5, 63, 63, 63

writestring cenX + 60, cenY + 4, "rush", 32, 7, 1

writestring 8, 470, "www.angelfire.com/wizard/pigeoncarrier", 8, 7, 1
writestring 8, 470, "                                      ", 8, 7, 2
writestring 8, 470, "                                      ", 8, 7, 3
writestring 8, 470, "                                      ", 8, 7, 4

FOR a = 63 TO 40 STEP -1
	pal 0, a, a, a
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT

pal 8, a, a, a

writestring 400, Option1Y, "play", 16, 7, 4
writestring 407, Option1Y + OptionSpace, "instructions", 16, 7, 4
writestring 414, Option1Y + (OptionSpace * 2), "scores", 16, 7, 4
writestring 421, Option1Y + (OptionSpace * 3), "info", 16, 7, 4
writestring 428, Option1Y + (OptionSpace * 4), "quit", 16, 7, 4

FOR a = 40 TO 0 STEP -1
	pal 0, a, a, a
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT

HorizBar barheight - 2, 10, 1, 2
pal 3, 63, 63, 63


FOR a = 0 TO 20 STEP 2
	pal 2, a, a, a
	pal 10, a + 40, a + 40, a + 40
	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
NEXT

pal 4, 0, 0, 0


DO
	HorizBar OBarHeight - 2, 10, 0, 2
	HorizBar barheight - 2, 10, 1, 2
  
	rightheight = (selection - 1) * OptionSpace + Option1Y
	OBarHeight = barheight
	IF barheight <> rightheight THEN
		IF barheight > rightheight THEN
			barheight = barheight - 1
		ELSE
			barheight = barheight + 1
		END IF
	END IF

	keypress$ = INKEY$
  
	IF RIGHT$(keypress$, 1) = CHR$(72) AND selection > 1 THEN selection = selection - 1
	IF RIGHT$(keypress$, 1) = CHR$(80) AND selection < 5 THEN selection = selection + 1
  
	'a game just finished
	IF lastscore& <> 0 THEN
		selection% = 3
		keypress$ = CHR$(13)
	END IF
  
	IF keypress$ = CHR$(13) OR keypress$ = CHR$(32) THEN
		SELECT CASE selection%
			CASE 1
				FOR a = 63 TO 0 STEP -3
					FOR b = 1 TO 15
						pal b, a, a, a
					NEXT
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				MainMenu% = 1
				done = 1
			CASE 2 'instructions
				FOR a = 20 TO 0 STEP -2
					pal 2, a, a, a
					pal 10, a + 40, a + 40, a + 40
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				HorizBar OBarHeight - 2, 10, 0, 2

				writestring 400, 20, "instructions", 16, 7, 3
			 
				writestring 2, 50, "In the year 2094, international governments", 8, 7, 2
				writestring 2, 60, "develop a new way to battle the mob law of", 8, 7, 2
				writestring 2, 70, "worldwide terrorism: An elite corps of", 8, 7, 2
				writestring 2, 80, "highly trained special forces: Team Speed.", 8, 7, 2
				writestring 2, 105, "One of the steps in that training process", 8, 7, 2
				writestring 2, 115, "is the Microrush chamber.", 8, 7, 2
				writestring 2, 140, "The soldier is equipped with the standard", 8, 7, 2
				writestring 2, 150, "issue exojump-suit and placed in the", 8, 7, 2
				writestring 2, 160, "chamber. The helmet is not provided with", 8, 7, 2
				writestring 2, 170, "the suit during this exercise, so the", 8, 7, 2
				writestring 2, 180, "trainee has no source of oxygen except the", 8, 7, 2
				writestring 2, 190, "limited supply in the atmosphere of the", 8, 7, 2
				writestring 2, 200, "chamber.", 8, 7, 2
				writestring 2, 225, "The small walkers that enter the chamber", 8, 7, 2
				writestring 2, 235, "carry a small bubble of oxygen with them", 8, 7, 2
				writestring 2, 245, "which they release if destroyed. If they", 8, 7, 2
				writestring 2, 255, "contact the soldier, however, they consume", 8, 7, 2
				writestring 2, 265, "oxygen as penalty.", 8, 7, 2
				writestring 2, 290, "Points are recieved for destroying the", 8, 7, 2
				writestring 2, 300, "walkers, and oxygen is consumed as the game", 8, 7, 2
				writestring 2, 310, "wears on. If all is consumed, the soldier", 8, 7, 2
				writestring 2, 320, "falls unconcious.", 8, 7, 2
				writestring 50, 340, "You are that soldier.", 8, 7, 2
			  
				writestring 400, 85, CHR$(29) + "  move left and right", 8, 7, 2
				writestring 400, 100, CHR$(24) + "  jump", 8, 7, 2
				writestring 384, 120, "mouse to aim, click to fire", 8, 7, 2
			  
				HorizBar 18, 10, 1, 2
			
				FOR a = 0 TO 10
					pal 6, a * 6, a * 6, a * 6
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 0 TO 20 STEP 2
					pal 2, a, a, a
					pal 4, a * 3, a * 3, a * 3
					'pal 6, a * 3, a * 3, a * 3
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
			  
				WHILE INKEY$ = "": WEND
			 
				FOR a = 20 TO 0 STEP -2
					pal 2, a, a, a
					pal 4, a * 3, a * 3, a * 3
					'pal 6, a * 3, a * 3, a * 3
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 10 TO 0 STEP -1
					pal 6, a * 6, a * 6, a * 6
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				HorizBar 15, 350, 0, 2
				HorizBar 15, 350, 0, 3
				HorizBar OBarHeight - 2, 10, 1, 2
				FOR a = 0 TO 20 STEP 2
					pal 2, a, a, a
					pal 10, a + 40, a + 40, a + 40
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT

			CASE 3 'hiscores
				FOR a = 20 TO 0 STEP -2
					pal 2, a, a, a
					pal 10, a + 40, a + 40, a + 40
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				HorizBar OBarHeight - 2, 10, 0, 2

				writestring 400, 20, "best scores", 16, 7, 3
							
				writestring 10, 50, "Name", 8, 7, 3
				writestring 120, 50, "Seconds", 8, 7, 3
				writestring 202, 50, "K/E", 8, 7, 3
				writestring 298, 50, "Score", 8, 7, 3

				newscore% = 0

				FOR ctr% = 1 TO 10
					IF lastscore& > scores&(ctr) AND newscore% <> 1 THEN
						FOR shifter = 10 TO ctr STEP -1
							names$(shifter) = names$(shifter - 1)
							times!(shifter) = times!(shifter - 1)
							kills%(shifter) = kills%(shifter - 1)
							escapes%(shifter) = escapes%(shifter - 1)
							scores&(shifter) = scores&(shifter - 1)
						NEXT
						times!(ctr) = lasttime&
						kills%(ctr) = lastkilled&
						escapes%(ctr) = lastescaped&
						scores&(ctr) = lastscore&
						names$(ctr) = ""
						newscore% = ctr%
						lastscore& = 0
						HorizBar 49 + (ctr% * 22), 8, 1, 2
					END IF
					writestring 8, 50 + (ctr * 22), LEFT$(names$(ctr), 12), 8, 7, 3
					writestring 120, 50 + (ctr * 22), STR$(INT(times!(ctr))), 8, 7, 3
					writestring 192, 50 + (ctr * 22), STR$(kills%(ctr)) + "/" + RIGHT$(STR$(escapes%(ctr)), LEN(escapes%(ctr)) - 1), 8, 7, 3
					writestring 346 - (LEN(STR$(scores&(ctr))) * 8), 50 + (ctr * 22), STR$(scores&(ctr)), 8, 7, 3
				NEXT
				IF lastscore& <> 0 THEN
					writestring 120, 300, STR$(lasttime&), 8, 7, 2
					writestring 192, 300, STR$(lastkilled&) + "/" + RIGHT$(STR$(lastescaped&), LEN(STR$(lastescaped&)) - 1), 8, 7, 2
					writestring 346 - (LEN(STR$(lastscore&)) * 8), 300, STR$(lastscore&), 8, 7, 2
					lastscore& = 0
				END IF

				'HorizBar 15, 280, 1, 2
				HorizBar 18, 10, 1, 2
				HorizBar 57, 4, 1, 2
			 
				FOR a = 0 TO 10
					pal 6, a * 6, a * 6, a * 6
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 0 TO 20 STEP 2
					pal 2, a, a, a
					pal 4, a * 3, a * 3, a * 3
					'pal 6, a * 3, a * 3, a * 3
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT

				IF newscore% <> 0 THEN
					'curspos% = 1
					newname$ = ""
					DO
						keypress$ = INKEY$
						IF keypress$ <> "" THEN
							IF ASC(keypress$) >= 32 AND ASC(keypress$) <= 122 AND LEN(newname$) < 12 THEN
								newname$ = newname$ + keypress$
							END IF
							IF keypress$ = CHR$(8) AND LEN(newname$) > 0 THEN
								newname$ = LEFT$(newname$, LEN(newname$) - 1)
							END IF
						END IF
						writestring 8, 50 + (newscore% * 22), newname$ + CHR$(220) + CHR$(0), 8, 7, 3
					LOOP UNTIL keypress$ = CHR$(13)
					keypress$ = ""
					writestring 8, 50 + (newscore% * 22), newname$ + CHR$(0), 8, 7, 3

					names$(newscore%) = newname$

					OPEN "scores.run" FOR BINARY AS #1
					bytenum = 1
					FOR ctr = 1 TO 10
						tempname$ = ""
						FOR q = 1 TO LEN(names$(ctr))
							valu% = ASC(MID$(names$(ctr), q, 1)) - 32 + ctr
							PUT #1, bytenum, valu%
							bytenum = bytenum + 1
						NEXT
						valu% = 97 + ctr
						PUT #1, bytenum, valu%
						bytenum = bytenum + 1
					NEXT
					FOR ctr = 1 TO 10
						value! = scores&(ctr) / (ctr + 2)
						PUT #1, , value!
						value! = times!(ctr) / 23
						PUT #1, , value!
					NEXT
					FOR ctr = 1 TO 10
						valu% = -kills%(ctr)
						PUT #1, , valu%
						valu% = -escapes%(ctr)
						PUT #1, , valu%
					NEXT

					CLOSE #1
				END IF
				HorizBar 49 + (newscore% * 22), 8, 0, 2
				  
				WHILE INKEY$ = "": WEND
			  
			  
				FOR a = 20 TO 0 STEP -2
					pal 2, a, a, a
					pal 4, a * 3, a * 3, a * 3
					'pal 6, a * 3, a * 3, a * 3
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 10 TO 0 STEP -1
					pal 6, a * 6, a * 6, a * 6
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				HorizBar 15, 300, 0, 2
				HorizBar 15, 300, 0, 3


				HorizBar OBarHeight - 2, 10, 1, 2
				FOR a = 0 TO 20 STEP 2
					pal 2, a, a, a
					pal 10, a + 40, a + 40, a + 40
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				lastscore& = 0
			CASE 4 'info
				FOR a = 20 TO 0 STEP -2
					pal 2, a, a, a
					pal 10, a + 40, a + 40, a + 40
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				HorizBar OBarHeight - 2, 10, 0, 2

				writestring 400, 20, "info", 16, 7, 3
			
				writestring 2, 50, "Project Speed: Microrush:", 8, 7, 2
				writestring 2, 75, "This game is coded entirely in pure Qbasic", 8, 7, 2
				writestring 2, 85, "code. Thanks to Milo Sedlacek and Joe Huber", 8, 7, 2
				writestring 2, 95, "Jr. for the Multikey function.", 8, 7, 2
				writestring 2, 110, "This project was originally for a contest", 8, 7, 2
				writestring 2, 120, "at QbasicNews.com, but eventually became", 8, 7, 2
				writestring 2, 130, "merely 'an action game in pureQB.' My", 8, 7, 2
				writestring 2, 140, "second purpose with it was to prove once", 8, 7, 2
				writestring 2, 150, "and for all that asm libs are not necessary", 8, 7, 2
				writestring 2, 160, "to make a fast and graphical game.", 8, 7, 2
				writestring 2, 175, "Wizardcode is my site. The url is below.", 8, 7, 2
				writestring 2, 185, "I've dabbled in 3d art, music creation, and", 8, 7, 2
				writestring 2, 195, "several languages. You can find samples of", 8, 7, 2
				writestring 2, 205, "of my work on various fronts there.", 8, 7, 2
				writestring 2, 230, "This game is the last I will code in Qbasic.", 8, 7, 2
				writestring 2, 240, "I still very much respect the language as", 8, 7, 2
				writestring 2, 250, "an experimental and teaching tool, but it", 8, 7, 2
				writestring 2, 260, "no longer serves my needs.", 8, 7, 2
				writestring 2, 275, "Watch for Microrush II. Fully sidescrolling", 8, 7, 2
				writestring 2, 285, "and coded in Pascal.", 8, 7, 2
				writestring 2, 300, "Thanks to Trevor, Alex and Serge. TCD", 8, 7, 2
				writestring 2, 315, "Thanks all at qbnews, especially wildcard.", 8, 7, 2
				writestring 2, 325, "for keeping the site going.", 8, 7, 2

			 
				HorizBar 18, 10, 1, 2
		  
				FOR a = 0 TO 10
					pal 6, a * 6, a * 6, a * 6
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 0 TO 20 STEP 2
					pal 2, a, a, a
					pal 4, a * 3, a * 3, a * 3
					'pal 6, a * 3, a * 3, a * 3
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
			 
				WHILE INKEY$ = "": WEND
			
				FOR a = 20 TO 0 STEP -2
					pal 2, a, a, a
					pal 4, a * 3, a * 3, a * 3
					'pal 6, a * 3, a * 3, a * 3
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 10 TO 0 STEP -1
					pal 6, a * 6, a * 6, a * 6
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				HorizBar 15, 350, 0, 2
				HorizBar 15, 350, 0, 3
				HorizBar OBarHeight - 2, 10, 1, 2
				FOR a = 0 TO 20 STEP 2
					pal 2, a, a, a
					pal 10, a + 40, a + 40, a + 40
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT


			CASE 5 'quit
				MainMenu% = 4
				done = 1
				FOR a = 0 TO 20 STEP 1
					pal 0, a * 3 + 3, a * 3 + 3, a * 3 + 3
					pal 2, a * 2 + 20, a * 2 + 20, a * 2 + 20
					pal 8, 40 + a, 40 + a, 40 + a
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				LINE (0, 0)-(639, 479), 0, BF
				writestring 200, 236, "thx for playing", 16, 7, 1
				pal 1, 63, 63, 63
				FOR a = 63 TO 0 STEP -2
					pal 1, a, a, a
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
				FOR a = 60 TO 0 STEP -4
					pal 0, a, a, a
					WAIT &H3DA, 8, 8
					WAIT &H3DA, 8
				NEXT
		END SELECT
	END IF

	WAIT &H3DA, 8, 8
	WAIT &H3DA, 8
LOOP UNTIL done

END FUNCTION

FUNCTION Multikey (T)

STATIC kbcontrol%(), kbmatrix%(), Firsttime, StatusFlag

IF Firsttime = 0 THEN          'Initalize
 DIM kbcontrol%(128)
 DIM kbmatrix%(128)
 code$ = ""
 code$ = code$ + "E91D00E93C00000000000000000000000000000000000000000000000000"
 code$ = code$ + "00001E31C08ED8BE24000E07BF1400FCA5A58CC38EC0BF2400B85600FAAB"
 code$ = code$ + "89D8ABFB1FCB1E31C08EC0BF2400BE14000E1FFCFAA5A5FB1FCBFB9C5053"
 code$ = code$ + "51521E560657E460B401A8807404B400247FD0E088C3B700B0002E031E12"
 code$ = code$ + "002E8E1E100086E08907E4610C82E661247FE661B020E6205F075E1F5A59"
 code$ = code$ + "5B589DCF"

 DEF SEG = VARSEG(kbcontrol%(0))
 s = 0
 FOR I% = 1 TO LEN(code$) STEP 2           ' Load ASM
		d% = VAL("&h" + MID$(code$, I%, 2))
		POKE VARPTR(kbcontrol%(0)) + s, d%
		s = s + 1
 NEXT I%
 I& = 16       ' I think this stuff connects the interrupt with kbmatrix%()
 n& = VARSEG(kbmatrix%(0)): l& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE I&, l&: POKE I& + 1, h&: I& = I& + 2
 n& = VARPTR(kbmatrix%(0)): l& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE I&, l&: POKE I& + 1, h&: I& = I& + 2
 DEF SEG
 Firsttime = 1
END IF

SELECT CASE T
 CASE -1
  IF StatusFlag = 0 THEN
	DEF SEG = VARSEG(kbcontrol%(0))
	CALL ABSOLUTE(0)                     ' Run interrupt
	DEF SEG
	StatusFlag = 1
  END IF
 CASE -2
  IF StatusFlag = 1 THEN
	DEF SEG = VARSEG(kbcontrol%(0))      ' Turn off interrupt
	CALL ABSOLUTE(3)
	DEF SEG
	StatusFlag = 0
  END IF
 CASE 1 TO 128
  Multikey = kbmatrix%(T)               ' Return status
 CASE ELSE
  Multikey = 0                          ' User Supidity Error
END SELECT

END FUNCTION

SUB pal (n AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER)
	OUT &H3C8, n
	OUT &H3C9, r
	OUT &H3C9, g
	OUT &H3C9, b
END SUB

'
' layer% is to represent which of the four bits to toggle.
'
' layer% + 64 means draw only
' layer% + 128 means clear only
'
SUB pix12 (horizontal%, vertical%, layer%)
  
	IF (vertical% < 0) OR (horizontal% < 0) THEN EXIT SUB
	IF (vertical% > 479) OR (horizontal% > 639) THEN EXIT SUB

	DEF SEG = &HA000: OUT &H3CE, 4: OUT &H3C4, 2

	P& = vertical%: P& = P& * 80 + horizontal% \ 8
	bit% = bitfield(horizontal% AND 7): bitmask% = 255 - bit%


	IF layer% AND 128 THEN
		'clear
		layer% = layer% - 128
		OUT &H3CF, layer% - 1: OUT &H3C5, bitfield(8 - layer%)
		b% = PEEK(P&)
		IF (b% AND bit%) THEN
			b% = b% - bit%
			POKE P&, b%
		END IF
	ELSE
		IF layer% AND 64 THEN
			'set
			layer% = layer% - 64
			OUT &H3CF, layer% - 1: OUT &H3C5, bitfield(8 - layer%)
			b% = PEEK(P&) AND bitmask%
			b% = b% OR bit%
			POKE P&, b%
		ELSE
			'toggle (default)
			OUT &H3CF, layer% - 1: OUT &H3C5, bitfield(8 - layer%)
			b% = PEEK(P&)
			b% = b% XOR bit%
			POKE P&, b%
		END IF
	END IF
END SUB

SUB Put88 (column%, ystart%, where$)
									
	DEF SEG = &HA000

	home& = ystart%: home& = home& * 80 + column%

	FOR linectr% = 0 TO LEN(where$) - 1
		POKE home& + (linectr% * 80), ASC(MID$(where$, linectr% + 1, 1))
	NEXT
END SUB

'layer + 4 means shim it
SUB PutChar (x%, y%, cel%, startrow%, stoprow%, layer%)
	DEF SEG = &HA000
  
	home& = y%
  
	IF layer% > 4 THEN
		layer% = layer% - 4
		shim% = 1
	END IF

	OUT &H3CE, 4: OUT &H3C4, 2
	OUT &H3CF, layer% - 1: OUT &H3C5, bitfield(8 - layer%)

	home& = home& * 80 + x% \ 8

	IF shim% THEN
		POKE home& - 80, 0
		POKE home& - 79, 0
		POKE home& + ((stoprow% - startrow%) * 80) + 1, 0
	END IF

	Offset% = x% MOD 8
	IF Offset% < 0 THEN Offset% = Offset% + 8: home& = home& - 1
  
	IF Offset% = 0 THEN
		FOR linectr% = startrow% TO stoprow%
			POKE home& + (linectr% * 80), Info%(cel%, linectr%)
		NEXT
	ELSE
		IF x% > 0 THEN
			FOR linectr% = startrow% TO stoprow%
				POKE home& + (linectr% * 80), (Info%(cel%, linectr%) \ bitfield(7 - Offset%))
			NEXT
		END IF
		home& = home& + 1
		IF x% < 631 THEN
			FOR linectr% = startrow% TO stoprow%
				POKE home&, (Info%(cel%, linectr%) * bitfield(Offset% - 1))
				home& = home& + 80
			NEXT
		END IF
	END IF
END SUB

DEFSNG A-Z
SUB PutWhite (x%, y%)
	DEF SEG = &HA000           ': OUT &H3CE, 4: OUT &H3C4, 2
  
	P& = y%: P& = P& * 80 + x% \ 8
	bit% = bitfield(x% AND 7): bitmask% = 255 - bit%
	 
	'second is colour

	'OUT &H3CF, 1
	OUT &H3C5, 9
  
	b% = PEEK(P&) AND bitmask%
	b% = b% OR bit%
	POKE P&, b%
	'OUT &H3CF, 1: OUT &H3C5, 2: B% = PEEK(P&) AND bitmask%
	'IF (c% AND 2) <> 0 THEN B% = B% OR bit%
	'POKE P&, B%
	'OUT &H3CF, 2: OUT &H3C5, 4: B% = PEEK(P&) AND bitmask%
	'IF (c% AND 4) <> 0 THEN B% = B% OR bit%
	'POKE P&, B%
	'OUT &H3CF, 3: OUT &H3C5, 8: B% = PEEK(P&) AND bitmask%
	'IF (c% AND 8) <> 0 THEN B% = B% OR bit%
	'POKE P&, B%
END SUB

DEFINT A-Z
SUB ShowMouse
Inregs.ax = 1
CALL INTERRUPT(&H33, Inregs, Outregs)
END SUB

SUB StartMouse
Inregs.ax% = 0
CALL INTERRUPT(&H33, Inregs, Outregs)
Mouseinitialize% = Outregs.ax%
END SUB

SUB Store88 (column%, ystart%, ystop%, where$)
									 
	DEF SEG = &HA000

	home& = ystart%: home& = home& * 80 + column%

	where$ = STRING$(ystop% - ystart%, 0)

	FOR linectr% = 0 TO ystop% - ystart% - 1
		MID$(where$, linectr% + 1, 1) = CHR$(PEEK(home& + (linectr% * 80)) AND 255)
	NEXT
END SUB

SUB writestring (x%, y%, text$, wid%, height%, layer%)
	FOR thischr = 1 TO LEN(text$)
		PutChar x% + ((thischr - 1) * wid%), y%, ASC(MID$(text$, thischr, 1)), 0, height%, layer%
	NEXT
END SUB

